/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydecorations.block.furniture;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import eu.pb4.factorytools.api.block.BarrierBasedWaterloggable;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.resourcepack.BaseItemProvider;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockAwareAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TableBlock
extends class_2248
implements FactoryBlock,
BarrierBasedWaterloggable {
    public static final Corner NORTH_WEST = Corner.of(class_2350.field_11043, class_2350.field_11039);
    public static final Corner NORTH_EAST = Corner.of(class_2350.field_11043, class_2350.field_11034);
    public static final Corner SOUTH_WEST = Corner.of(class_2350.field_11035, class_2350.field_11039);
    public static final Corner SOUTH_EAST = Corner.of(class_2350.field_11035, class_2350.field_11034);
    public static final List<Corner> CORNERS = List.of(NORTH_WEST, NORTH_EAST, SOUTH_WEST, SOUTH_EAST);
    public static final Map<class_2350, List<Corner>> DIR_TO_CORNERS = ImmutableMap.builder().put((Object)class_2350.field_11043, List.of(NORTH_EAST, NORTH_WEST)).put((Object)class_2350.field_11035, List.of(SOUTH_EAST, SOUTH_WEST)).put((Object)class_2350.field_11034, List.of(SOUTH_EAST, NORTH_EAST)).put((Object)class_2350.field_11039, List.of(SOUTH_WEST, NORTH_WEST)).build();
    private final class_2248 base;
    private final TableModel model;

    public TableBlock(class_2960 identifier, class_4970.class_2251 settings, class_2248 planks) {
        super(settings);
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.model = TableModel.of(identifier);
        this.base = planks;
    }

    public class_2680 getPolymerBreakEventBlockState(class_2680 state, class_3222 player) {
        return this.base.method_9564();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TableBlock.NORTH_EAST.property, TableBlock.NORTH_WEST.property, TableBlock.SOUTH_EAST.property, TableBlock.SOUTH_WEST.property, WATERLOGGED});
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = this.method_9564();
        for (Corner corner : CORNERS) {
            boolean val = true;
            for (class_2382 off : corner.offsets) {
                if (!ctx.method_8045().method_8320(ctx.method_8037().method_10081(off)).method_27852((class_2248)this)) continue;
                val = false;
                break;
            }
            state = (class_2680)state.method_11657((class_2769)corner.property, (Comparable)Boolean.valueOf(val));
        }
        return this.waterLog(ctx, state);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        this.tickWater(state, world, pos);
        List<Corner> corners = DIR_TO_CORNERS.get(direction);
        if (corners == null) {
            return state;
        }
        for (Corner corner : corners) {
            boolean val = true;
            for (class_2382 off : corner.offsets) {
                if (!world.method_8320(pos.method_10081(off)).method_27852((class_2248)this)) continue;
                val = false;
                break;
            }
            state = (class_2680)state.method_11657((class_2769)corner.property, (Comparable)Boolean.valueOf(val));
        }
        return state;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return null;
    }

    @Nullable
    public ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState);
    }

    public record TableModel(class_1799[] models) {
        public static final int COUNT = (int)Math.pow(2.0, 4.0);

        private static TableModel of(class_2960 identifier) {
            class_1799[] models = new class_1799[COUNT];
            models[0] = BaseItemProvider.requestModel((class_1792)BaseItemProvider.requestModel(), (class_2960)identifier.method_45138("block/"));
            for (int i = 1; i < COUNT; ++i) {
                models[i] = BaseItemProvider.requestModel((class_1792)BaseItemProvider.requestModel(), (class_2960)identifier.method_45138("block/").method_48331("_" + i));
            }
            return new TableModel(models);
        }

        public class_1799 get(class_2680 state) {
            int i = 0;
            for (Corner corner : CORNERS) {
                if (((Boolean)state.method_11654((class_2769)corner.property)).booleanValue()) continue;
                i |= 1 << corner.id;
            }
            return this.models[i];
        }

        public static List<Corner> toCorners(int i) {
            ArrayList<Corner> list = new ArrayList<Corner>();
            for (int a = 0; a < CORNERS.size(); ++a) {
                if ((i >> a & 1) != 0) continue;
                list.add(CORNERS.get(a));
            }
            return list;
        }

        public static List<String> toCornerNames(int i) {
            ArrayList<String> list = new ArrayList<String>();
            for (int a = 0; a < CORNERS.size(); ++a) {
                if ((i >> a & 1) != 0) continue;
                list.add(TableBlock.CORNERS.get((int)a).name);
            }
            return list;
        }
    }

    public record Corner(int id, String name, class_2746 property, class_2350 dir1, class_2350 dir2, List<class_2382> offsets) {
        private static int gId = 0;

        private static Corner of(class_2350 dir, class_2350 dir2) {
            return new Corner(gId++, dir.method_10151() + "_" + dir2.method_10151(), class_2746.method_11825((String)(dir.method_10151() + "_" + dir2.method_10151() + "_corner")), dir, dir2, List.of(dir.method_10163(), dir2.method_10163()));
        }
    }

    public final class Model
    extends BlockModel {
        private final ItemDisplayElement main;

        public Model(class_2680 state) {
            this.main = ItemDisplayElementUtil.createSimple((class_1799)TableBlock.this.model.get(state));
            this.main.setDisplaySize(1.0f, 1.0f);
            this.main.setScale((Vector3fc)new Vector3f(2.0f));
            this.main.setYaw(180.0f);
            this.addElement((VirtualElement)this.main);
        }

        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockAwareAttachment.BLOCK_STATE_UPDATE) {
                class_2680 state = this.blockState();
                this.main.setItem(TableBlock.this.model.get(state));
                this.tick();
            }
        }
    }
}

