/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon;

import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.util.StructureLocator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_5819;
import net.minecraft.class_5820;

public class DungeonPlacement {
    public static boolean validChunkPos(IWorldEditor editor, class_1923 cpos) {
        int range = 10;
        class_1923 start = new class_1923(cpos.field_9181 - range, cpos.field_9180 - range);
        class_1923 end = new class_1923(cpos.field_9181 + range, cpos.field_9180 + range);
        ArrayList<class_1923> chunks = new ArrayList<class_1923>();
        for (int x = start.field_9181; x < end.field_9181; ++x) {
            for (int z = start.field_9180; z < end.field_9180; ++z) {
                chunks.add(new class_1923(x, z));
            }
        }
        class_1923 villageChunk = DungeonPlacement.findVillage(editor.getSeed(), chunks);
        if (villageChunk == null) {
            return false;
        }
        Coord village = Coord.of(villageChunk.method_33943(0));
        class_5819 rand = editor.getRandom(village);
        Coord chunkFrom = new Coord(cpos.field_9181, 0, cpos.field_9180);
        Coord chunkVillage = new Coord(villageChunk.field_9181, 0, villageChunk.field_9180);
        int chunkDist = chunkFrom.manhattanDistance(chunkVillage);
        if (chunkDist != 6) {
            return false;
        }
        Coord dirToDungeon = new Coord(rand.method_39332(-100, 100), 0, rand.method_39332(-100, 100));
        Coord chunkCenter = Coord.of(cpos.method_33943(0));
        Coord dirToChunk = chunkCenter.copy().sub(village);
        Coord projection = dirToChunk.project(dirToDungeon);
        Coord worldProj = projection.copy().add(village);
        class_1923 projChunk = worldProj.getChunkPos();
        double scalar = dirToChunk.scalar(dirToDungeon);
        if (scalar < 0.0) {
            return false;
        }
        return cpos.equals((Object)projChunk);
    }

    public static class_1923 findVillage(long seed, List<class_1923> chunks) {
        for (class_1923 cpos : chunks) {
            if (!StructureLocator.hasVillage(seed, cpos)) continue;
            return cpos;
        }
        return null;
    }

    public static boolean hasVillage(long seed, class_1923 cpos) {
        int chunkX = cpos.field_9181;
        int chunkZ = cpos.field_9180;
        int spacing = 34;
        int separation = 8;
        long magicNumber1 = 341873128712L;
        long magicNumber2 = 132897987541L;
        long salt = 10387312L;
        int x = chunkX;
        int z = chunkZ;
        if (chunkX < 0) {
            chunkX -= spacing - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= spacing - 1;
        }
        int xMod = chunkX / spacing;
        int zMod = chunkZ / spacing;
        long positionSeed = (long)xMod * magicNumber1 + (long)zMod * magicNumber2 + seed + salt;
        class_5820 rand = new class_5820(positionSeed);
        xMod *= spacing;
        zMod *= spacing;
        chunkX = x;
        chunkZ = z;
        return chunkX == (xMod += rand.method_43048(spacing - separation)) && chunkZ == (zMod += rand.method_43048(spacing - separation));
    }
}

