/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.fragment.parts;

import com.greymerk.roguelike.dungeon.fragment.IFragment;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.factories.BlockWeightedRandom;
import com.greymerk.roguelike.theme.ITheme;
import java.util.List;
import net.minecraft.class_2246;
import net.minecraft.class_5819;

public class Fungus
implements IFragment {
    static final int SIZE = 8;

    @Override
    public void generate(IWorldEditor editor, class_5819 rand, ITheme theme, Coord origin, Cardinal dir) {
        this.grow(editor, rand, origin.freeze(), 8);
    }

    public static void generate(IWorldEditor editor, class_5819 rand, Coord origin) {
        new Fungus().grow(editor, rand, origin.freeze(), 8);
    }

    private void grow(IWorldEditor editor, class_5819 rand, Coord origin, int counter) {
        if (!editor.isAir(origin)) {
            return;
        }
        if (counter < 2 && rand.method_43056() || counter == 0) {
            this.cap(editor, rand, origin);
            return;
        }
        MetaBlock.of(class_2246.field_10556).set(editor, origin);
        List<Cardinal> randDirs = Cardinal.randDirs(rand);
        if (rand.method_43048(5) == 0) {
            this.branch(editor, rand, origin.copy().add(randDirs.getFirst()).freeze(), randDirs.getFirst(), counter);
        }
        this.grow(editor, rand, origin.add(this.findPath(editor, rand, origin)), counter - 1);
    }

    private Cardinal findPath(IWorldEditor editor, class_5819 rand, Coord origin) {
        if (editor.isAir(origin.copy().add(Cardinal.UP)) && rand.method_43048(3) != 0) {
            return Cardinal.UP;
        }
        for (Cardinal dir : Cardinal.randDirs(rand)) {
            if (!editor.isAir(origin.copy().add(dir))) continue;
            return dir;
        }
        return Cardinal.UP;
    }

    private void branch(IWorldEditor editor, class_5819 rand, Coord origin, Cardinal dir, int counter) {
        MetaBlock stem = MetaBlock.of(class_2246.field_10556);
        if (!editor.isAir(origin)) {
            return;
        }
        stem.set(editor, origin);
        if (!editor.isAir(origin.copy().add(dir))) {
            return;
        }
        stem.set(editor, origin.copy().add(dir));
        this.grow(editor, rand, origin.copy().add(dir).add(Cardinal.UP), counter - 1);
    }

    private void cap(IWorldEditor editor, class_5819 rand, Coord origin) {
        BlockWeightedRandom flesh = new BlockWeightedRandom().addBlock(MetaBlock.of(rand.method_43056() ? class_2246.field_10580 : class_2246.field_10240), 3).addBlock(Air.get(), 1);
        if (rand.method_43048(3) != 0) {
            BoundingBox.of(origin).grow(Cardinal.directions).fill(editor, rand, flesh, true, false);
        } else {
            flesh.set(editor, rand, origin);
        }
    }
}

