/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.layout;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.boundingbox.IBounded;
import com.greymerk.roguelike.util.StructureLocator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExclusionZones {
    private Set<BoundingBox> zones = new HashSet<BoundingBox>();

    public void add(Coord pos, int range) {
        this.zones.add(BoundingBox.of(pos).grow(Cardinal.directions, range).grow(List.of(Cardinal.UP, Cardinal.DOWN), 64));
    }

    public boolean collides(IBounded room) {
        for (IBounded iBounded : this.zones) {
            if (!room.collide(iBounded)) continue;
            return true;
        }
        return false;
    }

    public void scan(IWorldEditor editor, Coord pos, int range) {
        Set<Coord> trialChambers = StructureLocator.scan(editor.getSeed(), pos, StructureLocator.TRIAL_CHAMBER, range);
        trialChambers.forEach(c -> this.add((Coord)c, 100));
    }

    public String toString() {
        return "Zones: " + this.zones.size() + " : " + List.of(this.zones).toString();
    }
}

