/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.dungeon.tower;

import com.greymerk.roguelike.dungeon.fragment.parts.SpiralStairCase;
import com.greymerk.roguelike.dungeon.tower.ITower;
import com.greymerk.roguelike.dungeon.tower.Tower;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.blocks.IronBar;
import com.greymerk.roguelike.editor.blocks.Torch;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.boundingbox.BoundingBox;
import com.greymerk.roguelike.editor.shapes.Line;
import com.greymerk.roguelike.editor.shapes.RectSolid;
import com.greymerk.roguelike.editor.shapes.Shape;
import com.greymerk.roguelike.theme.ITheme;
import net.minecraft.class_5819;

public class RogueTower
implements ITower {
    @Override
    public void generate(IWorldEditor editor, class_5819 rand, ITheme theme, Coord dungeon) {
        IBlockFactory walls = theme.getPrimary().getWall();
        IStair stair = theme.getPrimary().getStair();
        Coord origin = Tower.getBaseCoord(editor, dungeon).freeze();
        BoundingBox.of(origin).grow(Cardinal.directions, 3).grow(Cardinal.UP, 9).fill(editor, rand, Air.get());
        BoundingBox.of(origin).add(Cardinal.DOWN).grow(Cardinal.directions, 3).fill(editor, rand, walls);
        BoundingBox.of(origin).add(Cardinal.DOWN).grow(Cardinal.directions, 3).add(Cardinal.UP, 5).fill(editor, rand, walls);
        BoundingBox.of(origin).add(Cardinal.DOWN).grow(Cardinal.directions, 4).add(Cardinal.UP, 10).fill(editor, rand, walls);
        for (Cardinal dir : Cardinal.directions) {
            BoundingBox.of(origin).add(Cardinal.DOWN).add(dir, 4).grow(Cardinal.UP, 9).grow(Cardinal.orthogonal(dir), 3).fill(editor, rand, walls);
            BoundingBox.of(origin).add(dir, 3).add(Cardinal.left(dir), 3).grow(Cardinal.UP, 9).grow(Cardinal.DOWN).fill(editor, rand, theme.getPrimary().getPillar());
            BoundingBox.of(origin).add(dir, 3).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir), 3).fill(editor, rand, walls);
            BoundingBox.of(origin).add(dir, 3).add(Cardinal.UP, 3).grow(Cardinal.orthogonal(dir), 3).add(Cardinal.UP, 5).fill(editor, rand, walls);
            for (Cardinal o2 : Cardinal.orthogonal(dir)) {
                stair.setOrientation(Cardinal.reverse(o2), true).set(editor, rand, origin.copy().add(dir, 3).add(Cardinal.UP, 2).add(o2, 2));
                stair.setOrientation(Cardinal.reverse(o2), true).set(editor, rand, origin.copy().add(dir, 3).add(Cardinal.UP, 2).add(o2, 2).add(Cardinal.UP, 5));
            }
            BoundingBox.of(origin).add(Cardinal.UP, 9).add(dir, 5).grow(Cardinal.orthogonal(dir), 2).fill(editor, rand, walls);
            walls.set(editor, rand, origin.copy().add(Cardinal.UP, 10).add(dir, 6));
            walls.set(editor, rand, origin.copy().add(Cardinal.UP, 10).add(dir, 4).add(Cardinal.left(dir), 4));
            for (Cardinal o2 : Cardinal.orthogonal(dir)) {
                walls.set(editor, rand, origin.copy().add(Cardinal.UP, 9).add(dir, 5).add(o2, 2).add(Cardinal.UP));
                walls.set(editor, rand, origin.copy().add(Cardinal.UP, 9).add(dir, 5).add(o2, 2).add(Cardinal.UP).add(o2));
                this.addCrenellation(editor, rand, origin.copy().add(Cardinal.UP, 9).add(dir, 5).add(o2, 2).add(Cardinal.UP).add(o2).add(Cardinal.UP), walls);
                walls.set(editor, rand, origin.copy().add(Cardinal.UP, 9).add(dir, 6).add(o2).add(Cardinal.UP));
                this.addCrenellation(editor, rand, origin.copy().add(Cardinal.UP, 9).add(dir, 6).add(o2).add(Cardinal.UP).add(Cardinal.UP), walls);
            }
            walls.set(editor, rand, origin.copy().add(Cardinal.UP, 2).add(dir, 5));
            RectSolid.fill(editor, rand, BoundingBox.of(origin).add(dir, 5).grow(Cardinal.orthogonal(dir)).add(Cardinal.DOWN), walls);
            for (Cardinal o2 : Cardinal.orthogonal(dir)) {
                walls.set(editor, rand, origin.copy().add(dir, 5).add(o2));
                walls.set(editor, rand, origin.copy().add(dir, 5).add(o2).add(Cardinal.UP));
                stair.setOrientation(o2, false).set(editor, rand, origin.copy().add(dir, 5).add(o2).add(Cardinal.UP).add(Cardinal.UP));
            }
            stair.setOrientation(dir, true).set(editor, rand, origin.copy().add(Cardinal.UP, 4).add(dir, 5));
            for (Cardinal o2 : Cardinal.orthogonal(dir)) {
                stair.setOrientation(o2, true).set(editor, rand, origin.copy().add(Cardinal.UP, 4).add(dir, 5).add(o2));
            }
            stair.setOrientation(dir, true).set(editor, rand, origin.copy().add(dir, 5).add(Cardinal.UP, 7));
            walls.set(editor, rand, origin.copy().add(dir, 5).add(Cardinal.UP, 7).add(Cardinal.UP));
            stair.setOrientation(dir, true).set(editor, rand, origin.copy().add(dir, 5).add(Cardinal.UP, 7).add(Cardinal.UP).add(dir));
            walls.set(editor, rand, origin.copy().add(dir, 5).add(Cardinal.UP, 7).add(Cardinal.UP, 2).add(dir));
            walls.set(editor, rand, origin.copy().add(dir, 4).add(Cardinal.UP, 7).add(Cardinal.UP, 2).add(dir));
            for (Cardinal o2 : Cardinal.orthogonal(dir)) {
                stair.setOrientation(o2, true).set(editor, rand, origin.copy().add(dir, 5).add(Cardinal.UP, 7).add(o2));
                walls.set(editor, rand, origin.copy().add(dir, 5).add(Cardinal.UP, 8).add(o2));
                stair.setOrientation(o2, true).set(editor, rand, origin.copy().add(dir, 6).add(Cardinal.UP, 8).add(o2));
                walls.set(editor, rand, origin.copy().add(dir, 6).add(Cardinal.UP, 9).add(o2));
                walls.set(editor, rand, origin.copy().add(dir, 5).add(Cardinal.UP, 9).add(o2));
                stair.setOrientation(o2, true).set(editor, rand, origin.copy().add(dir, 5).add(Cardinal.UP, 8).add(o2, 2));
                walls.set(editor, rand, origin.copy().add(dir, 5).add(Cardinal.UP, 9).add(o2, 2));
                stair.setOrientation(o2, true).set(editor, rand, origin.copy().add(dir, 5).add(Cardinal.UP, 9).add(o2, 3));
            }
            BoundingBox.of(origin).add(dir, 4).grow(Cardinal.UP).fill(editor, rand, Air.get());
            BoundingBox.of(origin).add(dir, 4).grow(Cardinal.UP).add(Cardinal.UP, 5).fill(editor, rand, Air.get());
            Cardinal.orthogonal(dir).forEach(o -> IronBar.get().set(editor, rand, origin.copy().add(Cardinal.UP, 6).add(dir, 4).add((Cardinal)((Object)o), 2)));
            for (Cardinal o2 : Cardinal.orthogonal(dir)) {
                BoundingBox.of(origin).add(dir, 4).add(o2, 3).grow(Cardinal.UP, 3).fill(editor, rand, Air.get());
                stair.setOrientation(o2, true).set(editor, rand, origin.copy().add(dir, 4).add(o2, 3).add(Cardinal.UP, 4));
            }
            BoundingBox.of(origin.copy().add(Cardinal.DOWN).add(dir, 3).add(Cardinal.left(dir), 3), dungeon.copy().add(dir, 3).add(Cardinal.left(dir), 3)).fill(editor, rand, walls, true, false);
            BoundingBox.of(origin.copy().add(Cardinal.DOWN), dungeon.copy().add(Cardinal.UP, 4)).add(dir, 4).grow(Cardinal.orthogonal(dir), 3).fill(editor, rand, walls, true, false);
        }
        BoundingBox.of(origin.copy().add(Cardinal.DOWN), dungeon.copy().add(Cardinal.UP, 4)).grow(Cardinal.directions, 2).getShape(Shape.RECTHOLLOW).fill(editor, rand, walls, false, true);
        SpiralStairCase.generate(editor, rand, theme, Line.of(origin.copy().add(Cardinal.UP, 4), dungeon));
    }

    private void addCrenellation(IWorldEditor editor, class_5819 rand, Coord origin, IBlockFactory blocks) {
        blocks.set(editor, rand, origin.copy());
        Torch.generate(editor, Torch.WOODEN, Cardinal.UP, origin.copy().add(Cardinal.UP));
    }
}

