/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.greymerk.roguelike.editor.Cardinal;
import java.util.Objects;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;

public class Coord {
    public static final Coord ZERO = new Coord(0, 0, 0).freeze();
    boolean frozen = false;
    private int x;
    private int y;
    private int z;

    public static Coord of(class_2338 bp) {
        return new Coord(bp.method_10263(), bp.method_10264(), bp.method_10260());
    }

    public static Coord of(class_1923 cpos) {
        return new Coord(cpos.field_9181 << 4, 0, cpos.field_9180 << 4);
    }

    public static Coord of(class_2487 tag) {
        int x = tag.method_10550("x");
        int y = tag.method_10550("y");
        int z = tag.method_10550("z");
        return new Coord(x, y, z);
    }

    public Coord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coord copy() {
        return new Coord(this.x, this.y, this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Coord add(Cardinal dir) {
        return this.add(dir, 1);
    }

    public Coord add(Cardinal dir, int amount) {
        switch (dir) {
            case EAST: {
                if (this.frozen) {
                    return new Coord(this.x + amount, this.y, this.z);
                }
                this.x += amount;
                return this;
            }
            case WEST: {
                if (this.frozen) {
                    return new Coord(this.x - amount, this.y, this.z);
                }
                this.x -= amount;
                return this;
            }
            case UP: {
                if (this.frozen) {
                    return new Coord(this.x, this.y + amount, this.z);
                }
                this.y += amount;
                return this;
            }
            case DOWN: {
                if (this.frozen) {
                    return new Coord(this.x, this.y - amount, this.z);
                }
                this.y -= amount;
                return this;
            }
            case NORTH: {
                if (this.frozen) {
                    return new Coord(this.x, this.y, this.z - amount);
                }
                this.z -= amount;
                return this;
            }
            case SOUTH: {
                if (this.frozen) {
                    return new Coord(this.x, this.y, this.z + amount);
                }
                this.z += amount;
                return this;
            }
        }
        return this.frozen ? this.copy() : this;
    }

    public Coord add(Coord other) {
        if (this.frozen) {
            return new Coord(this.x + other.x, this.y + other.y, this.z + other.z);
        }
        this.x += other.x;
        this.y += other.y;
        this.z += other.z;
        return this;
    }

    public Coord sub(Coord other) {
        if (this.frozen) {
            return new Coord(this.x - other.x, this.y - other.y, this.z - other.z);
        }
        this.x -= other.x;
        this.y -= other.y;
        this.z -= other.z;
        return this;
    }

    public Coord mul(Coord other) {
        return new Coord(this.x * other.x, this.y * other.y, this.z * other.z);
    }

    public int dot(Coord other) {
        int xp = this.x * other.x;
        int yp = this.y * other.y;
        int zp = this.z * other.z;
        return xp + yp + zp;
    }

    public Coord project(Coord onto) {
        double dot = this.copy().dot(onto);
        double mag = onto.magnitude();
        double proj = dot / Math.pow(mag, 2.0);
        double px = proj * (double)onto.x;
        double py = proj * (double)onto.y;
        double pz = proj * (double)onto.z;
        return new Coord((int)Math.floor(px), (int)Math.floor(py), (int)Math.floor(pz));
    }

    public double scalar(Coord onto) {
        int dot = this.copy().dot(onto);
        double mag = onto.magnitude();
        return (double)dot / mag;
    }

    public double magnitude() {
        double xS = Math.pow(this.x, 2.0);
        double yS = Math.pow(this.y, 2.0);
        double zS = Math.pow(this.z, 2.0);
        double sumOfSquares = xS + yS + zS;
        return Math.sqrt(sumOfSquares);
    }

    public Coord unit() {
        return new Coord(this.x == 0 ? 0 : this.x / Math.abs(this.x), this.y == 0 ? 0 : this.y / Math.abs(this.y), this.z == 0 ? 0 : this.z / Math.abs(this.z));
    }

    public double distance(Coord other) {
        double side1 = Math.abs(this.getX() - other.getX());
        double side2 = Math.abs(this.getZ() - other.getZ());
        return Math.sqrt(side1 * side1 + side2 * side2);
    }

    public int manhattanDistance(Coord other) {
        int xdiff = Math.abs(this.x - other.x);
        int ydiff = Math.abs(this.y - other.y);
        int zdiff = Math.abs(this.z - other.z);
        return xdiff + ydiff + zdiff;
    }

    public Cardinal dirTo(Coord other) {
        int xdiff = other.x - this.x;
        int ydiff = other.y - this.y;
        int zdiff = other.z - this.z;
        if (Math.abs(ydiff) > Math.abs(xdiff) && Math.abs(ydiff) > Math.abs(zdiff)) {
            return Cardinal.UP;
        }
        if (Math.abs(xdiff) < Math.abs(zdiff)) {
            if (zdiff < 0) {
                return Cardinal.NORTH;
            }
            return Cardinal.SOUTH;
        }
        if (xdiff < 0) {
            return Cardinal.WEST;
        }
        return Cardinal.EAST;
    }

    public Coord freeze() {
        this.frozen = true;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        Object toReturn = "";
        toReturn = (String)toReturn + "x: " + this.x + " ";
        toReturn = (String)toReturn + "y: " + this.y + " ";
        toReturn = (String)toReturn + "z: " + this.z;
        return toReturn;
    }

    public boolean equals(Object o) {
        Coord other = (Coord)o;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public class_2338 getBlockPos() {
        return new class_2338(this.x, this.y, this.z);
    }

    public class_1923 getChunkPos() {
        return new class_1923(this.x >> 4, this.z >> 4);
    }

    public class_2520 getNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10566("x", (class_2520)class_2497.method_23247((int)this.x));
        nbt.method_10566("y", (class_2520)class_2497.method_23247((int)this.y));
        nbt.method_10566("z", (class_2520)class_2497.method_23247((int)this.z));
        return nbt;
    }

    public JsonElement asJson() {
        JsonObject jsonCoord = new JsonObject();
        jsonCoord.addProperty("x", (Number)this.x);
        jsonCoord.addProperty("y", (Number)this.y);
        jsonCoord.addProperty("z", (Number)this.z);
        return jsonCoord;
    }
}

