/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.blocks;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.blocks.Air;
import com.greymerk.roguelike.editor.factories.BlockWeightedRandom;
import com.greymerk.roguelike.editor.shapes.IShape;
import net.minecraft.class_2246;
import net.minecraft.class_2389;
import net.minecraft.class_5819;

public class IronBar
implements IBlockFactory {
    MetaBlock bar = MetaBlock.of(class_2246.field_10576);

    public static IronBar get() {
        return new IronBar();
    }

    public static IBlockFactory getBroken() {
        BlockWeightedRandom blocks = new BlockWeightedRandom();
        blocks.addBlock(Air.get(), 1);
        blocks.addBlock(IronBar.get(), 2);
        return blocks;
    }

    private void setShape(IWorldEditor editor, Coord origin) {
        for (Cardinal dir : Cardinal.directions) {
            this.setConnection(editor, origin, dir, this.connects(editor, origin, dir));
        }
    }

    private boolean connects(IWorldEditor editor, Coord origin, Cardinal dir) {
        if (editor.isFaceFullSquare(origin.copy().add(dir), Cardinal.reverse(dir))) {
            return true;
        }
        return editor.getBlock(origin.copy().add(dir)).getBlock() == class_2246.field_10576;
    }

    private void setConnection(IWorldEditor editor, Coord origin, Cardinal dir, boolean connects) {
        switch (dir) {
            case EAST: {
                this.bar.with(class_2389.field_10907, connects);
                return;
            }
            case NORTH: {
                this.bar.with(class_2389.field_10905, connects);
                return;
            }
            case SOUTH: {
                this.bar.with(class_2389.field_10904, connects);
                return;
            }
            case WEST: {
                this.bar.with(class_2389.field_10903, connects);
                return;
            }
        }
    }

    @Override
    public boolean set(IWorldEditor editor, class_5819 rand, Coord pos) {
        this.setShape(editor, pos);
        return this.bar.set(editor, rand, pos);
    }

    @Override
    public boolean set(IWorldEditor editor, class_5819 rand, Coord pos, boolean fillAir, boolean replaceSolid) {
        this.setShape(editor, pos);
        return this.bar.set(editor, rand, pos, fillAir, replaceSolid);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IShape shape, boolean fillAir, boolean replaceSolid) {
        this.bar.fill(editor, rand, shape, fillAir, replaceSolid);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IShape shape) {
        this.bar.fill(editor, rand, shape);
    }
}

