/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.blocks.door;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.blocks.door.DoorType;
import com.greymerk.roguelike.editor.blocks.door.IDoor;
import net.minecraft.class_2323;
import net.minecraft.class_2750;
import net.minecraft.class_2756;

public class Door
implements IDoor {
    DoorType type;

    public static Door of(DoorType type) {
        return new Door(type);
    }

    private Door(DoorType type) {
        this.type = type;
    }

    @Override
    public void generate(IWorldEditor editor, Coord pos, Cardinal dir) {
        Door.generate(editor, this.type, pos, dir, false);
    }

    @Override
    public void generate(IWorldEditor editor, Coord pos, Cardinal dir, boolean open) {
        Door.generate(editor, this.type, pos, dir, open);
    }

    public static void generate(IWorldEditor editor, Coord pos, Cardinal dir, DoorType type) {
        Door.generate(editor, type, pos, dir, false);
    }

    public static void generate(IWorldEditor editor, DoorType type, Coord pos, Cardinal dir, boolean open) {
        Coord cursor = pos.copy();
        MetaBlock doorBase = Door.setProperties(type, false, dir, open, false);
        doorBase.set(editor, cursor);
        cursor.add(Cardinal.UP);
        MetaBlock doorTop = Door.setProperties(type, true, dir, open, false);
        doorTop.set(editor, cursor);
    }

    private static MetaBlock setProperties(DoorType type, boolean top, Cardinal dir, boolean open, boolean hingeLeft) {
        return DoorType.get(type).with(class_2323.field_10946, top ? class_2756.field_12609 : class_2756.field_12607).with(class_2323.field_10938, Cardinal.facing(dir)).with(class_2323.field_10945, open).with(class_2323.field_10941, hingeLeft ? class_2750.field_12588 : class_2750.field_12586);
    }
}

