/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.blocks.spawners;

import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.editor.blocks.spawners.Spawner;
import com.greymerk.roguelike.treasure.loot.Equipment;
import com.greymerk.roguelike.treasure.loot.Quality;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_5819;

public class SpawnPotential {
    Spawner type;
    int weight;
    boolean equip;
    class_2487 nbt;

    public SpawnPotential(Spawner type) {
        this(type, 1);
    }

    public SpawnPotential(Spawner type, int weight) {
        this(type, true, weight, null);
    }

    public SpawnPotential(Spawner type, boolean equip, int weight) {
        this(type, equip, weight, null);
    }

    public SpawnPotential(Spawner type, boolean equip, int weight, class_2487 nbt) {
        this.type = type;
        this.equip = equip;
        this.weight = weight;
        this.nbt = nbt;
    }

    public class_2487 get(Difficulty diff) {
        class_2487 nbt = this.nbt == null ? new class_2487() : this.nbt.method_10553();
        return this.getPotential(this.getRoguelike(diff, this.type, nbt));
    }

    public class_2499 get(class_5819 rand, Difficulty diff) {
        class_2499 potentials = new class_2499();
        if (this.type == Spawner.ZOMBIE) {
            for (int i = 0; i < 24; ++i) {
                class_2487 mob = new class_2487();
                mob = this.getRoguelike(diff, this.type, mob);
                mob = this.equipHands(mob, Equipment.getName(switch (rand.method_43048(3)) {
                    case 0 -> Equipment.SHOVEL;
                    case 1 -> Equipment.AXE;
                    case 2 -> Equipment.PICK;
                    default -> Equipment.PICK;
                }, Quality.getToolQuality(rand, diff)), null);
                mob = this.equipArmour(mob, rand, diff);
                potentials.add((Object)this.getPotential(mob));
            }
            return potentials;
        }
        if (this.type == Spawner.SKELETON) {
            for (int i = 0; i < 12; ++i) {
                class_2487 mob = new class_2487();
                mob = this.getRoguelike(diff, this.type, mob);
                mob = this.equipHands(mob, "minecraft:bow", null);
                mob = this.equipArmour(mob, rand, diff);
                potentials.add((Object)this.getPotential(mob));
            }
            return potentials;
        }
        potentials.add((Object)this.getPotential(this.getRoguelike(diff, this.type, new class_2487())));
        return potentials;
    }

    public class_2487 getSpawnData(class_5819 rand, Difficulty diff) {
        return this.getSpawnData(this.getRoguelike(diff, this.type, new class_2487()));
    }

    private class_2487 getPotential(class_2487 mob) {
        class_2487 potential = new class_2487();
        potential.method_10566("data", (class_2520)this.getSpawnData(mob));
        potential.method_10569("weight", this.weight);
        return potential;
    }

    private class_2487 getSpawnData(class_2487 mob) {
        class_2487 data = new class_2487();
        data.method_10566("entity", (class_2520)mob);
        return data;
    }

    private class_2487 equipHands(class_2487 mob, String weapon, String offhand) {
        class_2499 hands = new class_2499();
        hands.add((Object)this.getItem(weapon));
        hands.add((Object)this.getItem(offhand));
        mob.method_10566("HandItems", (class_2520)hands);
        return mob;
    }

    private class_2487 equipArmour(class_2487 mob, class_5819 rand, Difficulty diff) {
        class_2499 armour = new class_2499();
        armour.add((Object)this.getItem(Equipment.getName(Equipment.FEET, Quality.getArmourQuality(rand, diff))));
        armour.add((Object)this.getItem(Equipment.getName(Equipment.LEGS, Quality.getArmourQuality(rand, diff))));
        armour.add((Object)this.getItem(Equipment.getName(Equipment.CHEST, Quality.getArmourQuality(rand, diff))));
        armour.add((Object)this.getItem(Equipment.getName(Equipment.HELMET, Quality.getArmourQuality(rand, diff))));
        mob.method_10566("ArmorItems", (class_2520)armour);
        return mob;
    }

    private class_2487 getItem(String itemName) {
        class_2487 item = new class_2487();
        if (itemName == null) {
            return item;
        }
        item.method_10582("id", itemName);
        item.method_10569("Count", 1);
        return item;
    }

    private class_2487 getRoguelike(Difficulty diff, Spawner type, class_2487 tag) {
        tag.method_10582("id", Spawner.getName(type));
        class_2499 activeEffects = new class_2499();
        tag.method_10566("active_effects", (class_2520)activeEffects);
        class_2487 buff = new class_2487();
        activeEffects.add((Object)buff);
        buff.method_10582("id", "minecraft:mining_fatigue");
        buff.method_10567("amplifier", (byte)diff.value);
        buff.method_10569("duration", 10);
        buff.method_10567("ambient", (byte)0);
        return tag;
    }
}

