/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.blocks.stair;

import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.editor.blocks.stair.IStair;
import com.greymerk.roguelike.editor.blocks.stair.Stair;
import com.greymerk.roguelike.editor.shapes.IShape;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2510;
import net.minecraft.class_2741;
import net.minecraft.class_2760;
import net.minecraft.class_2778;
import net.minecraft.class_5819;

public class MetaStair
implements IStair {
    MetaBlock stair;

    public static MetaStair of(class_2248 block) {
        return new MetaStair(block);
    }

    public static MetaStair of(Stair type) {
        return new MetaStair(type);
    }

    private MetaStair(class_2248 block) {
        this.stair = MetaBlock.of(block);
    }

    private MetaStair(Stair type) {
        this.stair = MetaBlock.of(Stair.getBlock(type));
    }

    private MetaStair(MetaBlock stair) {
        this.stair = stair;
    }

    @Override
    public MetaStair setOrientation(Cardinal dir, Boolean upsideDown) {
        this.stair.with(class_2510.field_11571, Cardinal.facing(dir));
        this.stair.with(class_2510.field_11572, upsideDown != false ? class_2760.field_12619 : class_2760.field_12617);
        this.stair.with(class_2741.field_12508, false);
        return this;
    }

    @Override
    public boolean set(IWorldEditor editor, class_5819 rand, Coord pos) {
        this.setStairShape(editor, pos);
        return this.stair.set(editor, rand, pos);
    }

    @Override
    public boolean set(IWorldEditor editor, class_5819 rand, Coord pos, boolean fillAir, boolean replaceSolid) {
        this.setStairShape(editor, pos);
        return this.stair.set(editor, rand, pos, fillAir, replaceSolid);
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IShape shape, boolean fillAir, boolean replaceSolid) {
        shape.get().forEach(pos -> this.set(editor, rand, (Coord)pos, fillAir, replaceSolid));
    }

    @Override
    public void fill(IWorldEditor editor, class_5819 rand, IShape shape) {
        this.fill(editor, rand, shape, true, true);
    }

    private void setStairShape(IWorldEditor editor, Coord pos) {
        MetaStair other;
        MetaBlock mb = editor.getBlock(pos.copy().add(this.direction()));
        if (this.isStair(mb) && (other = new MetaStair(mb)).isUpsideDown() == this.isUpsideDown()) {
            if (other.direction() == Cardinal.left(this.direction())) {
                this.setShape(class_2778.field_12712);
                return;
            }
            if (other.direction() == Cardinal.right(this.direction())) {
                this.setShape(class_2778.field_12713);
                return;
            }
        }
        if (this.isStair(mb = editor.getBlock(pos.copy().add(Cardinal.reverse(this.direction())))) && (other = new MetaStair(mb)).isUpsideDown() == this.isUpsideDown()) {
            if (other.direction() == Cardinal.left(this.direction())) {
                this.setShape(class_2778.field_12708);
                return;
            }
            if (other.direction() == Cardinal.right(this.direction())) {
                this.setShape(class_2778.field_12709);
                return;
            }
        }
        this.setShape(class_2778.field_12710);
    }

    public Cardinal direction() {
        return Cardinal.of((class_2350)this.stair.get(class_2510.field_11571));
    }

    public boolean isUpsideDown() {
        return this.stair.get(class_2510.field_11572) == class_2760.field_12619;
    }

    private boolean isStair(MetaBlock mb) {
        return mb.getBlock() instanceof class_2510;
    }

    private MetaStair setShape(class_2778 shape) {
        this.stair.with(class_2510.field_11565, shape);
        return this;
    }

    @Override
    public IStair waterlog() {
        this.stair.with(class_2741.field_12508, true);
        return this;
    }
}

