/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.factories;

import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.factories.BlockBase;
import net.minecraft.class_5819;

public class BlockCheckers
extends BlockBase {
    private IBlockFactory fillOne;
    private IBlockFactory fillTwo;
    private Coord offset;

    public BlockCheckers(IBlockFactory fillOne, IBlockFactory fillTwo, Coord offset) {
        this.fillOne = fillOne;
        this.fillTwo = fillTwo;
        this.offset = offset.copy();
    }

    public BlockCheckers(IBlockFactory fillOne, IBlockFactory fillTwo) {
        this(fillOne, fillTwo, Coord.ZERO);
    }

    @Override
    public boolean set(IWorldEditor editor, class_5819 rand, Coord origin, boolean fillAir, boolean replaceSolid) {
        int x = origin.getX() - this.offset.getX();
        int y = origin.getY() - this.offset.getY();
        int z = origin.getZ() - this.offset.getY();
        if (x % 2 == 0) {
            if (z % 2 == 0) {
                if (y % 2 == 0) {
                    return this.fillOne.set(editor, rand, origin.copy(), fillAir, replaceSolid);
                }
                return this.fillTwo.set(editor, rand, origin.copy(), fillAir, replaceSolid);
            }
            if (y % 2 == 0) {
                return this.fillTwo.set(editor, rand, origin.copy(), fillAir, replaceSolid);
            }
            return this.fillOne.set(editor, rand, origin.copy(), fillAir, replaceSolid);
        }
        if (z % 2 == 0) {
            if (y % 2 == 0) {
                return this.fillTwo.set(editor, rand, origin.copy(), fillAir, replaceSolid);
            }
            return this.fillOne.set(editor, rand, origin.copy(), fillAir, replaceSolid);
        }
        if (y % 2 == 0) {
            return this.fillOne.set(editor, rand, origin.copy(), fillAir, replaceSolid);
        }
        return this.fillTwo.set(editor, rand, origin.copy(), fillAir, replaceSolid);
    }
}

