/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.editor.factories;

import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IBlockFactory;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.factories.BlockBase;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_5819;

public class BlockLayers
extends BlockBase {
    private Map<Integer, IBlockFactory> layers;
    private IBlockFactory background;

    public BlockLayers(IBlockFactory background) {
        this.background = background;
        this.layers = new HashMap<Integer, IBlockFactory>();
    }

    public void addLayer(int offset, IBlockFactory toAdd) {
        this.layers.put(offset, toAdd);
    }

    @Override
    public boolean set(IWorldEditor editor, class_5819 rand, Coord pos, boolean fillAir, boolean replaceSolid) {
        for (int offset : this.layers.keySet()) {
            if (Math.floorMod(pos.getY(), 10) - offset != 0) continue;
            return this.layers.get(offset).set(editor, rand, pos, fillAir, replaceSolid);
        }
        return this.background.set(editor, rand, pos, fillAir, replaceSolid);
    }
}

