/*
 * Decompiled with CFR 0.152.
 */
package com.greymerk.roguelike.treasure.chest;

import com.greymerk.roguelike.config.Config;
import com.greymerk.roguelike.dungeon.Difficulty;
import com.greymerk.roguelike.editor.Cardinal;
import com.greymerk.roguelike.editor.Coord;
import com.greymerk.roguelike.editor.IWorldEditor;
import com.greymerk.roguelike.editor.MetaBlock;
import com.greymerk.roguelike.treasure.Inventory;
import com.greymerk.roguelike.treasure.Treasure;
import com.greymerk.roguelike.treasure.chest.ChestType;
import com.greymerk.roguelike.treasure.chest.ITreasureChest;
import com.greymerk.roguelike.treasure.loot.Loot;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2318;
import net.minecraft.class_2383;
import net.minecraft.class_2621;
import net.minecraft.class_2741;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;

public class TreasureChest
implements ITreasureChest {
    private Inventory inventory;
    private Treasure type;
    private class_2621 chest;
    private Difficulty diff;
    private MetaBlock block;

    public static Optional<ITreasureChest> generate(IWorldEditor editor, class_5819 rand, Coord pos, Treasure type, ChestType block) {
        Optional<ITreasureChest> chest = new TreasureChest(type, block, pos).set(editor, rand, pos);
        return chest;
    }

    public static Optional<ITreasureChest> generate(IWorldEditor editor, class_5819 rand, Coord pos, Cardinal dir, Treasure type, ChestType block) {
        Optional<ITreasureChest> chest = new TreasureChest(type, block, pos).set(editor, rand, pos, dir);
        return chest;
    }

    private Optional<ITreasureChest> set(IWorldEditor editor, class_5819 rand, Coord pos) {
        return this.set(editor, rand, pos, this.findOrientation(editor, rand, pos));
    }

    private TreasureChest(Treasure type, ChestType block, Coord pos) {
        this.type = type;
        this.block = ChestType.get(block);
        this.diff = Difficulty.fromY(pos.getY());
    }

    private Optional<ITreasureChest> set(IWorldEditor editor, class_5819 rand, Coord pos, Cardinal dir) {
        this.setOrientation(dir);
        if (!this.block.set(editor, pos)) {
            return Optional.empty();
        }
        this.chest = (class_2621)editor.getBlockEntity(pos);
        this.inventory = new Inventory(rand, this.chest);
        Optional<class_5321<class_52>> maybeTable = Treasure.getLootTable(this.type, this.diff);
        if (maybeTable.isPresent()) {
            this.setLootTable(maybeTable.get(), editor.getSeed(pos));
        }
        if (Config.ofBoolean(Config.ROGUELIKE_LOOT).booleanValue()) {
            Loot.fillChest(editor, this, rand);
        }
        return Optional.of(this);
    }

    public Cardinal findOrientation(IWorldEditor editor, class_5819 rand, Coord pos) {
        List<Cardinal> dirs = Cardinal.randDirs(rand);
        for (Cardinal dir : dirs) {
            Coord p = pos.copy();
            p.add(dir);
            if (!editor.isAir(pos)) continue;
            return dir;
        }
        return dirs.getFirst();
    }

    public void setOrientation(Cardinal dir) {
        class_2248 b = this.block.getBlock();
        if ((b == class_2246.field_10034 || b == class_2246.field_10380) && Cardinal.directions.contains((Object)dir)) {
            this.block.with(class_2383.field_11177, Cardinal.facing(dir).method_10153());
        }
        if (b == class_2246.field_16328) {
            this.block.with(class_2741.field_12525, Cardinal.facing(Cardinal.UP));
        }
        if (b == class_2246.field_10603) {
            this.block.with(class_2318.field_10927, Cardinal.facing(dir));
        }
    }

    @Override
    public boolean setSlot(int slot, class_1799 item) {
        return this.inventory.setInventorySlot(slot, item);
    }

    @Override
    public boolean setRandomEmptySlot(class_1799 item) {
        return this.inventory.setRandomEmptySlot(item);
    }

    @Override
    public boolean isEmptySlot(int slot) {
        return this.inventory.isEmptySlot(slot);
    }

    @Override
    public Treasure getType() {
        return this.type;
    }

    @Override
    public int getSize() {
        return this.inventory.getInventorySize();
    }

    @Override
    public Difficulty getLevel() {
        return this.diff;
    }

    public void setLootTable(class_5321<class_52> key, long seed) {
        this.chest.method_54867(key, seed);
    }
}

