/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.neoforge.networking;

import com.natamus.collective_common_neoforge.data.Constants;
import com.natamus.collective_common_neoforge.implementations.networking.PacketRegistrationHandler;
import com.natamus.collective_common_neoforge.implementations.networking.data.CommonPacketWrapper;
import com.natamus.collective_common_neoforge.implementations.networking.data.PacketContainer;
import com.natamus.collective_common_neoforge.implementations.networking.data.PacketContext;
import com.natamus.collective_common_neoforge.implementations.networking.data.Side;
import com.natamus.collective_common_neoforge.implementations.networking.exceptions.RegistrationException;
import java.util.function.Consumer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;

public class NeoForgeNetworkHandler
extends PacketRegistrationHandler {
    public NeoForgeNetworkHandler(Side side) {
        super(side);
    }

    @Override
    protected <T> void registerPacket(PacketContainer<T> container) {
    }

    @SubscribeEvent
    public void register(RegisterPayloadHandlersEvent event) {
        if (!this.PACKET_MAP.isEmpty()) {
            this.PACKET_MAP.forEach((type, container) -> event.registrar(container.getType().id().getNamespace()).optional().commonBidirectional(container.getType(), container.getCodec(), this.buildHandler(container.handler())));
        }
    }

    @Override
    public <T> void sendToServer(T packet) {
        this.sendToServer(packet, false);
    }

    @Override
    public <T> void sendToServer(T packet, boolean ignoreCheck) {
        PacketContainer container = (PacketContainer)this.PACKET_MAP.get(packet.getClass());
        if (container == null) {
            throw new RegistrationException(String.valueOf(packet.getClass()) + "{} packet not registered on the client, packets need to be registered on both sides!");
        }
        PacketDistributor.sendToServer(new CommonPacketWrapper<T>(container, packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public <T> void sendToClient(T packet, ServerPlayer player) {
        PacketContainer container = (PacketContainer)this.PACKET_MAP.get(packet.getClass());
        if (container != null) {
            if (player.connection.hasChannel(container.type())) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, new CommonPacketWrapper<T>(container, packet), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else {
            throw new RegistrationException(String.valueOf(packet.getClass()) + "{} packet not registered on the server, packets need to be registered on both sides!");
        }
    }

    private <T, K extends CommonPacketWrapper<T>> IPayloadHandler<K> buildHandler(Consumer<PacketContext<T>> handler) {
        return (payload, ctx) -> {
            try {
                Side side;
                Side side2 = side = ctx.flow().getReceptionSide().equals((Object)LogicalSide.SERVER) ? Side.SERVER : Side.CLIENT;
                if (Side.SERVER.equals((Object)side)) {
                    handler.accept(new PacketContext((Player)((ServerPlayer)ctx.player()), payload.packet(), side));
                } else {
                    handler.accept(new PacketContext(payload.packet(), side));
                }
            }
            catch (Throwable t) {
                Constants.LOG.error("Error handling packet: {} -> ", payload.packet().getClass(), (Object)t);
            }
        };
    }
}

