/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.renderer;

import com.anthonyhilyard.iceberg.Iceberg;
import com.anthonyhilyard.iceberg.services.Services;
import net.minecraft.class_1921;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class CheckedBufferSource
implements class_4597 {
    protected boolean hasRendered = false;
    protected final class_4597 bufferSource;
    private static Boolean useSodiumVersion = null;

    protected CheckedBufferSource(class_4597 bufferSource) {
        this.bufferSource = bufferSource;
    }

    public static CheckedBufferSource create(class_4597 bufferSource) {
        if (useSodiumVersion == null) {
            try {
                useSodiumVersion = Services.getPlatformHelper().getPlatformName().contentEquals("Fabric") && Services.getPlatformHelper().isModLoaded("sodium") && Services.getPlatformHelper().modVersionMeets("sodium", "0.5.9");
                useSodiumVersion = useSodiumVersion | (Services.getPlatformHelper().getPlatformName().contentEquals("NeoForge") && Services.getPlatformHelper().isModLoaded("embeddium") && Services.getPlatformHelper().modVersionMeets("embeddium", "1.0.0"));
            }
            catch (Exception e) {
                Iceberg.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        if (useSodiumVersion != null && useSodiumVersion.booleanValue()) {
            try {
                return Services.getBufferSourceFactory().createCheckedBufferSource(bufferSource);
            }
            catch (Exception e) {
                Iceberg.LOGGER.error(ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        return new CheckedBufferSource(bufferSource);
    }

    public class_4588 getBuffer(class_1921 renderType) {
        final class_4588 vertexConsumer = this.bufferSource.getBuffer(renderType);
        class_4588 vertexConsumerWrap = new class_4588(){

            public class_4588 method_22912(float x, float y, float z) {
                CheckedBufferSource.this.hasRendered = true;
                return vertexConsumer.method_22912(x, y, z);
            }

            public class_4588 method_1336(int r, int g, int b, int a) {
                return vertexConsumer.method_1336(r, g, b, a);
            }

            public class_4588 method_22913(float u, float v) {
                return vertexConsumer.method_22913(u, v);
            }

            public class_4588 method_60796(int u, int v) {
                return vertexConsumer.method_60796(u, v);
            }

            public class_4588 method_22921(int u, int v) {
                return vertexConsumer.method_22921(u, v);
            }

            public class_4588 method_22914(float x, float y, float z) {
                return vertexConsumer.method_22914(x, y, z);
            }
        };
        return vertexConsumerWrap;
    }

    public boolean hasRendered() {
        return this.hasRendered;
    }

    public void reset() {
        this.hasRendered = false;
    }
}

