/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.api.v1.hover;

import eu.pb4.polydex.api.v1.hover.HoverDisplay;
import eu.pb4.polydex.api.v1.hover.PolydexTarget;
import eu.pb4.polydex.impl.PolydexImpl;
import eu.pb4.polydex.impl.display.DisplayImpl;
import eu.pb4.polydex.impl.display.PolydexTargetImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface HoverDisplayBuilder {
    public static final ComponentType NAME = ComponentType.of(PolydexImpl.id("name"), true);
    public static final ComponentType MOD_SOURCE = ComponentType.of(PolydexImpl.id("mod_source"), false);
    public static final ComponentType HEALTH = ComponentType.of(PolydexImpl.id("health"), true);
    public static final ComponentType EFFECTS = ComponentType.of(PolydexImpl.id("effects"), true);
    public static final ComponentType INPUT = ComponentType.of(PolydexImpl.id("input"), false);
    public static final ComponentType FUEL = ComponentType.of(PolydexImpl.id("fuel"), false);
    public static final ComponentType OUTPUT = ComponentType.of(PolydexImpl.id("output"), false);
    public static final ComponentType PROGRESS = ComponentType.of(PolydexImpl.id("progress"), true);
    public static final ComponentType RAW_ID = ComponentType.of(PolydexImpl.id("raw_id"), false);

    public static void register(Consumer<HoverDisplayBuilder> consumer) {
        PolydexImpl.DISPLAY_BUILDER_CONSUMERS.add(consumer);
    }

    public static void register(class_2248 block, Consumer<HoverDisplayBuilder> consumer) {
        PolydexImpl.DISPLAY_BUILDER_CONSUMERS_BLOCK.computeIfAbsent(block, x -> new ArrayList()).add(consumer);
    }

    public static void register(class_1299<?> type, Consumer<HoverDisplayBuilder> consumer) {
        PolydexImpl.DISPLAY_BUILDER_CONSUMERS_ENTITY_TYPE.computeIfAbsent(type, x -> new ArrayList()).add(consumer);
    }

    public static HoverDisplayBuilder build(PolydexTarget target) {
        DisplayImpl builder = ((PolydexTargetImpl)target).getDisplayBuilder();
        builder.clear();
        if (builder.getDisplayType() != HoverDisplay.Type.NONE) {
            for (Consumer<HoverDisplayBuilder> consumer : PolydexImpl.DISPLAY_BUILDER_CONSUMERS) {
                consumer.accept(builder);
            }
        }
        return builder;
    }

    public static List<class_2561> buildText(PolydexTarget target) {
        return HoverDisplayBuilder.build(target).getOutput();
    }

    public boolean isSmall();

    public HoverDisplay.Type getDisplayType();

    public PolydexTarget getTarget();

    public void setComponent(ComponentType var1, class_2561 var2);

    @Nullable
    public class_2561 getComponent(ComponentType var1);

    public boolean removeComponent(ComponentType var1);

    @Nullable
    public class_2561 removeAndGetComponent(ComponentType var1);

    public Collection<ComponentType> getComponentTypes();

    public List<class_2561> getOutput();

    public record ComponentType(class_2960 identifier, Visibility defaultVisibility, @Deprecated boolean alwaysDisplay, int index) {
        private static final Set<ComponentType> KNOWN_COMPONENTS = new HashSet<ComponentType>();
        private static final Map<class_2960, ComponentType> ID = new HashMap<class_2960, ComponentType>();
        private static int currentIndex = 0;

        @Deprecated
        public ComponentType(class_2960 identifier, @Deprecated boolean alwaysDisplay, int index) {
            this(identifier, alwaysDisplay ? Visibility.ALWAYS : Visibility.NEVER, alwaysDisplay, index);
        }

        public ComponentType(class_2960 identifier, Visibility defaultVisibility, @Deprecated boolean alwaysDisplay, int index) {
            if (ID.containsKey(identifier)) {
                throw new RuntimeException("Duplicate ComponentType '" + String.valueOf(identifier) + "'");
            }
            KNOWN_COMPONENTS.add(this);
            ID.put(identifier, this);
            this.identifier = identifier;
            this.defaultVisibility = defaultVisibility;
            this.alwaysDisplay = alwaysDisplay;
            this.index = index;
        }

        public static ComponentType of(class_2960 identifier, boolean alwaysDisplay) {
            return new ComponentType(identifier, alwaysDisplay ? Visibility.ALWAYS : Visibility.NEVER, alwaysDisplay, currentIndex++);
        }

        public static ComponentType of(class_2960 identifier, Visibility displayMode) {
            return new ComponentType(identifier, displayMode, displayMode == Visibility.ALWAYS, currentIndex++);
        }

        public static Collection<ComponentType> getAll() {
            return KNOWN_COMPONENTS;
        }

        public static Collection<class_2960> getAllIds() {
            return ID.keySet();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComponentType component = (ComponentType)o;
            return Objects.equals(this.identifier, component.identifier);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.identifier);
        }

        public static enum Visibility {
            ALWAYS,
            SNEAKING,
            NEVER,
            DEFAULT;

        }
    }
}

