/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.brigadier.StringReader;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.polydex.api.v1.hover.HoverDisplay;
import eu.pb4.polydex.api.v1.hover.HoverDisplayBuilder;
import eu.pb4.polydex.api.v1.hover.PolydexTarget;
import eu.pb4.polydex.api.v1.recipe.PolydexCategory;
import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexIngredient;
import eu.pb4.polydex.api.v1.recipe.PolydexPage;
import eu.pb4.polydex.api.v1.recipe.PolydexPageUtils;
import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import eu.pb4.polydex.impl.FakeWorld;
import eu.pb4.polydex.impl.PolydexConfigImpl;
import eu.pb4.polydex.impl.PolydexImplUtils;
import eu.pb4.polydex.impl.PolydexInitializer;
import eu.pb4.polydex.impl.book.view.CustomPage;
import eu.pb4.polydex.impl.book.view.PotionRecipePage;
import eu.pb4.polydex.impl.book.view.ToolUseOnBlockPage;
import eu.pb4.polydex.mixin.AxeItemAccessor;
import eu.pb4.polydex.mixin.BrewingRecipeRegistryAccessor;
import eu.pb4.polydex.mixin.HoeItemAccessor;
import eu.pb4.polydex.mixin.ItemGroupAccessor;
import eu.pb4.polydex.mixin.ShovelItemAccessor;
import eu.pb4.polymer.core.api.item.PolymerItemGroupUtils;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.minecraft.class_124;
import net.minecraft.class_1275;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1856;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2291;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2968;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7708;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_8824;
import net.minecraft.class_9296;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PolydexImpl {
    private static final boolean POLYMER_CORE_LOADED = FabricLoader.getInstance().isModLoaded("polymer-core");
    public static final NodeParser PARSER = NodeParser.builder().simplifiedTextFormat().quickText().staticPreParsing().build();
    public static final Map<class_2960, Function<PolydexTarget, HoverDisplay>> DISPLAYS = new HashMap<class_2960, Function<PolydexTarget, HoverDisplay>>();
    public static final HashMap<Class<?>, Function<class_8786<?>, PolydexPage>> RECIPE_VIEWS = new HashMap();
    public static final List<PolydexPage.EntryModifier> ENTRY_MODIFIERS = new ArrayList<PolydexPage.EntryModifier>();
    public static final List<PolydexPage.PageCreator> PAGE_CREATORS = new ArrayList<PolydexPage.PageCreator>();
    public static final String ID = "polydex";
    public static final Map<class_1792, Function<class_1792, @Nullable Collection<PolydexEntry>>> ITEM_ENTRY_BUILDERS = new HashMap<class_1792, Function<class_1792, Collection<PolydexEntry>>>();
    public static final List<BiConsumer<MinecraftServer, PolydexEntry.EntryConsumer>> ENTRY_PROVIDERS = new ArrayList<BiConsumer<MinecraftServer, PolydexEntry.EntryConsumer>>();
    public static final PackedEntries ITEM_ENTRIES = PackedEntries.create();
    public static final Map<String, NamespacedEntry> BY_NAMESPACE = new HashMap<String, NamespacedEntry>();
    public static final Map<class_1761, NamespacedEntry> BY_ITEMGROUP = new HashMap<class_1761, NamespacedEntry>();
    public static final List<NamespacedEntry> NAMESPACED_ENTRIES = new ArrayList<NamespacedEntry>();
    public static final List<NamespacedEntry> ITEM_GROUP_ENTRIES = new ArrayList<NamespacedEntry>();
    public static final Map<PolydexCategory, List<PolydexPage>> CATEGORY_TO_PAGES = new Object2ObjectOpenHashMap();
    public static final Map<PolydexStack<?>, PolydexEntry> STACK_TO_ENTRY = new Object2ObjectOpenCustomHashMap(new Hash.Strategy<PolydexStack<?>>(){

        public int hashCode(PolydexStack<?> o) {
            return o.getSourceHashCode();
        }

        public boolean equals(PolydexStack<?> a, PolydexStack<?> b) {
            return a != null && b != null && a.matches(b, true);
        }
    });
    public static final Map<class_2960, PolydexPage> ID_TO_PAGE = new Object2ObjectOpenHashMap();
    public static final Map<class_1792, List<PolydexEntry>> ITEM_TO_ENTRIES = new Reference2ObjectOpenHashMap();
    public static final Logger LOGGER = LogManager.getLogger((String)"Polydex");
    public static final List<Consumer<HoverDisplayBuilder>> DISPLAY_BUILDER_CONSUMERS = new ArrayList<Consumer<HoverDisplayBuilder>>();
    public static final Map<class_2248, List<Consumer<HoverDisplayBuilder>>> DISPLAY_BUILDER_CONSUMERS_BLOCK = new IdentityHashMap<class_2248, List<Consumer<HoverDisplayBuilder>>>();
    public static final Map<class_1299<?>, List<Consumer<HoverDisplayBuilder>>> DISPLAY_BUILDER_CONSUMERS_ENTITY_TYPE = new IdentityHashMap();
    public static final Map<class_2960, List<CustomPage.ViewData>> CUSTOM_PAGES = new HashMap<class_2960, List<CustomPage.ViewData>>();
    public static final Map<class_2960, PolydexCategory> CATEGORY_BY_ID = new HashMap<class_2960, PolydexCategory>();
    public static final Map<class_1792, Function<class_1799, @Nullable PolydexEntry>> ITEM_ENTRY_CREATOR = new HashMap<class_1792, Function<class_1799, PolydexEntry>>();
    private static final Comparator<PolydexPage> PAGE_SORT = Comparator.comparingInt(x -> -x.priority()).thenComparing(PolydexPage::sortingId).thenComparing(PolydexPage::identifier);
    private static final Map<String, class_2561> MOD_NAMES = new HashMap<String, class_2561>();
    public static Codec<class_1799> ITEM_STACK_CODEC = class_1799.field_51397;
    public static Codec<class_2561> TEXT = Codec.either((Codec)Codec.STRING, (Codec)class_8824.field_46597).xmap(either -> (class_2561)either.map(x -> PARSER.parseText(x, ParserContext.of()), Function.identity()), Either::right);
    public static PolydexConfigImpl config = new PolydexConfigImpl();
    @Nullable
    private static CompletableFuture<Void> cacheBuilding = null;
    private static boolean isReady;

    public static boolean isReady() {
        return isReady;
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)ID, (String)path);
    }

    public static PolydexEntry getEntry(class_1799 stack) {
        if (!isReady) {
            return null;
        }
        PolydexStack<class_1799> pStack = PolydexStack.of(stack);
        PolydexEntry x = STACK_TO_ENTRY.get(pStack);
        if (x == null) {
            List list = ITEM_TO_ENTRIES.getOrDefault(stack.method_7909(), Collections.emptyList());
            for (PolydexEntry entry : list) {
                if (!entry.isPartOf(pStack)) continue;
                return entry;
            }
        }
        return x;
    }

    public static void rebuild(MinecraftServer server) {
        if (cacheBuilding != null) {
            LOGGER.warn("[Polydex] Cancelling unfinished matching");
            cacheBuilding.cancel(true);
        }
        isReady = false;
        LOGGER.info("[Polydex] Started matching recipes and items...");
        long time = System.currentTimeMillis();
        ((Consumer)PolydexPageUtils.BEFORE_PAGE_LOADING.invoker()).accept(server);
        Collection recipes = server.method_3772().method_8126();
        cacheBuilding = CompletableFuture.runAsync(() -> {
            try {
                PolydexImpl.updateCaches(server, recipes);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }).thenAcceptAsync(x -> {
            LOGGER.info("[Polydex] Done! It took {} ms", (Object)(System.currentTimeMillis() - time));
            isReady = true;
            cacheBuilding = null;
            ((Consumer)PolydexPageUtils.AFTER_PAGE_LOADING.invoker()).accept(server);
        }, (Executor)server);
    }

    private static List<ItemGroupData> getItemGroupEntries(MinecraftServer server) {
        ItemGroupData data;
        ArrayList<ItemGroupData> list = new ArrayList<ItemGroupData>();
        class_1761.class_8128 context = new class_1761.class_8128(server.method_30002().method_45162(), false, (class_7225.class_7874)server.method_30611());
        for (class_1761 group : class_7923.field_44687) {
            data = new ItemGroupData(class_7923.field_44687.method_10221((Object)group), group, context.comp_1251());
            ((ItemGroupAccessor)group).getEntryCollector().accept(context, (class_1761.class_7704)data);
            if (data.stacks.isEmpty()) continue;
            list.add(data);
        }
        if (POLYMER_CORE_LOADED) {
            for (class_1761 group : PolymerItemGroupUtils.REGISTRY) {
                data = new ItemGroupData(PolymerItemGroupUtils.REGISTRY.getId((Object)group), group, context.comp_1251());
                ((ItemGroupAccessor)group).getEntryCollector().accept(context, (class_1761.class_7704)data);
                if (data.stacks.isEmpty()) continue;
                list.add(data);
            }
        }
        return list;
    }

    public static void updateCaches(MinecraftServer server, Collection<class_8786<?>> recipes) {
        ITEM_ENTRIES.clear();
        BY_NAMESPACE.clear();
        BY_ITEMGROUP.clear();
        STACK_TO_ENTRY.clear();
        ITEM_TO_ENTRIES.clear();
        CATEGORY_TO_PAGES.clear();
        CATEGORY_BY_ID.clear();
        ID_TO_PAGE.clear();
        BY_NAMESPACE.put("minecraft", new NamespacedEntry("minecraft", (class_2561)class_2561.method_43470((String)"Minecraft (Vanilla)"), p -> class_1802.field_8270.method_7854(), PackedEntries.create()));
        NAMESPACED_ENTRIES.clear();
        ITEM_GROUP_ENTRIES.clear();
        final ObjectLinkedOpenHashSet polydexEntries = new ObjectLinkedOpenHashSet();
        PolydexEntry.EntryConsumer consumer = new PolydexEntry.EntryConsumer(){

            @Override
            public void accept(PolydexEntry entry) {
                polydexEntries.add((Object)entry);
            }

            @Override
            public void accept(PolydexEntry entry, class_1761 group) {
                PolydexImpl.BY_ITEMGROUP.computeIfAbsent((class_1761)group, (Function<class_1761, NamespacedEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, ofItemGroup(net.minecraft.class_1761 ), (Lnet/minecraft/class_1761;)Leu/pb4/polydex/impl/PolydexImpl$NamespacedEntry;)()).entries.add(entry);
                polydexEntries.add((Object)entry);
            }

            @Override
            public void acceptAll(Collection<PolydexEntry> entries) {
                polydexEntries.addAll(entries);
            }

            @Override
            public void acceptAll(Collection<PolydexEntry> entries, class_1761 group) {
                PolydexImpl.BY_ITEMGROUP.computeIfAbsent((class_1761)group, (Function<class_1761, NamespacedEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, ofItemGroup(net.minecraft.class_1761 ), (Lnet/minecraft/class_1761;)Leu/pb4/polydex/impl/PolydexImpl$NamespacedEntry;)()).entries.addAll(entries);
                polydexEntries.addAll(entries);
            }
        };
        for (BiConsumer<MinecraftServer, PolydexEntry.EntryConsumer> provider : ENTRY_PROVIDERS) {
            provider.accept(server, consumer);
        }
        ArrayList<PolydexPage> globalPages = new ArrayList<PolydexPage>(recipes.size());
        block1: for (class_8786<?> class_87862 : recipes) {
            for (Class baseClass = class_87862.comp_1933().getClass(); baseClass != Object.class; baseClass = baseClass.getSuperclass()) {
                Function<class_8786<?>, PolydexPage> view = RECIPE_VIEWS.get(baseClass);
                if (view == null) continue;
                PolydexPage page2 = view.apply(class_87862);
                if (page2 == null) continue block1;
                globalPages.add(page2);
                ID_TO_PAGE.put(page2.identifier(), page2);
                continue block1;
            }
        }
        for (PolydexPage.PageCreator pageCreator : PAGE_CREATORS) {
            pageCreator.createPages(server, page -> {
                globalPages.add((PolydexPage)page);
                ID_TO_PAGE.put(page.identifier(), (PolydexPage)page);
            });
        }
        for (PolydexPage polydexPage : globalPages) {
            block5: for (PolydexEntry entry : polydexEntries) {
                if (polydexPage.isOwner(server, entry)) {
                    entry.outputPages().add(polydexPage);
                }
                for (PolydexIngredient<?> ingredient : polydexPage.ingredients()) {
                    if (!ingredient.matches(entry.stack(), false)) continue;
                    entry.ingredientPages().add(polydexPage);
                    continue block5;
                }
            }
            for (PolydexCategory category : polydexPage.categories()) {
                CATEGORY_TO_PAGES.computeIfAbsent(category, x -> {
                    CATEGORY_BY_ID.put(x.identifier(), (PolydexCategory)x);
                    return new ArrayList();
                }).add(polydexPage);
            }
        }
        for (PolydexEntry polydexEntry : polydexEntries) {
            for (PolydexPage.EntryModifier viewBuilder : ENTRY_MODIFIERS) {
                viewBuilder.entryModifier(server, polydexEntry);
            }
        }
        for (PolydexEntry polydexEntry : polydexEntries) {
            polydexEntry.outputPages().sort(PAGE_SORT);
            polydexEntry.ingredientPages().sort(PAGE_SORT);
            ITEM_ENTRIES.add(polydexEntry);
            STACK_TO_ENTRY.put(polydexEntry.stack(), polydexEntry);
            if (polydexEntry.stack().getBackingClass() == class_1799.class) {
                ITEM_TO_ENTRIES.computeIfAbsent(((class_1799)polydexEntry.stack().getBacking()).method_7909(), a -> new ArrayList()).add(polydexEntry);
            }
            PolydexImpl.BY_NAMESPACE.computeIfAbsent((String)polydexEntry.identifier().method_12836(), (Function<String, NamespacedEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateCaches$9(eu.pb4.polydex.api.v1.recipe.PolydexEntry net.minecraft.server.MinecraftServer java.lang.String ), (Ljava/lang/String;)Leu/pb4/polydex/impl/PolydexImpl$NamespacedEntry;)((PolydexEntry)polydexEntry, (MinecraftServer)server)).entries.add(polydexEntry);
        }
        for (NamespacedEntry namespacedEntry : BY_NAMESPACE.values()) {
            namespacedEntry.entries.recalculateEmpty();
        }
        for (NamespacedEntry namespacedEntry : BY_ITEMGROUP.values()) {
            namespacedEntry.entries.recalculateEmpty();
        }
        for (List list : CATEGORY_TO_PAGES.values()) {
            list.sort(PAGE_SORT);
        }
        NAMESPACED_ENTRIES.addAll(BY_NAMESPACE.values());
        NAMESPACED_ENTRIES.sort(Comparator.comparing(s -> s.namespace));
        ITEM_GROUP_ENTRIES.addAll(BY_ITEMGROUP.values());
        ITEM_GROUP_ENTRIES.sort(Comparator.comparing(s -> s.namespace));
        config = PolydexConfigImpl.loadOrCreateConfig((class_7225.class_7874)server.method_30611());
    }

    public static void defaultEntries(MinecraftServer server, PolydexEntry.EntryConsumer consumer) {
        List<ItemGroupData> allGroups = PolydexImpl.getItemGroupEntries(server);
        for (ItemGroupData group : allGroups) {
            if (group.group.method_47312() != class_1761.class_7916.field_41052) continue;
            ObjectLinkedOpenHashSet groupEntries = new ObjectLinkedOpenHashSet();
            for (class_1799 item : group.stacks) {
                Function<class_1799, PolydexEntry> x = ITEM_ENTRY_CREATOR.get(item.method_7909());
                if (x != null) {
                    PolydexEntry y = x.apply(item);
                    if (y == null) continue;
                    groupEntries.add((Object)y);
                    continue;
                }
                groupEntries.add((Object)PolydexEntry.of(item));
            }
            consumer.acceptAll((Collection<PolydexEntry>)groupEntries, group.group);
        }
        for (class_1792 item : class_7923.field_41178) {
            Collection<PolydexEntry> custom;
            Function<class_1792, Collection<PolydexEntry>> func;
            if (item == class_1802.field_8162 || (func = ITEM_ENTRY_BUILDERS.get(item)) == null || (custom = func.apply(item)) == null) continue;
            consumer.acceptAll(custom);
        }
    }

    public static void potionRecipe(MinecraftServer server, Consumer<PolydexPage> consumer) {
        List<class_1845.class_1846<class_1792>> itemRecipes = ((BrewingRecipeRegistryAccessor)server.method_59777()).getItemRecipes();
        List<class_1845.class_1846<class_1842>> potionRecipes = ((BrewingRecipeRegistryAccessor)server.method_59777()).getPotionRecipes();
        for (class_1845.class_1846<class_1792> class_18462 : itemRecipes) {
            consumer.accept(new PotionRecipePage.ItemBase(class_2960.method_60654((String)("minecraft:brewing/item/" + ((class_5321)class_18462.comp_2190().method_40230().get()).method_29177().method_36181() + "/" + ((class_5321)class_18462.comp_2192().method_40230().get()).method_29177().method_36181())), class_18462));
        }
        for (class_1845.class_1846<class_1792> class_18463 : potionRecipes) {
            consumer.accept(new PotionRecipePage.PotionBase(class_2960.method_60654((String)("minecraft:brewing/potion/" + ((class_5321)class_18463.comp_2190().method_40230().get()).method_29177().method_36181() + "/" + ((class_5321)class_18463.comp_2192().method_40230().get()).method_29177().method_36181())), (class_1845.class_1846<class_1842>)class_18463));
        }
    }

    public static void defaultBuilder(HoverDisplayBuilder displayBuilder) {
        block26: {
            PolydexTarget target;
            block25: {
                List<Consumer<HoverDisplayBuilder>> list;
                target = displayBuilder.getTarget();
                class_1297 entity = target.entity();
                if (entity == null) break block25;
                displayBuilder.setComponent(HoverDisplayBuilder.NAME, entity.method_5476());
                displayBuilder.setComponent(HoverDisplayBuilder.RAW_ID, (class_2561)class_2561.method_43470((String)class_7923.field_41177.method_10221((Object)entity.method_5864()).toString()));
                if (PolydexImpl.config.displayModSource) {
                    displayBuilder.setComponent(HoverDisplayBuilder.MOD_SOURCE, PolydexImpl.getMod(class_7923.field_41177.method_10221((Object)entity.method_5864())));
                }
                if (entity instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity;
                    if (PolydexImpl.config.displayEntityHealth) {
                        displayBuilder.setComponent(HoverDisplayBuilder.HEALTH, (class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"\u2665 ").method_27692(class_124.field_1061)).method_27693("" + Math.min(class_3532.method_15386((float)livingEntity.method_6032()), class_3532.method_15386((float)livingEntity.method_6063()))).method_10852((class_2561)class_2561.method_43470((String)"/").method_27692(class_124.field_1080)).method_27693("" + class_3532.method_15386((float)livingEntity.method_6063())));
                    }
                    if (PolydexImpl.config.displayAdditional) {
                        ArrayList effects = new ArrayList();
                        if (livingEntity.method_5809()) {
                            effects.add(class_2561.method_43470((String)("\ud83d\udd25" + (livingEntity.method_32314() ? " " : ""))).method_27692(class_124.field_1065));
                        }
                        if (livingEntity.method_32314()) {
                            effects.add(class_2561.method_43470((String)"\u2744").method_27692(class_124.field_1075));
                        }
                        for (class_1293 effect : livingEntity.method_6026()) {
                            effects.add(class_2561.method_43470((String)"\u2697").method_10862(class_2583.field_24360.method_36139(((class_1291)effect.method_5579().comp_349()).method_5556())));
                        }
                        if (!effects.isEmpty()) {
                            displayBuilder.setComponent(HoverDisplayBuilder.EFFECTS, PolydexImplUtils.mergeText(effects, PolydexImplUtils.SPACE_SEPARATOR));
                        }
                    }
                }
                if ((list = DISPLAY_BUILDER_CONSUMERS_ENTITY_TYPE.get(entity.method_5864())) == null) break block26;
                for (Consumer consumer : list) {
                    consumer.accept(displayBuilder);
                }
                break block26;
            }
            if (target.blockState() != null) {
                List<Consumer<HoverDisplayBuilder>> list;
                Object object;
                displayBuilder.setComponent(HoverDisplayBuilder.RAW_ID, (class_2561)class_2561.method_43470((String)class_7923.field_41175.method_10221((Object)target.blockState().method_26204()).toString()));
                class_2586 class_25862 = target.blockEntity();
                if (class_25862 instanceof class_1275) {
                    class_1275 nameable = (class_1275)class_25862;
                    if (nameable.method_16914()) {
                        displayBuilder.setComponent(HoverDisplayBuilder.NAME, nameable.method_5797());
                    } else {
                        displayBuilder.setComponent(HoverDisplayBuilder.NAME, nameable.method_5476());
                    }
                } else {
                    class_2586 class_25863 = target.blockEntity();
                    if (class_25863 instanceof class_2631) {
                        class_2631 skull = (class_2631)class_25863;
                        class_9296 class_92962 = skull.method_11334();
                        if (class_92962 != null && class_92962.comp_2410().isPresent()) {
                            displayBuilder.setComponent(HoverDisplayBuilder.NAME, (class_2561)class_2561.method_43469((String)"block.minecraft.player_head.named", (Object[])new Object[]{class_92962.comp_2410().get()}));
                        } else {
                            displayBuilder.setComponent(HoverDisplayBuilder.NAME, (class_2561)target.blockState().method_26204().method_9518());
                        }
                    } else {
                        displayBuilder.setComponent(HoverDisplayBuilder.NAME, (class_2561)target.blockState().method_26204().method_9518());
                    }
                }
                if (PolydexImpl.config.displayModSource) {
                    displayBuilder.setComponent(HoverDisplayBuilder.MOD_SOURCE, PolydexImpl.getMod(class_7923.field_41175.method_10221((Object)target.blockState().method_26204())));
                }
                if (PolydexImpl.config.displayCantMine && (!target.player().method_7305(target.blockState()) || target.blockState().method_26165((class_1657)target.player(), (class_1922)target.player().method_37908(), target.pos()) <= 0.0f)) {
                    class_5250 text = class_2561.method_43470((String)"\u26cf").method_27692(class_124.field_1079);
                    if (!displayBuilder.isSmall()) {
                        text.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"text.polydex.cant_mine").method_27692(class_124.field_1061));
                    }
                    displayBuilder.setComponent(HoverDisplayBuilder.EFFECTS, (class_2561)text);
                }
                if (PolydexImpl.config.displayAdditional && (object = target.blockEntity()) instanceof class_2609) {
                    class_2609 furnace = (class_2609)object;
                    displayBuilder.setComponent(HoverDisplayBuilder.INPUT, PolydexPageUtils.createText(furnace.method_5438(0)));
                    displayBuilder.setComponent(HoverDisplayBuilder.FUEL, PolydexPageUtils.createText(furnace.method_5438(1)));
                    displayBuilder.setComponent(HoverDisplayBuilder.OUTPUT, PolydexPageUtils.createText(furnace.method_5438(2)));
                }
                if (PolydexImpl.config.displayMiningProgress && target.isMining()) {
                    displayBuilder.setComponent(HoverDisplayBuilder.PROGRESS, (class_2561)class_2561.method_43470((String)("" + (int)(target.breakingProgress() * 100.0f))).method_10852((class_2561)class_2561.method_43470((String)"%").method_27692(class_124.field_1080)));
                }
                if ((list = DISPLAY_BUILDER_CONSUMERS_BLOCK.get(target.blockState().method_26204())) != null) {
                    for (Consumer consumer : list) {
                        consumer.accept(displayBuilder);
                    }
                }
            }
        }
    }

    public static class_2561 getMod(class_2960 id) {
        return MOD_NAMES.computeIfAbsent(id.method_12836(), PolydexImpl::createModName);
    }

    private static class_2561 createModName(String s) {
        Optional container = FabricLoader.getInstance().getModContainer(s);
        if (container.isPresent()) {
            return class_2561.method_43470((String)((ModContainer)container.get()).getMetadata().getName());
        }
        return class_2561.method_43470((String)s);
    }

    public static Collection<PolydexPage> addCustomPages(MinecraftServer server, PolydexEntry entry) {
        ArrayList<PolydexPage> list = new ArrayList<PolydexPage>();
        for (CustomPage.ViewData custom : CUSTOM_PAGES.getOrDefault(entry.identifier(), Collections.emptyList())) {
            list.add(new CustomPage(custom.entryId(), custom));
        }
        return list;
    }

    public static void onReload(class_3300 manager) {
        CUSTOM_PAGES.clear();
        Map resources = manager.method_14488("polydex_page", path -> path.method_12832().endsWith(".json"));
        for (Map.Entry resource : resources.entrySet()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(((class_3298)resource.getValue()).method_14482()));){
                JsonElement json = JsonParser.parseReader((Reader)reader);
                DataResult result = CustomPage.ViewData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                result.result().ifPresent(viewData -> CUSTOM_PAGES.computeIfAbsent(viewData.entryId(), e -> new ArrayList()).add(viewData));
                result.error().ifPresent(error -> LOGGER.error("Failed to parse page at {}: {}", resource.getKey(), (Object)error.toString()));
            }
            catch (Exception e) {
                LOGGER.error("Failed to read page at {}", resource.getKey(), (Object)e);
            }
        }
    }

    public static PolydexEntry seperateCustomEnchantments(class_1799 stack) {
        class_9304 ench = class_1890.method_57532((class_1799)stack);
        StringBuilder string = new StringBuilder();
        ench.method_57534().forEach(e -> string.append(((class_5321)e.method_40230().get()).method_29177().method_36181()).append("/"));
        class_2960 baseId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        return PolydexEntry.of(baseId.method_48331("//" + String.valueOf(string)), stack);
    }

    public static PolydexEntry seperateCustomPotion(class_1799 stack) {
        class_1844 potion = (class_1844)stack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
        class_2960 baseId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        return PolydexEntry.of(baseId.method_48331("/" + ((class_6880)potion.comp_2378().get()).method_40230().map(class_5321::method_29177).orElse(class_2960.method_60654((String)"unknown")).method_36181()), stack);
    }

    public static void blockInteractions(MinecraftServer server, Consumer<PolydexPage> polydexPageConsumer) {
        class_1792 a;
        PolydexIngredient<class_1799> axes = PolydexIngredient.of(class_1856.method_8106((class_6862)class_3489.field_42612));
        PolydexIngredient<class_1799> shovels = PolydexIngredient.of(class_1856.method_8106((class_6862)class_3489.field_42615));
        PolydexIngredient<class_1799> hoes = PolydexIngredient.of(class_1856.method_8106((class_6862)class_3489.field_42613));
        Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
        for (Map.Entry<class_2248, class_2248> entry : AxeItemAccessor.getSTRIPPED_BLOCKS().entrySet()) {
            a = entry.getKey().method_8389();
            class_1792 class_17922 = entry.getValue().method_8389();
            if (a == null || class_17922 == null) continue;
            ((LinkedHashSet)map.computeIfAbsent((Object)class_17922, c -> new LinkedHashSet())).add(a);
        }
        for (Map.Entry entry : map.entrySet()) {
            polydexPageConsumer.accept(new ToolUseOnBlockPage(class_2960.method_60654((String)("stripping/" + class_7923.field_41178.method_10221((Object)((class_1792)entry.getKey())).method_43903() + "/" + class_7923.field_41178.method_10221((Object)((class_1792)((LinkedHashSet)entry.getValue()).getFirst())).method_43903())), axes, PolydexIngredient.of(class_1856.method_8091((class_1935[])((LinkedHashSet)entry.getValue()).toArray(new class_1935[0]))), PolydexStack.of((class_1792)entry.getKey())));
        }
        map = new Reference2ObjectOpenHashMap();
        for (Map.Entry entry : ShovelItemAccessor.getPATH_STATES().entrySet()) {
            a = ((class_2248)entry.getKey()).method_8389();
            class_1792 class_17923 = ((class_2680)entry.getValue()).method_26204().method_8389();
            if (a == null || class_17923 == null) continue;
            ((LinkedHashSet)map.computeIfAbsent((Object)class_17923, c -> new LinkedHashSet())).add(a);
        }
        for (Map.Entry entry : map.entrySet()) {
            polydexPageConsumer.accept(new ToolUseOnBlockPage(class_2960.method_60654((String)("flattening/" + class_7923.field_41178.method_10221((Object)((class_1792)entry.getKey())).method_43903() + "/" + class_7923.field_41178.method_10221((Object)((class_1792)((LinkedHashSet)entry.getValue()).getFirst())).method_43903())), shovels, PolydexIngredient.of(class_1856.method_8091((class_1935[])((LinkedHashSet)entry.getValue()).toArray(new class_1935[0]))), PolydexStack.of((class_1792)entry.getKey())));
        }
        try {
            var world = new FakeWorld(server){
                class_2680 state = class_2246.field_10124.method_9564();

                public boolean method_30092(class_2338 pos, class_2680 state, int flags, int maxUpdateDepth) {
                    if (state != this.state) {
                        this.state = state;
                        return true;
                    }
                    return false;
                }

                public class_2680 method_8320(class_2338 pos) {
                    return this.state;
                }
            };
            class_2968 placement = new class_2968((class_1937)world, class_2338.field_10980, class_2350.field_11033, class_1802.field_8527.method_7854(), class_2350.field_11033);
            Reference2ObjectOpenHashMap reference2ObjectOpenHashMap = new Reference2ObjectOpenHashMap();
            for (Map.Entry<class_2248, Pair<Predicate<class_1838>, Consumer<class_1838>>> entry : HoeItemAccessor.getTILLING_ACTIONS().entrySet()) {
                try {
                    class_1792 a2 = entry.getKey().method_8389();
                    class_2680 of = world.state = entry.getKey().method_9564();
                    ((Consumer)entry.getValue().getSecond()).accept(placement);
                    class_1792 b2 = world.state.method_26204().method_8389();
                    if (a2 == null || of.method_26204() == world.state.method_26204()) continue;
                    ((LinkedHashSet)reference2ObjectOpenHashMap.computeIfAbsent((Object)b2, c -> new LinkedHashSet())).add(a2);
                }
                catch (Throwable throwable) {}
            }
            for (Map.Entry entry : reference2ObjectOpenHashMap.entrySet()) {
                polydexPageConsumer.accept(new ToolUseOnBlockPage(class_2960.method_60654((String)("tilling/" + class_7923.field_41178.method_10221((Object)((class_1792)entry.getKey())).method_43903() + "/" + class_7923.field_41178.method_10221((Object)((class_1792)((LinkedHashSet)entry.getValue()).getFirst())).method_43903())), hoes, PolydexIngredient.of(class_1856.method_8091((class_1935[])((LinkedHashSet)entry.getValue()).toArray(new class_1935[0]))), PolydexStack.of((class_1792)entry.getKey())));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static /* synthetic */ NamespacedEntry lambda$updateCaches$9(PolydexEntry entry, MinecraftServer server, String x) {
        return NamespacedEntry.ofMod(x, entry.stack()::toTypeDisplayItemStack, server);
    }

    static {
        PolydexInitializer.init();
    }

    public static class ItemGroupData
    implements class_1761.class_7704 {
        public final Set<class_1799> stacks = class_7708.method_47572();
        public final class_1761 group;
        private final class_7699 enabledFeatures;
        public final class_2960 id;

        public ItemGroupData(class_2960 id, class_1761 group, class_7699 enabledFeatures) {
            this.group = group;
            this.id = id;
            this.enabledFeatures = enabledFeatures;
        }

        public void method_45417(class_1799 stack, class_1761.class_7705 visibility) {
            if (stack.method_7947() != 1) {
                throw new IllegalArgumentException("Stack size must be exactly 1");
            }
            if (stack.method_7909().method_45382(this.enabledFeatures)) {
                this.stacks.add(stack);
            }
        }
    }

    public record PackedEntries(List<PolydexEntry> all, List<PolydexEntry> nonEmpty, Map<class_2960, PolydexEntry> nonEmptyById) {
        public static PackedEntries create() {
            return new PackedEntries(new ArrayList<PolydexEntry>(), new ArrayList<PolydexEntry>(), new HashMap<class_2960, PolydexEntry>());
        }

        public List<PolydexEntry> get(boolean all) {
            return all ? this.all : this.nonEmpty;
        }

        public void clear() {
            this.all.clear();
            this.nonEmpty.clear();
            this.nonEmptyById.clear();
        }

        public void add(PolydexEntry entry) {
            this.all.add(entry);
            if (!entry.outputPages().isEmpty() || !entry.ingredientPages().isEmpty()) {
                this.nonEmpty.add(entry);
                this.nonEmptyById.put(entry.identifier(), entry);
            }
        }

        public void recalculateEmpty() {
            this.nonEmpty.clear();
            this.nonEmptyById.clear();
            for (PolydexEntry entry : this.all) {
                if (entry.outputPages().isEmpty() && entry.ingredientPages().isEmpty()) continue;
                this.nonEmpty.add(entry);
                this.nonEmptyById.put(entry.identifier(), entry);
            }
        }

        public void addAll(Collection<PolydexEntry> groupEntries) {
            this.all.addAll(groupEntries);
            for (PolydexEntry entry : groupEntries) {
                if (entry.outputPages().isEmpty() && entry.ingredientPages().isEmpty()) continue;
                this.nonEmpty.add(entry);
                this.nonEmptyById.put(entry.identifier(), entry);
            }
        }
    }

    public record NamespacedEntry(String namespace, class_2561 display, Function<class_3222, class_1799> icon, PackedEntries entries) {
        public static NamespacedEntry ofMod(String namespace, MinecraftServer server) {
            return NamespacedEntry.ofMod(namespace, PackedEntries.create(), server);
        }

        public static NamespacedEntry ofMod(String namespace, class_1799 defaultIcon, MinecraftServer server) {
            return NamespacedEntry.ofMod(namespace, (class_3222 p) -> defaultIcon, server);
        }

        public static NamespacedEntry ofMod(String namespace, Function<class_3222, class_1799> defaultIcon, MinecraftServer server) {
            return NamespacedEntry.ofMod(namespace, PackedEntries.create(), defaultIcon, server);
        }

        public static NamespacedEntry ofMod(String namespace, PackedEntries entries, MinecraftServer server) {
            class_1799 icon = class_1802.field_8529.method_7854();
            Optional<class_2960> id = class_7923.field_41178.method_10235().stream().filter(idx -> idx.method_12836().equals(namespace)).findFirst();
            if (id.isPresent()) {
                icon = ((class_1792)class_7923.field_41178.method_10223(id.get())).method_7854();
            }
            class_1799 finalIcon = icon;
            return NamespacedEntry.ofMod(namespace, entries, p -> finalIcon, server);
        }

        public static NamespacedEntry ofMod(String namespace, PackedEntries entries, Function<class_3222, class_1799> defaultIcon, MinecraftServer server) {
            Function<class_3222, class_1799> icon = defaultIcon;
            for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                try {
                    CustomValue val = mod.getMetadata().getCustomValue("polydex:entry/" + namespace);
                    if (val == null || val.getType() == CustomValue.CvType.NULL) continue;
                    CustomValue.CvObject obj = val.getAsObject();
                    Object display = obj.containsKey("name") ? PARSER.parseText(obj.get("name").getAsString(), ParserContext.of()) : class_2561.method_43470((String)mod.getMetadata().getName());
                    if (obj.containsKey("icon")) {
                        try {
                            class_2291.class_7215 itemStringReader = new class_2291((class_7225.class_7874)server.method_30611()).method_9789(new StringReader(obj.get("icon").getAsString()));
                            class_1799 iconStack = ((class_1792)itemStringReader.comp_628().comp_349()).method_7854();
                            if (itemStringReader.comp_2439() != null) {
                                iconStack.method_59692(itemStringReader.comp_2439());
                            }
                            icon = p -> iconStack;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return new NamespacedEntry(namespace, (class_2561)display, icon, entries);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                if (!mod.getMetadata().getId().equals(namespace)) continue;
                return new NamespacedEntry(namespace, (class_2561)class_2561.method_43470((String)mod.getMetadata().getName()), icon, entries);
            }
            return new NamespacedEntry(namespace, (class_2561)class_2561.method_43470((String)namespace), icon, entries);
        }

        public static NamespacedEntry ofItemGroup(class_1761 group) {
            return new NamespacedEntry(group.method_7737().getString(), group.method_7737(), p -> group.method_7747(), PackedEntries.create());
        }
    }
}

