/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.impl.book;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;

public class PolydexItemStackImpl
implements PolydexStack<class_1799> {
    private static final Interner<PolydexItemStackImpl> INTERNER = Interners.newWeakInterner();
    private final class_1799 stack;
    private final float chance;
    private final long count;

    public PolydexItemStackImpl(class_1799 stack, long count, float chance) {
        this.stack = stack.method_46651((int)Math.min(count, 64L));
        this.chance = chance;
        this.count = count;
    }

    public static PolydexStack<class_1799> of(class_1799 stack, long count, float chance) {
        return (PolydexStack)INTERNER.intern((Object)new PolydexItemStackImpl(stack, count, chance));
    }

    @Override
    public float chance() {
        return this.chance;
    }

    @Override
    public long amount() {
        return this.count;
    }

    @Override
    public boolean matchesDirect(PolydexStack<class_1799> stack, boolean strict) {
        return this.isEmpty() && stack.isEmpty() || (strict ? class_1799.method_31577((class_1799)this.stack, (class_1799)stack.getBacking()) : this.stack.method_31574(stack.getBacking().method_7909()));
    }

    @Override
    public boolean isEmpty() {
        return this.stack.method_7960();
    }

    @Override
    public class_2561 getName() {
        return this.stack.method_7964();
    }

    @Override
    public Class<class_1799> getBackingClass() {
        return class_1799.class;
    }

    @Override
    public class_1799 toItemStack(class_3222 player) {
        return this.stack.method_7972();
    }

    @Override
    @Nullable
    public <E> E get(class_9331<E> type) {
        return (E)this.stack.method_57824(type);
    }

    @Override
    public <E> E getOrDefault(class_9331<E> type, E fallback) {
        return (E)this.stack.method_57825(type, fallback);
    }

    @Override
    public boolean contains(class_9331<?> type) {
        return this.stack.method_57826(type);
    }

    @Override
    public class_1799 toDisplayItemStack(class_3222 player) {
        if (this.count == (long)this.stack.method_7947() && this.chance >= 1.0f) {
            return this.stack.method_7972();
        }
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        try {
            lore.addAll(this.stack.method_7950(class_1792.class_9635.method_59528((class_1937)player.method_37908()), (class_1657)player, (class_1836)class_1836.field_41070));
            lore.remove(0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        class_5250 extra = this.count > (long)this.stack.method_7914() && this.chance != 1.0f ? class_2561.method_43469((String)"text.polydex.item_stack.count_chance", (Object[])new Object[]{class_2561.method_43470((String)("" + this.count)).method_27692(class_124.field_1068), class_2561.method_43470((String)String.format("%.2f%%", Float.valueOf(this.chance * 100.0f))).method_27692(class_124.field_1068)}).method_27692(class_124.field_1054) : (this.count > (long)this.stack.method_7914() ? class_2561.method_43469((String)"text.polydex.item_stack.count", (Object[])new Object[]{class_2561.method_43470((String)("" + this.count)).method_27692(class_124.field_1068)}).method_27692(class_124.field_1054) : (this.chance != 1.0f ? class_2561.method_43469((String)"text.polydex.item_stack.chance", (Object[])new Object[]{class_2561.method_43470((String)String.format("%.2f%%", Float.valueOf(this.chance))).method_27692(class_124.field_1068)}).method_27692(class_124.field_1054) : null));
        if (extra != null) {
            lore.add(class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1063)).method_10852((class_2561)extra).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1063)));
        }
        return GuiElementBuilder.from((class_1799)this.stack).hideDefaultTooltip().setCount(this.count > (long)this.stack.method_7914() ? 1 : (int)this.count).setLore(lore).asStack();
    }

    @Override
    public class_1799 getBacking() {
        return this.stack;
    }

    @Override
    public int getSourceHashCode() {
        return System.identityHashCode(this.stack.method_7909());
    }
}

