/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polydex.impl.book.view;

import eu.pb4.polydex.api.v1.recipe.PageBuilder;
import eu.pb4.polydex.api.v1.recipe.PageIcons;
import eu.pb4.polydex.api.v1.recipe.PolydexCategory;
import eu.pb4.polydex.api.v1.recipe.PolydexEntry;
import eu.pb4.polydex.api.v1.recipe.PolydexIngredient;
import eu.pb4.polydex.api.v1.recipe.PolydexPage;
import eu.pb4.polydex.api.v1.recipe.PolydexStack;
import eu.pb4.polydex.impl.book.InternalPageTextures;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1845;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class PotionRecipePage<T>
implements PolydexPage {
    private final class_2960 identifier;
    protected final class_1845.class_1846<T> recipe;
    private final List<PolydexIngredient<?>> ingredient;

    public PotionRecipePage(class_2960 identifier, class_1845.class_1846<T> recipe) {
        this.identifier = identifier;
        this.recipe = recipe;
        this.ingredient = List.of(PolydexIngredient.of(recipe.comp_2191()), this.customIngredient());
    }

    @Override
    public boolean syncWithClient(class_3222 player) {
        return false;
    }

    @Override
    @Nullable
    public class_2561 texture(class_3222 player) {
        return InternalPageTextures.POTION;
    }

    @Override
    public class_2960 identifier() {
        return this.identifier;
    }

    @Override
    public List<PolydexIngredient<?>> ingredients() {
        return this.ingredient;
    }

    @Override
    public List<PolydexCategory> categories() {
        return List.of(PolydexCategory.BREWING);
    }

    @Override
    public boolean isOwner(MinecraftServer server, PolydexEntry entry) {
        return entry.stack().getBackingClass() == class_1799.class && this.isOwnerPotion((class_1799)entry.stack().getBacking());
    }

    protected abstract boolean isOwnerPotion(class_1799 var1);

    @Override
    public class_1799 typeIcon(class_3222 player) {
        return PageIcons.POTION_RECIPE_ICON;
    }

    @Override
    public void createPage(@Nullable PolydexEntry entry, class_3222 player, PageBuilder builder) {
        class_1799 base = this.getBaseStack(entry);
        class_1799 out = this.getOutStack(entry);
        builder.setIngredient(3, 1, this.recipe.comp_2191());
        if (!builder.hasTextures()) {
            builder.set(3, 2, new GuiElementBuilder(class_1802.field_8656).hideTooltip());
        }
        builder.setIngredient(3, 3, base);
        builder.setOutput(5, 2, out);
    }

    protected abstract class_1799 getBaseStack(@Nullable PolydexEntry var1);

    protected abstract class_1799 getOutStack(@Nullable PolydexEntry var1);

    protected abstract PolydexIngredient<class_1799> customIngredient();

    public static class PotionBase
    extends PotionRecipePage<class_1842> {
        public PotionBase(class_2960 identifier, class_1845.class_1846<class_1842> recipe) {
            super(identifier, recipe);
        }

        @Override
        protected boolean isOwnerPotion(class_1799 backing) {
            class_1844 x = (class_1844)backing.method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
            return x.comp_2378().map(class_6880::comp_349).orElse(null) == this.recipe.comp_2192().comp_349() && (backing.method_31574(class_1802.field_8574) || backing.method_31574(class_1802.field_8436) || backing.method_31574(class_1802.field_8150) || backing.method_31574(class_1802.field_8469));
        }

        @Override
        protected class_1799 getBaseStack(PolydexEntry entry) {
            class_1799 x = this.getStack(entry);
            x.method_57379(class_9334.field_49651, (Object)class_1844.field_49274.method_57403(this.recipe.comp_2190()));
            return x;
        }

        @Override
        protected class_1799 getOutStack(@Nullable PolydexEntry entry) {
            class_1799 x = this.getStack(entry);
            x.method_57379(class_9334.field_49651, (Object)class_1844.field_49274.method_57403(this.recipe.comp_2192()));
            return x;
        }

        @Override
        protected PolydexIngredient<class_1799> customIngredient() {
            return PotionIngredient.of((class_6880<class_1842>)this.recipe.comp_2190());
        }

        @Override
        public class_1799 entryIcon(@Nullable PolydexEntry entry, class_3222 player) {
            return this.getOutStack(entry);
        }

        protected class_1799 getStack(@Nullable PolydexEntry entry) {
            class_1799 backing;
            Object obj;
            if (entry != null && (obj = entry.stack().getBacking()) instanceof class_1799 && ((backing = (class_1799)obj).method_31574(class_1802.field_8574) || backing.method_31574(class_1802.field_8436) || backing.method_31574(class_1802.field_8150) || backing.method_31574(class_1802.field_8469))) {
                return backing.method_7909().method_7854();
            }
            return class_1802.field_8574.method_7854();
        }

        private record PotionIngredient(class_6880<class_1842> potion, List<PolydexStack<class_1799>> stacks) implements PolydexIngredient<class_1799>
        {
            public static PolydexIngredient<class_1799> of(class_6880<class_1842> input) {
                ArrayList<PolydexStack<class_1799>> list = new ArrayList<PolydexStack<class_1799>>();
                for (class_1792 x : new class_1792[]{class_1802.field_8574, class_1802.field_8436, class_1802.field_8150}) {
                    class_1799 y = x.method_7854();
                    y.method_57379(class_9334.field_49651, (Object)class_1844.field_49274.method_57403(input));
                    list.add(PolydexStack.of(y));
                }
                return new PotionIngredient(input, list);
            }

            @Override
            public List<PolydexStack<class_1799>> asStacks() {
                return this.stacks;
            }

            @Override
            public float chance() {
                return 1.0f;
            }

            @Override
            public long amount() {
                return 1L;
            }

            @Override
            public boolean matchesDirect(PolydexStack<class_1799> stack, boolean strict) {
                class_1844 potion = (class_1844)stack.getBacking().method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
                return this.potion.comp_349() == potion.comp_2378().map(class_6880::comp_349).orElse(null) && this.correctBase(stack.getBacking());
            }

            private boolean correctBase(class_1799 backing) {
                return backing.method_31574(class_1802.field_8574) || backing.method_31574(class_1802.field_8436) || backing.method_31574(class_1802.field_8150);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Class<class_1799> getBackingClass() {
                return class_1799.class;
            }
        }
    }

    public static class ItemBase
    extends PotionRecipePage<class_1792> {
        public ItemBase(class_2960 identifier, class_1845.class_1846<class_1792> recipe) {
            super(identifier, recipe);
        }

        @Override
        protected boolean isOwnerPotion(class_1799 backing) {
            return backing.method_31574((class_1792)this.recipe.comp_2192().comp_349());
        }

        @Override
        protected class_1799 getBaseStack(@Nullable PolydexEntry entry) {
            class_1799 input = ((class_1792)this.recipe.comp_2190().comp_349()).method_7854();
            input.method_57379(class_9334.field_49651, (Object)this.getPotion(entry));
            return input;
        }

        @Override
        protected class_1799 getOutStack(@Nullable PolydexEntry entry) {
            class_1799 input = ((class_1792)this.recipe.comp_2192().comp_349()).method_7854();
            input.method_57379(class_9334.field_49651, (Object)this.getPotion(entry));
            return input;
        }

        @Override
        protected PolydexIngredient<class_1799> customIngredient() {
            return PolydexIngredient.of(class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)this.recipe.comp_2190().comp_349()}));
        }

        private class_1844 getPotion(@Nullable PolydexEntry entry) {
            Object obj;
            if (entry != null && (obj = entry.stack().getBacking()) instanceof class_1799) {
                class_1799 backing = (class_1799)obj;
                return (class_1844)backing.method_57825(class_9334.field_49651, (Object)class_1844.field_49274);
            }
            return class_1844.field_49274;
        }

        @Override
        public class_1799 entryIcon(@Nullable PolydexEntry entry, class_3222 player) {
            return this.getOutStack(entry);
        }
    }
}

