/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.registry;

import com.mojang.authlib.GameProfile;
import eu.pb4.graves.model.GraveModelHandler;
import eu.pb4.graves.other.VisualGraveData;
import eu.pb4.graves.registry.AbstractGraveBlock;
import eu.pb4.graves.registry.AbstractGraveBlockEntity;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.sgui.api.gui.SignGui;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7923;

public class VisualGraveBlockEntity
extends AbstractGraveBlockEntity {
    public static class_2591<VisualGraveBlockEntity> BLOCK_ENTITY_TYPE;
    public class_2680 replacedBlockState = class_2246.field_10124.method_9564();
    private VisualGraveData visualData = VisualGraveData.DEFAULT;
    protected boolean isPlayerMade = false;
    protected class_2561[] textOverrides = null;
    private GraveModelHandler model;
    private Map<String, class_2561> cachedPlaceholders;

    public VisualGraveBlockEntity(class_2338 pos, class_2680 state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
    }

    public VisualGraveBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
    }

    public void setVisualData(VisualGraveData data, class_2680 oldBlockState) {
        this.replacedBlockState = oldBlockState;
        this.visualData = data;
        this.cachedPlaceholders = null;
        if (this.model != null) {
            this.model.setGrave(this);
        }
        this.method_5431();
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        super.method_11007(nbt, lookup);
        nbt.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.replacedBlockState));
        nbt.method_10566("VisualData", (class_2520)this.visualData.toNbt(lookup));
        nbt.method_10556("AllowModification", this.isPlayerMade);
        if (this.textOverrides != null) {
            class_2499 list = new class_2499();
            for (class_2561 text : this.textOverrides) {
                list.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)text, (class_7225.class_7874)lookup)));
            }
            nbt.method_10566("TextOverride", (class_2520)list);
        }
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        block4: {
            super.method_11014(nbt, lookup);
            try {
                this.visualData = VisualGraveData.fromNbt(nbt.method_10562("VisualData"), lookup);
                this.replacedBlockState = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)((class_2487)Objects.requireNonNull(nbt.method_10580("BlockState"))));
                if (nbt.method_10573("TextOverride", 9)) {
                    ArrayList<class_5250> textOverrides = new ArrayList<class_5250>();
                    for (class_2520 text : nbt.method_10554("TextOverride", 8)) {
                        textOverrides.add(class_2561.class_2562.method_10873((String)text.method_10714(), (class_7225.class_7874)lookup));
                    }
                    this.textOverrides = textOverrides.toArray(new class_2561[0]);
                }
            }
            catch (Exception e) {
                if (this.visualData != null) break block4;
                this.visualData = VisualGraveData.DEFAULT;
            }
        }
        this.cachedPlaceholders = null;
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        VisualGraveBlockEntity self;
        block5: {
            block4: {
                if (!(t instanceof VisualGraveBlockEntity)) break block4;
                self = (VisualGraveBlockEntity)t;
                if (!world.method_8608()) break block5;
            }
            return;
        }
        if (self.model == null) {
            self.model = (GraveModelHandler)BlockBoundAttachment.get((class_1937)world, (class_2338)pos).holder();
            self.model.setGrave(self);
        }
        self.model.maybeTick(world.method_8510());
    }

    protected Map<String, class_2561> createPlaceholders() {
        Map<String, class_2561> placeholder = this.getGrave().getPlaceholders(this.field_11863.method_8503());
        if (this.textOverrides != null) {
            placeholder.put("text_1", this.textOverrides[0]);
            placeholder.put("text_2", this.textOverrides[1]);
            placeholder.put("text_3", this.textOverrides[2]);
            placeholder.put("text_4", this.textOverrides[3]);
        } else {
            placeholder.put("text_1", (class_2561)class_2561.method_43473());
            placeholder.put("text_2", (class_2561)class_2561.method_43473());
            placeholder.put("text_3", (class_2561)class_2561.method_43473());
            placeholder.put("text_4", (class_2561)class_2561.method_43473());
        }
        return placeholder;
    }

    public VisualGraveData getGrave() {
        return this.visualData;
    }

    @Override
    public VisualGraveData getClientData() {
        return this.visualData;
    }

    @Override
    public void onModelChanged(String model) {
        if (this.model != null) {
            this.model.updateModel();
        }
    }

    public void openEditScreen(class_3222 player) {
        SignGui sign = new SignGui(player){

            public void onClose() {
                VisualGraveBlockEntity.this.textOverrides = new class_2561[]{this.getLine(0), this.getLine(1), this.getLine(2), this.getLine(3)};
                VisualGraveBlockEntity.this.cachedPlaceholders = null;
                VisualGraveBlockEntity.this.method_5431();
            }
        };
        sign.setSignType(class_2246.field_10231);
        if (this.textOverrides != null) {
            int i = 0;
            for (class_2561 text : this.textOverrides) {
                sign.setLine(i, (class_2561)text.method_27661());
                if (++i == 4) break;
            }
        }
        sign.open();
    }

    @Override
    public boolean isGraveProtected() {
        return (Boolean)this.method_11010().method_11654((class_2769)AbstractGraveBlock.IS_LOCKED);
    }

    @Override
    public boolean isGraveBroken() {
        return true;
    }

    @Override
    public boolean isGravePlayerMade() {
        return this.isPlayerMade;
    }

    @Override
    public boolean isGravePaymentRequired() {
        return false;
    }

    @Override
    public class_2561 getGravePlaceholder(String id) {
        Map<String, class_2561> x = this.cachedPlaceholders;
        if (x == null) {
            this.cachedPlaceholders = x = this.createPlaceholders();
        }
        return x.getOrDefault(id, EMPTY_TEXT);
    }

    @Override
    public GameProfile getGraveGameProfile() {
        return this.getGrave().gameProfile();
    }

    @Override
    public class_1799 getGraveSlotItem(int i) {
        return class_1799.field_8037;
    }

    @Override
    public class_1799 getGraveTaggedItem(class_2960 identifier) {
        return class_1799.field_8037;
    }

    @Override
    public class_1306 getGraveMainArm() {
        return this.getGrave().mainArm();
    }

    @Override
    public byte getGraveSkinModelLayers() {
        return this.getGrave().visualSkinModelLayers();
    }

    @Override
    public boolean isGravePlayerModelDelayed() {
        return false;
    }

    @Override
    public void updateModel() {
        if (this.model != null) {
            this.model.updateModel();
        }
    }
}

