/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.universalshops.trade;

import eu.pb4.common.economy.api.CommonEconomy;
import eu.pb4.common.economy.api.EconomyAccount;
import eu.pb4.common.economy.api.EconomyCurrency;
import eu.pb4.common.economy.api.EconomyTransaction;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.GuiInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.universalshops.gui.CurrencySlot;
import eu.pb4.universalshops.gui.ExtraGui;
import eu.pb4.universalshops.gui.GuiBackground;
import eu.pb4.universalshops.gui.GuiElements;
import eu.pb4.universalshops.gui.ShopGui;
import eu.pb4.universalshops.gui.setup.ItemModificatorGui;
import eu.pb4.universalshops.gui.setup.VirtualBalanceSettingsGui;
import eu.pb4.universalshops.other.EmptyInventory;
import eu.pb4.universalshops.other.TextUtil;
import eu.pb4.universalshops.other.USUtil;
import eu.pb4.universalshops.registry.TradeShopBlockEntity;
import eu.pb4.universalshops.trade.GenericHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class PriceHandler
extends GenericHandler {
    public static final Map<String, Definition> TYPES_MAP = new HashMap<String, Definition>();
    public static final List<Definition> TYPES = new ArrayList<Definition>();

    protected PriceHandler(Definition definition, TradeShopBlockEntity blockEntity) {
        super(definition, blockEntity);
    }

    public static void init() {
    }

    public abstract Result payFor(class_3222 var1, boolean var2);

    @Override
    public final class_2487 writeNbt(class_2487 nbt, class_7225.class_7874 lookup) {
        nbt.method_10582("PriceType", this.definition.type);
        nbt.method_10566("PriceValue", this.writeValueNbt(lookup));
        return nbt;
    }

    public static PriceHandler readNbt(class_2487 nbt, TradeShopBlockEntity blockEntity, class_7225.class_7874 lookup) {
        String type = nbt.method_10558("PriceType");
        Definition definition = TYPES_MAP.get(type);
        return definition != null ? (PriceHandler)definition.createFromNbt(nbt.method_10580("PriceValue"), blockEntity, lookup) : (PriceHandler)Invalid.DEFINITION.createInitial(blockEntity);
    }

    public static void register(Definition definition) {
        TYPES.add(definition);
        TYPES_MAP.put(definition.type, definition);
    }

    public boolean usesInventory() {
        return false;
    }

    @Override
    public boolean canSwitch() {
        return this.getInventory().method_5442();
    }

    public class_1263 getInventory() {
        return EmptyInventory.INSTANCE;
    }

    public void openInventory(class_3222 player, Runnable closeRunnable) {
    }

    static {
        PriceHandler.register(Invalid.DEFINITION);
        PriceHandler.register(SingleItem.DEFINITION);
        PriceHandler.register(Free.DEFINITION);
        PriceHandler.register(VirtualBalance.DEFINITION);
    }

    public static abstract class Definition
    extends GenericHandler.Definition<PriceHandler> {
        public Definition(String type, class_1792 icon) {
            this(type, (class_2561)TextUtil.of("pricehandler", type, new Object[0]), icon.method_7854());
        }

        public Definition(String type, class_2561 displayName, class_1799 icon) {
            super(type, displayName, icon);
        }
    }

    public static final class Invalid
    extends PriceHandler {
        public static final Definition DEFINITION = new Definition("invalid", (class_2561)TextUtil.text("not_set", new Object[0]), GuiElements.HEAD_QUESTION_MARK){

            @Override
            public PriceHandler createFromNbt(class_2520 element, TradeShopBlockEntity blockEntity, class_7225.class_7874 lookup) {
                return new Invalid(this, blockEntity);
            }

            @Override
            public PriceHandler createInitial(TradeShopBlockEntity blockEntity) {
                return new Invalid(this, blockEntity);
            }

            @Override
            public boolean canUse(class_3222 player) {
                return false;
            }
        };

        protected Invalid(Definition create, TradeShopBlockEntity blockEntity) {
            super(create, blockEntity);
        }

        @Override
        public Result payFor(class_3222 player, boolean canTake) {
            return Result.failed((class_2561)class_2561.method_43471((String)"todo"));
        }

        @Override
        public class_1799 icon() {
            return GuiElements.HEAD_QUESTION_MARK.method_7972();
        }

        @Override
        public boolean isSetup() {
            return false;
        }

        @Override
        protected class_2520 writeValueNbt(class_7225.class_7874 lookup) {
            return class_2481.method_23234((boolean)false);
        }

        @Override
        public class_2561 getText() {
            return TextUtil.text("not_set", new Object[0]).method_27692(class_124.field_1061);
        }

        @Override
        public int getMaxAmount(class_3222 player) {
            return 0;
        }
    }

    public static final class SingleItem
    extends PriceHandler
    implements ItemModificatorGui.ItemStackHolder {
        public static final Definition DEFINITION = new Definition("items", class_1802.field_8477){

            @Override
            public PriceHandler createFromNbt(class_2520 element, TradeShopBlockEntity blockEntity, class_7225.class_7874 lookup) {
                class_2487 nbt = (class_2487)element;
                SingleItem x = new SingleItem(this, class_1799.method_57359((class_7225.class_7874)lookup, (class_2487)nbt.method_10562("Value")), blockEntity);
                x.currencyInventory.method_7659(nbt.method_10554("CurrencyContainer", 10), lookup);
                return x;
            }

            @Override
            public PriceHandler createInitial(TradeShopBlockEntity blockEntity) {
                return new SingleItem(this, class_1799.field_8037, blockEntity);
            }
        };
        private class_1799 value;
        public final class_1277 currencyInventory = new class_1277(27);

        protected SingleItem(Definition creator, class_1799 initialValue, TradeShopBlockEntity blockEntity) {
            super(creator, blockEntity);
            this.value = initialValue;
            this.currencyInventory.method_5489((class_1265)blockEntity);
        }

        @Override
        public GuiElementInterface getSetupElement() {
            return ItemModificatorGui.stackHolderElement(this, true);
        }

        @Override
        public boolean usesInventory() {
            return true;
        }

        @Override
        public class_1263 getInventory() {
            return this.currencyInventory;
        }

        @Override
        public void openInventory(class_3222 player, final Runnable closeRunnable) {
            int i;
            SimpleGui gui = new SimpleGui(this, class_3917.field_18666, player, false){

                public void close() {
                    this.close(true);
                }

                public void onClose() {
                    closeRunnable.run();
                    super.onClose();
                }
            };
            gui.setTitle((class_2561)ExtraGui.texture(player, GuiBackground.SELECTOR).method_10852((class_2561)TextUtil.gui("shop.currency_storage", new Object[0])));
            for (i = 0; i < this.currencyInventory.method_5439(); ++i) {
                gui.setSlotRedirect(i, (class_1735)new CurrencySlot((class_1263)this.currencyInventory, i));
            }
            if (!ExtraGui.hasTexture(player)) {
                for (i = 0; i < 9; ++i) {
                    gui.setSlot(27 + i, (GuiElementInterface)GuiElements.FILLER);
                }
            }
            gui.setSlot(35, (GuiElementInterface)GuiElements.BACK);
            gui.open();
        }

        @Override
        public boolean canSwitch() {
            return this.currencyInventory.method_5442();
        }

        @Override
        public class_2561 getText() {
            return USUtil.asText(this.value);
        }

        @Override
        public int getMaxAmount(class_3222 player) {
            int a = USUtil.transfer((class_1263)player.method_31548(), this::equalsValue, Integer.MAX_VALUE, true, USUtil.ALWAYS_ALLOW);
            return a / this.value.method_7947();
        }

        @Override
        public Result payFor(class_3222 player, boolean canTake) {
            class_1277 chest = USUtil.copyInventory((class_1263)this.currencyInventory);
            int count = USUtil.transfer((class_1263)player.method_31548(), this::equalsValue, this.value.method_7947(), true, this.shop.isAdmin() ? USUtil.ALWAYS_ALLOW : USUtil.addToInventory((class_1263)chest));
            if (count >= this.value.method_7947()) {
                if (canTake) {
                    USUtil.transfer((class_1263)player.method_31548(), this::equalsValue, this.value.method_7947(), false, this.shop.isAdmin() ? USUtil.ALWAYS_ALLOW : USUtil.addToInventory((class_1263)this.currencyInventory));
                }
                return Result.successful();
            }
            return Result.failed((class_2561)TextUtil.text(USUtil.canInsert((class_1263)chest, this.value, this.value.method_7947()) ? "not_enough_currency" : "not_enough_shop_storage_space", this.value.method_7964().method_27661().method_27694(x -> x.method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(this.value)))), this.value.method_7947(), count));
        }

        private boolean equalsValue(class_1799 stack) {
            return USUtil.areStacksMatching(this.value, stack);
        }

        @Override
        public class_1799 icon() {
            return this.value.method_7972();
        }

        @Override
        public GuiElementInterface getAccessElement() {
            return this.shop.isAdmin() ? GuiElements.FILLER : GuiElements.CURRENCY_INVENTORY;
        }

        @Override
        public boolean isSetup() {
            return !this.value.method_7960();
        }

        @Override
        protected class_2520 writeValueNbt(class_7225.class_7874 lookup) {
            class_2487 nbt = new class_2487();
            nbt.method_10566("Value", this.value.method_57375(lookup));
            nbt.method_10566("CurrencyContainer", (class_2520)this.currencyInventory.method_7660(lookup));
            return nbt;
        }

        @Override
        public class_1799 getItemStack() {
            return this.value;
        }

        @Override
        public void setItemStack(class_1799 stack) {
            this.value = stack;
        }
    }

    public static final class Free
    extends PriceHandler {
        public static final Definition DEFINITION = new Definition("free", class_1802.field_17512){

            @Override
            public PriceHandler createFromNbt(class_2520 nbt, TradeShopBlockEntity blockEntity, class_7225.class_7874 lookup) {
                return new Free(this, blockEntity);
            }

            @Override
            public PriceHandler createInitial(TradeShopBlockEntity blockEntity) {
                return new Free(this, blockEntity);
            }
        };

        protected Free(Definition definition, TradeShopBlockEntity blockEntity) {
            super(definition, blockEntity);
        }

        @Override
        public boolean canSwitch() {
            return true;
        }

        @Override
        public class_2561 getText() {
            return TextUtil.text("free", new Object[0]);
        }

        @Override
        public int getMaxAmount(class_3222 player) {
            return Integer.MAX_VALUE;
        }

        @Override
        public Result payFor(class_3222 player, boolean canTake) {
            return Result.successful();
        }

        @Override
        public class_1799 icon() {
            class_1799 i = Free.DEFINITION.icon.method_7972();
            i.method_57379(class_9334.field_50239, (Object)this.getText());
            return i;
        }

        @Override
        public boolean isSetup() {
            return true;
        }

        @Override
        protected class_2520 writeValueNbt(class_7225.class_7874 lookup) {
            return class_2481.method_23234((boolean)false);
        }
    }

    public static final class VirtualBalance
    extends PriceHandler
    implements VirtualBalanceSettingsGui.Controller {
        public static final Definition DEFINITION = new Definition("virtual_balance", class_1802.field_17525){

            @Override
            public PriceHandler createFromNbt(class_2520 nbte, TradeShopBlockEntity blockEntity, class_7225.class_7874 lookup) {
                class_2487 nbt = (class_2487)nbte;
                return new VirtualBalance(this, class_2960.method_12829((String)nbt.method_10558("Currency")), nbt.method_10537("Value"), nbt.method_10537("Stored"), blockEntity);
            }

            @Override
            public PriceHandler createInitial(TradeShopBlockEntity blockEntity) {
                return new VirtualBalance(this, null, 0L, 0L, blockEntity);
            }

            @Override
            public boolean canUse(class_3222 player) {
                return !CommonEconomy.getCurrencies((MinecraftServer)player.field_13995).isEmpty();
            }
        };
        private static final GuiElementInterface SETTINGS = new GuiElementBuilder(class_1802.field_8656).setName((class_2561)TextUtil.text("configure", new Object[0])).setCallback((a, b, c, g) -> {
            if (g instanceof ShopGui) {
                ShopGui gui = (ShopGui)g;
                gui.playClickSound();
                new VirtualBalanceSettingsGui(gui.getPlayer(), gui.getBE(), (VirtualBalanceSettingsGui.Controller)((Object)gui.getBE().priceHandler));
            }
        }).build();
        @Nullable
        public class_2960 currency;
        public long cost;
        public long storedMoney;
        public final WeakHashMap<class_3222, class_2960> usedAccounts = new WeakHashMap();

        protected VirtualBalance(Definition definition, class_2960 account, long price, long stored, TradeShopBlockEntity blockEntity) {
            super(definition, blockEntity);
            this.currency = account;
            this.cost = price;
            this.storedMoney = stored;
        }

        @Override
        public boolean canSwitch() {
            return this.storedMoney <= 0L;
        }

        @Override
        public class_2561 getText() {
            EconomyCurrency ac = this.getCurrency();
            return ac != null ? ac.formatValueText(this.cost, false) : class_2561.method_43473();
        }

        public EconomyCurrency getCurrency() {
            return CommonEconomy.getCurrency((MinecraftServer)this.shop.method_10997().method_8503(), (class_2960)this.currency);
        }

        @Override
        public int getMaxAmount(class_3222 player) {
            EconomyAccount ac = this.getSelectedAccount(player);
            return ac != null ? (int)(ac.balance() / this.cost) : 0;
        }

        @Override
        public Result payFor(class_3222 player, boolean canTake) {
            boolean admin = this.shop.isAdmin();
            EconomyAccount pac = this.getSelectedAccount(player);
            if (pac != null) {
                if (!admin && this.storedMoney + this.cost <= 0L) {
                    return Result.failed((class_2561)TextUtil.text("virtual_money.cant_store", new Object[0]));
                }
                EconomyTransaction transaction = pac.decreaseBalance(this.cost);
                if (transaction.isFailure()) {
                    return Result.failed((class_2561)TextUtil.text("virtual_money.not_enough_money", transaction.message()));
                }
                if (!admin) {
                    this.storedMoney += this.cost;
                }
                this.shop.method_5431();
                return Result.successful();
            }
            return Result.failed((class_2561)TextUtil.text("virtual_money.no_account", this.currency));
        }

        @Override
        public class_1799 icon() {
            EconomyCurrency ac = this.getCurrency();
            if (ac != null) {
                class_1799 icon = ac.icon();
                icon.method_57379(class_9334.field_50239, (Object)ac.formatValueText(this.cost, false));
                return icon;
            }
            return GuiElements.HEAD_QUESTION_MARK.method_7972();
        }

        @Override
        public GuiElementInterface getSetupElement() {
            return SETTINGS;
        }

        @Override
        public GuiElementInterface getAccessElement() {
            return new GuiElementBuilder(class_1802.field_8106).setName((class_2561)TextUtil.gui("virtual_balance.collect", new Object[0])).addLoreLine((class_2561)TextUtil.gui("virtual_balance.stored", this.getCurrency().formatValueText(this.storedMoney, false).method_27661().method_27692(class_124.field_1068)).method_27692(class_124.field_1054)).setCallback((x, y, z, g) -> {
                ShopGui gui = (ShopGui)g;
                gui.playClickSound();
                EconomyAccount ac = this.getSelectedAccount(g.getPlayer());
                if (ac.increaseBalance(this.storedMoney).isSuccessful()) {
                    this.storedMoney = 0L;
                    this.shop.method_5431();
                }
            }).build();
        }

        @Override
        public GuiElementInterface getUserElement() {
            return new GuiElementInterface(){

                public class_1799 getItemStack() {
                    return class_1799.field_8037;
                }

                public class_1799 getItemStackForDisplay(GuiInterface gui) {
                    EconomyAccount ac = this.getSelectedAccount(gui.getPlayer());
                    return GuiElementBuilder.from((class_1799)(ac != null ? ac.accountIcon() : GuiElements.HEAD_QUESTION_MARK)).setName((class_2561)TextUtil.gui("virtual_balance.selected_account", (ac != null ? ac.name().method_27661() : TextUtil.text("not_set", new Object[0])).method_27692(class_124.field_1080))).addLoreLine((class_2561)TextUtil.gui("virtual_balance.balance", (ac != null ? ac.formattedBalance().method_27661() : TextUtil.text("not_set", new Object[0])).method_27692(class_124.field_1068)).method_27692(class_124.field_1054)).addLoreLine((class_2561)class_2561.method_43473()).addLoreLine((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"\u00bb ").method_27692(class_124.field_1063)).method_10852((class_2561)TextUtil.gui("setup.click_to_change_mode.1", new Object[0])).method_27692(class_124.field_1080)).addLoreLine((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"   ").method_27692(class_124.field_1063)).method_10852((class_2561)TextUtil.gui("setup.click_to_change_mode.2", new Object[0])).method_27692(class_124.field_1080)).hideDefaultTooltip().asStack();
                }

                public GuiElementInterface.ClickCallback getGuiCallback() {
                    return (x, type, z, g) -> {
                        ShopGui gui = (ShopGui)g;
                        List accounts = List.copyOf(CommonEconomy.getAccounts((class_3222)g.getPlayer(), (EconomyCurrency)this.getCurrency()));
                        EconomyAccount current = this.getSelectedAccount(g.getPlayer());
                        if (accounts.isEmpty() || current == null) {
                            gui.playDismissSound();
                            return;
                        }
                        gui.playClickSound();
                        int dir = type.shift ? -1 : 1;
                        gui.playClickSound();
                        int size = accounts.size();
                        usedAccounts.put(gui.getPlayer(), ((EconomyAccount)accounts.get((size + accounts.indexOf(current) + dir) % size)).id());
                    };
                }
            };
        }

        private EconomyAccount getSelectedAccount(class_3222 player) {
            EconomyAccount account;
            class_2960 identifier = this.usedAccounts.get(player);
            if (identifier != null && (account = CommonEconomy.getAccount((class_3222)player, (class_2960)identifier)) != null && account.currency() == this.getCurrency()) {
                return account;
            }
            return CommonEconomy.getAccounts((class_3222)player, (EconomyCurrency)this.getCurrency()).stream().sorted(Comparator.comparing(x -> -x.balance())).findFirst().orElse(null);
        }

        @Override
        public boolean isSetup() {
            return this.cost > 0L && this.currency != null && (this.shop.owner != null || this.shop.isAdmin()) && this.getCurrency() != null;
        }

        @Override
        protected class_2520 writeValueNbt(class_7225.class_7874 lookup) {
            class_2487 nbt = new class_2487();
            if (this.currency != null) {
                nbt.method_10582("Currency", this.currency.toString());
            }
            nbt.method_10544("Value", this.cost);
            nbt.method_10544("Stored", this.storedMoney);
            return nbt;
        }

        @Override
        public void setValue(long value) {
            this.cost = value;
        }

        @Override
        public long getValue() {
            return this.cost;
        }

        @Override
        public void setCurrencyId(class_2960 identifier) {
            this.currency = identifier;
        }

        @Override
        public class_2960 getCurrencyId() {
            return this.currency;
        }
    }

    public record Result(boolean success, @Nullable class_2561 failureMessage) {
        public static Result failed(class_2561 value) {
            return new Result(false, value);
        }

        public static Result successful() {
            return new Result(true, null);
        }
    }
}

