/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.nbt.validators.numeric;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import com.teamresourceful.resourcefullib.common.nbt.validators.numeric.NumericValidator;
import java.util.Optional;
import net.minecraft.class_2481;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;

public record BetweenNumericValidator(Optional<Number> min, Optional<Number> max) implements NumericValidator
{
    public static final String ID = "number:between";
    public static final Codec<BetweenNumericValidator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecExtras.NUMBER.optionalFieldOf("min").forGetter(BetweenNumericValidator::min), (App)CodecExtras.NUMBER.optionalFieldOf("max").forGetter(BetweenNumericValidator::max)).apply((Applicative)instance, BetweenNumericValidator::new));

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean test(class_2514 tag) {
        if (tag instanceof class_2481) {
            class_2481 byteTag = (class_2481)tag;
            byte min = this.min.map(Number::byteValue).orElse((byte)-128);
            byte max = this.max.map(Number::byteValue).orElse((byte)127);
            return byteTag.method_10698() >= min && byteTag.method_10698() <= max;
        }
        if (tag instanceof class_2516) {
            class_2516 shortTag = (class_2516)tag;
            short min = this.min.map(Number::shortValue).orElse((short)Short.MIN_VALUE);
            short max = this.max.map(Number::shortValue).orElse((short)Short.MAX_VALUE);
            return shortTag.method_10696() >= min && shortTag.method_10696() <= max;
        }
        if (tag instanceof class_2497) {
            class_2497 intTag = (class_2497)tag;
            int min = this.min.map(Number::intValue).orElse(Integer.MIN_VALUE);
            int max = this.max.map(Number::intValue).orElse(Integer.MAX_VALUE);
            return intTag.method_10701() >= min && intTag.method_10701() <= max;
        }
        if (tag instanceof class_2503) {
            class_2503 longTag = (class_2503)tag;
            long min = this.min.map(Number::longValue).orElse(Long.MIN_VALUE);
            long max = this.max.map(Number::longValue).orElse(Long.MAX_VALUE);
            return longTag.method_10699() >= min && longTag.method_10699() <= max;
        }
        if (tag instanceof class_2494) {
            class_2494 floatTag = (class_2494)tag;
            float min = this.min.map(Number::floatValue).orElse(Float.valueOf(Float.MIN_VALUE)).floatValue();
            float max = this.max.map(Number::floatValue).orElse(Float.valueOf(Float.MAX_VALUE)).floatValue();
            return floatTag.method_10700() >= min && floatTag.method_10700() <= max;
        }
        if (tag instanceof class_2489) {
            class_2489 doubleTag = (class_2489)tag;
            double min = this.min.map(Number::doubleValue).orElse((Double)Double.MIN_VALUE);
            double max = this.max.map(Number::doubleValue).orElse((Double)Double.MAX_VALUE);
            return doubleTag.method_10697() >= min && doubleTag.method_10697() <= max;
        }
        return false;
    }
}

