/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.soundcloud;

import com.sedmelluq.discord.lavaplayer.container.playlists.HlsStreamSegment;
import com.sedmelluq.discord.lavaplayer.container.playlists.HlsStreamSegmentParser;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudHelper;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudM3uInfo;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudSegmentDecoder;
import com.sedmelluq.discord.lavaplayer.tools.http.HttpStreamTools;
import com.sedmelluq.discord.lavaplayer.tools.io.ChainedInputStream;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.NonSeekableInputStream;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import dev.derock.svcmusic.apachehttp.client.methods.HttpGet;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundCloudM3uAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(SoundCloudM3uAudioTrack.class);
    private static final long SEGMENT_UPDATE_INTERVAL = TimeUnit.MINUTES.toMillis(10L);
    private final HttpInterface httpInterface;
    private final SoundCloudM3uInfo m3uInfo;

    public SoundCloudM3uAudioTrack(AudioTrackInfo trackInfo, HttpInterface httpInterface, SoundCloudM3uInfo m3uInfo) {
        super(trackInfo);
        this.httpInterface = httpInterface;
        this.m3uInfo = m3uInfo;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (SegmentTracker segmentTracker = this.createSegmentTracker();){
            segmentTracker.decoder.prepareStream(true);
            localExecutor.executeProcessingLoop(() -> segmentTracker.decoder.playStream(localExecutor.getProcessingContext(), segmentTracker.streamStartPosition, segmentTracker.desiredPosition), x$0 -> segmentTracker.seekToTimecode(x$0), true);
        }
    }

    private List<HlsStreamSegment> loadSegments() throws IOException {
        String playbackUrl = SoundCloudHelper.loadPlaybackUrl(this.httpInterface, this.m3uInfo.lookupUrl);
        return HlsStreamSegmentParser.parseFromUrl(this.httpInterface, playbackUrl);
    }

    private SegmentTracker createSegmentTracker() throws IOException {
        List<HlsStreamSegment> initialSegments = this.loadSegments();
        SegmentTracker tracker = new SegmentTracker(initialSegments);
        tracker.setupDecoder(this.m3uInfo.decoderFactory);
        return tracker;
    }

    private class SegmentTracker
    implements AutoCloseable {
        private final List<HlsStreamSegment> segments;
        private long desiredPosition = 0L;
        private long streamStartPosition = 0L;
        private long lastUpdate;
        private SoundCloudSegmentDecoder decoder;
        private int segmentIndex = 0;

        private SegmentTracker(List<HlsStreamSegment> segments) {
            this.segments = segments;
            this.lastUpdate = System.currentTimeMillis();
        }

        private void setupDecoder(SoundCloudSegmentDecoder.Factory factory) {
            this.decoder = factory.create(this::createChainedStream);
        }

        private SeekableInputStream createChainedStream() {
            return new NonSeekableInputStream(new ChainedInputStream(this::getNextStream));
        }

        private void seekToTimecode(long timecode) throws IOException {
            Long duration;
            long segmentTimecode = 0L;
            for (int i = 0; i < this.segments.size() && (duration = this.segments.get((int)i).duration) != null; ++i) {
                long nextTimecode = segmentTimecode + duration;
                if (timecode >= segmentTimecode && timecode < nextTimecode) {
                    this.seekToSegment(i, timecode, segmentTimecode);
                    return;
                }
                segmentTimecode = nextTimecode;
            }
            this.seekToEnd();
        }

        private void seekToSegment(int index, long requestedTimecode, long segmentTimecode) throws IOException {
            this.decoder.resetStream();
            this.segmentIndex = index;
            this.desiredPosition = requestedTimecode;
            this.streamStartPosition = segmentTimecode;
            this.decoder.prepareStream(this.streamStartPosition == 0L);
        }

        private void seekToEnd() throws IOException {
            this.decoder.resetStream();
            this.segmentIndex = this.segments.size();
        }

        private InputStream getNextStream() {
            HlsStreamSegment segment = this.getNextSegment();
            if (segment == null) {
                return null;
            }
            return HttpStreamTools.streamContent(SoundCloudM3uAudioTrack.this.httpInterface, new HttpGet(segment.url));
        }

        private void updateSegmentList() {
            try {
                int i;
                List<HlsStreamSegment> newSegments = SoundCloudM3uAudioTrack.this.loadSegments();
                if (newSegments.size() != this.segments.size()) {
                    log.error("For {}, received different number of segments on update, skipping.", (Object)((SoundCloudM3uAudioTrack)SoundCloudM3uAudioTrack.this).trackInfo.identifier);
                    return;
                }
                for (i = 0; i < this.segments.size(); ++i) {
                    if (Objects.equals(newSegments.get((int)i).duration, this.segments.get((int)i).duration)) continue;
                    log.error("For {}, segment {} has different length than previously on update.", (Object)((SoundCloudM3uAudioTrack)SoundCloudM3uAudioTrack.this).trackInfo.identifier, (Object)i);
                    return;
                }
                for (i = 0; i < this.segments.size(); ++i) {
                    this.segments.set(i, newSegments.get(i));
                }
            }
            catch (Exception e) {
                log.error("For {}, failed to update segment list, skipping.", (Object)((SoundCloudM3uAudioTrack)SoundCloudM3uAudioTrack.this).trackInfo.identifier, (Object)e);
            }
        }

        private void checkSegmentListUpdate() {
            long now = System.currentTimeMillis();
            long delta = now - this.lastUpdate;
            if (delta > SEGMENT_UPDATE_INTERVAL) {
                log.debug("For {}, {}ms has passed since last segment update, updating", (Object)((SoundCloudM3uAudioTrack)SoundCloudM3uAudioTrack.this).trackInfo.identifier, (Object)delta);
                this.updateSegmentList();
                this.lastUpdate = now;
            }
        }

        private HlsStreamSegment getNextSegment() {
            int current;
            if ((current = this.segmentIndex++) < this.segments.size()) {
                this.checkSegmentListUpdate();
                return this.segments.get(current);
            }
            return null;
        }

        @Override
        public void close() throws Exception {
            this.decoder.resetStream();
        }
    }
}

