/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.vimeo;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.vimeo.VimeoAudioTrack;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.derock.svcmusic.apachehttp.client.config.RequestConfig;
import dev.derock.svcmusic.apachehttp.client.methods.CloseableHttpResponse;
import dev.derock.svcmusic.apachehttp.client.methods.HttpGet;
import dev.derock.svcmusic.apachehttp.impl.client.HttpClientBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class VimeoAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final String TRACK_URL_REGEX = "^https://vimeo.com/[0-9]+(?:\\?.*|)$";
    private static final Pattern trackUrlPattern = Pattern.compile("^https://vimeo.com/[0-9]+(?:\\?.*|)$");
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();

    @Override
    public String getSourceName() {
        return "vimeo";
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        AudioItem audioItem;
        block9: {
            if (!trackUrlPattern.matcher(reference.identifier).matches()) {
                return null;
            }
            HttpInterface httpInterface = this.httpInterfaceManager.getInterface();
            try {
                audioItem = this.loadFromTrackPage(httpInterface, reference.identifier);
                if (httpInterface == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (httpInterface != null) {
                        try {
                            httpInterface.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FriendlyException("Loading Vimeo track information failed.", FriendlyException.Severity.SUSPICIOUS, e);
                }
            }
            httpInterface.close();
        }
        return audioItem;
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new VimeoAudioTrack(trackInfo, this);
    }

    @Override
    public void shutdown() {
        ExceptionTools.closeWithWarnings(this.httpInterfaceManager);
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    HttpInterfaceManager getHttpInterfaceManager() {
        return this.httpInterfaceManager;
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    JsonBrowser loadConfigJsonFromPageContent(String content) throws IOException {
        String configText = DataFormatTools.extractBetween(content, "window.vimeo.clip_page_config = ", "\n");
        if (configText != null) {
            return JsonBrowser.parse(configText);
        }
        return null;
    }

    private AudioItem loadFromTrackPage(HttpInterface httpInterface, String trackUrl) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(trackUrl));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                AudioReference audioReference = AudioReference.NO_TRACK;
                return audioReference;
            }
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new FriendlyException("Server responded with an error.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Response code is " + statusCode));
            }
            AudioTrack audioTrack = this.loadTrackFromPageContent(trackUrl, IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8));
            return audioTrack;
        }
    }

    private AudioTrack loadTrackFromPageContent(String trackUrl, String content) throws IOException {
        JsonBrowser config = this.loadConfigJsonFromPageContent(content);
        if (config == null) {
            throw new FriendlyException("Track information not found on the page.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        return new VimeoAudioTrack(new AudioTrackInfo(config.get("clip").get("title").text(), config.get("owner").get("display_name").text(), (long)(config.get("clip").get("duration").get("raw").as(Double.class) * 1000.0), trackUrl, false, trackUrl, config.get("thumbnail").get("src").text(), null), this);
    }
}

