/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeLinkRouter;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.derock.svcmusic.apachehttp.NameValuePair;
import dev.derock.svcmusic.apachehttp.client.utils.URIBuilder;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DefaultYoutubeLinkRouter
implements YoutubeLinkRouter {
    private static final String SEARCH_PREFIX = "ytsearch:";
    private static final String SEARCH_MUSIC_PREFIX = "ytmsearch:";
    private static final String PROTOCOL_REGEX = "(?:http://|https://|)";
    private static final String DOMAIN_REGEX = "(?:www\\.|m\\.|music\\.|)youtube\\.com";
    private static final String SHORT_DOMAIN_REGEX = "(?:www\\.|)youtu\\.be";
    private static final String VIDEO_ID_REGEX = "(?<v>[a-zA-Z0-9_-]{11})";
    private static final String PLAYLIST_ID_REGEX = "(?<list>(PL|LL|FL|UU)[a-zA-Z0-9_-]+)";
    private static final Pattern directVideoIdPattern = Pattern.compile("^(?<v>[a-zA-Z0-9_-]{11})$");
    private final Extractor[] extractors = new Extractor[]{new Extractor(directVideoIdPattern, YoutubeLinkRouter.Routes::track), new Extractor(Pattern.compile("^(?<list>(PL|LL|FL|UU)[a-zA-Z0-9_-]+)$"), this::routeDirectPlaylist), new Extractor(Pattern.compile("^(?:http://|https://|)(?:www\\.|m\\.|music\\.|)youtube\\.com/.*"), this::routeFromMainDomain), new Extractor(Pattern.compile("^(?:http://|https://|)(?:www\\.|)youtu\\.be/.*"), this::routeFromShortDomain), new Extractor(Pattern.compile("^(?:http://|https://|)(?:www\\.|m\\.|music\\.|)youtube\\.com/embed/.*"), this::routeFromEmbed), new Extractor(Pattern.compile("^(?:http://|https://|)(?:www\\.|m\\.|music\\.|)youtube\\.com/shorts/.*"), this::routeFromShorts), new Extractor(Pattern.compile("^(?:http://|https://|)(?:www\\.|m\\.|music\\.|)youtube\\.com/live/.*"), this::routeFromLive)};

    @Override
    public <T> T route(String link, YoutubeLinkRouter.Routes<T> routes) {
        if (link.startsWith(SEARCH_PREFIX)) {
            return routes.search(link.substring(SEARCH_PREFIX.length()).trim());
        }
        if (link.startsWith(SEARCH_MUSIC_PREFIX)) {
            return routes.searchMusic(link.substring(SEARCH_MUSIC_PREFIX.length()).trim());
        }
        for (Extractor extractor : this.extractors) {
            T item;
            if (!extractor.pattern.matcher(link).matches() || (item = extractor.router.extract(routes, link)) == null) continue;
            return item;
        }
        return null;
    }

    protected <T> T routeDirectPlaylist(YoutubeLinkRouter.Routes<T> routes, String id) {
        return routes.playlist(id, null);
    }

    protected <T> T routeFromMainDomain(YoutubeLinkRouter.Routes<T> routes, String url) {
        String videoIds;
        UrlInfo urlInfo = DefaultYoutubeLinkRouter.getUrlInfo(url, true);
        if ("/watch".equals(urlInfo.path)) {
            String videoId = urlInfo.parameters.get("v");
            if (videoId != null) {
                return this.routeFromUrlWithVideoId(routes, videoId, urlInfo);
            }
        } else if ("/playlist".equals(urlInfo.path)) {
            String playlistId = urlInfo.parameters.get("list");
            if (playlistId != null) {
                return routes.playlist(playlistId, null);
            }
        } else if ("/watch_videos".equals(urlInfo.path) && (videoIds = urlInfo.parameters.get("video_ids")) != null) {
            return routes.anonymous(videoIds);
        }
        return null;
    }

    protected <T> T routeFromUrlWithVideoId(YoutubeLinkRouter.Routes<T> routes, String videoId, UrlInfo urlInfo) {
        if (videoId.length() > 11) {
            videoId = videoId.substring(0, 11);
        }
        if (!directVideoIdPattern.matcher(videoId).matches()) {
            return routes.none();
        }
        if (urlInfo.parameters.containsKey("list")) {
            String playlistId = urlInfo.parameters.get("list");
            if (playlistId.startsWith("RD")) {
                return routes.mix(playlistId, videoId);
            }
            return routes.playlist(urlInfo.parameters.get("list"), videoId);
        }
        return routes.track(videoId);
    }

    protected <T> T routeFromShortDomain(YoutubeLinkRouter.Routes<T> routes, String url) {
        UrlInfo urlInfo = DefaultYoutubeLinkRouter.getUrlInfo(url, true);
        return this.routeFromUrlWithVideoId(routes, urlInfo.path.substring(1), urlInfo);
    }

    protected <T> T routeFromEmbed(YoutubeLinkRouter.Routes<T> routes, String url) {
        UrlInfo urlInfo = DefaultYoutubeLinkRouter.getUrlInfo(url, true);
        return this.routeFromUrlWithVideoId(routes, urlInfo.path.substring(7), urlInfo);
    }

    protected <T> T routeFromShorts(YoutubeLinkRouter.Routes<T> routes, String url) {
        UrlInfo urlInfo = DefaultYoutubeLinkRouter.getUrlInfo(url, true);
        return this.routeFromUrlWithVideoId(routes, urlInfo.path.substring(8), urlInfo);
    }

    protected <T> T routeFromLive(YoutubeLinkRouter.Routes<T> routes, String url) {
        UrlInfo urlInfo = DefaultYoutubeLinkRouter.getUrlInfo(url, true);
        return this.routeFromUrlWithVideoId(routes, urlInfo.path.substring(6), urlInfo);
    }

    private static UrlInfo getUrlInfo(String url, boolean retryValidPart) {
        try {
            if (!((String)url).startsWith("http://") && !((String)url).startsWith("https://")) {
                url = "https://" + (String)url;
            }
            URIBuilder builder = new URIBuilder((String)url);
            return new UrlInfo(builder.getPath(), builder.getQueryParams().stream().filter(it -> it.getValue() != null).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue, (a, b) -> a)));
        }
        catch (URISyntaxException e) {
            if (retryValidPart) {
                return DefaultYoutubeLinkRouter.getUrlInfo(((String)url).substring(0, e.getIndex() - 1), false);
            }
            throw new FriendlyException("Not a valid URL: " + (String)url, FriendlyException.Severity.COMMON, e);
        }
    }

    private static interface ExtractorRouter {
        public <T> T extract(YoutubeLinkRouter.Routes<T> var1, String var2);
    }

    private static class Extractor {
        private final Pattern pattern;
        private final ExtractorRouter router;

        private Extractor(Pattern pattern, ExtractorRouter router) {
            this.pattern = pattern;
            this.router = router;
        }
    }

    private static class UrlInfo {
        private final String path;
        private final Map<String, String> parameters;

        private UrlInfo(String path, Map<String, String> parameters) {
            this.path = path;
            this.parameters = parameters;
        }
    }
}

