/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegFileLoader;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.mpeg.reader.MpegFileTrackProvider;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubePersistentHttpStream;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import dev.derock.svcmusic.apachehttp.client.config.RequestConfig;
import dev.derock.svcmusic.apachehttp.client.utils.URIBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeMpegStreamAudioTrack
extends MpegAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(YoutubeMpegStreamAudioTrack.class);
    private static final RequestConfig streamingRequestConfig = RequestConfig.custom().setSocketTimeout(3000).setConnectionRequestTimeout(3000).setConnectTimeout(3000).build();
    private static final long EMPTY_RETRY_THRESHOLD_MS = 400L;
    private static final long EMPTY_RETRY_INTERVAL_MS = 50L;
    private static final long MAX_REWIND_TIME = 43200L;
    private final HttpInterface httpInterface;
    private final TrackState state;

    public YoutubeMpegStreamAudioTrack(AudioTrackInfo trackInfo, HttpInterface httpInterface, URI signedUrl) {
        super(trackInfo, null);
        this.httpInterface = httpInterface;
        this.state = new TrackState(signedUrl);
        httpInterface.getContext().setRequestConfig(streamingRequestConfig);
        this.updateGlobalSequence().join();
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) {
        localExecutor.executeProcessingLoop(() -> this.execute(localExecutor), this::seek);
    }

    @Override
    public void setPosition(long position) {
        this.state.seeking = true;
        this.updateGlobalSequence().join();
        this.getActiveExecutor().setPosition(position);
    }

    @Override
    public long getDuration() {
        return TimeUnit.SECONDS.toMillis(this.state.globalSequence * TimeUnit.MILLISECONDS.toSeconds(this.state.globalSequenceDuration));
    }

    @Override
    public long getPosition() {
        if (this.state.absoluteSequence == null) {
            return 0L;
        }
        return TimeUnit.SECONDS.toMillis(this.state.absoluteSequence * TimeUnit.MILLISECONDS.toSeconds(this.state.globalSequenceDuration));
    }

    private CompletableFuture<Void> updateGlobalSequence() {
        CompletableFuture<Void> updated = new CompletableFuture<Void>();
        try (YoutubePersistentHttpStream stream = new YoutubePersistentHttpStream(this.httpInterface, this.state.initialUrl, Long.MAX_VALUE);){
            MpegFileLoader file = new MpegFileLoader(stream);
            file.parseHeaders();
            SequenceInfo sequenceInfo = this.extractAbsoluteSequenceFromEvent(file.getLastEventMessage());
            this.state.globalSequence = sequenceInfo.sequence;
            this.state.globalSequenceDuration = sequenceInfo.duration;
            updated.complete(null);
        }
        catch (IOException e) {
            updated.complete(null);
        }
        return updated;
    }

    private void execute(LocalAudioTrackExecutor localExecutor) throws InterruptedException {
        if (!this.trackInfo.isStream && this.state.absoluteSequence == null) {
            this.state.absoluteSequence = 0L;
        }
        try {
            while (!this.state.finished) {
                this.processNextSegmentWithRetry(localExecutor);
                ++this.state.relativeSequence;
                ++this.state.globalSequence;
            }
        }
        finally {
            if (this.state.trackConsumer != null && !this.state.seeking) {
                this.state.trackConsumer.close();
            } else {
                this.state.seeking = false;
            }
        }
    }

    private void seek(long timecode) {
        long seconds = TimeUnit.MILLISECONDS.toSeconds(timecode);
        if (seconds > this.state.globalSequence) {
            seconds = this.state.globalSequence;
        } else if (this.state.globalSequence - seconds > 43200L) {
            seconds = this.state.globalSequence - 43200L;
        }
        this.state.absoluteSequence = seconds - 1L;
    }

    private void processNextSegmentWithRetry(LocalAudioTrackExecutor localExecutor) throws InterruptedException {
        long waitStart;
        if (this.processNextSegment(localExecutor)) {
            return;
        }
        long iterationStart = waitStart = System.currentTimeMillis();
        while (!this.processNextSegment(localExecutor)) {
            if (iterationStart - waitStart >= 400L) {
                this.state.finished = true;
                break;
            }
            Thread.sleep(50L);
            iterationStart = System.currentTimeMillis();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processNextSegment(LocalAudioTrackExecutor localExecutor) throws InterruptedException {
        URI segmentUrl = this.getNextSegmentUrl(this.state);
        log.debug("Segment URL: {}", (Object)segmentUrl.toString());
        try (YoutubePersistentHttpStream stream = new YoutubePersistentHttpStream(this.httpInterface, segmentUrl, Long.MAX_VALUE);){
            if (stream.checkStatusCode() == 204 || stream.getContentLength() == 0L) {
                boolean bl = false;
                return bl;
            }
            this.state.redirectUrl = this.httpInterface.getFinalLocation();
            this.processSegmentStream(stream, localExecutor.getProcessingContext(), this.state);
            stream.releaseConnection();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void processSegmentStream(SeekableInputStream stream, AudioProcessingContext context, TrackState state) throws InterruptedException, IOException {
        MpegFileTrackProvider fileReader;
        MpegFileLoader file = new MpegFileLoader(stream);
        file.parseHeaders();
        if (!this.trackInfo.isStream) {
            TrackState trackState = state;
            Long l = trackState.absoluteSequence;
            Long l2 = trackState.absoluteSequence = Long.valueOf(trackState.absoluteSequence + 1L);
        } else {
            state.absoluteSequence = this.extractAbsoluteSequenceFromEvent((byte[])file.getLastEventMessage()).sequence;
        }
        if (state.trackConsumer == null) {
            state.trackConsumer = this.loadAudioTrack(file, context);
        }
        if ((fileReader = file.loadReader(state.trackConsumer)) == null) {
            throw new FriendlyException("Unknown MP4 format.", FriendlyException.Severity.SUSPICIOUS, null);
        }
        fileReader.provideFrames();
    }

    private URI getNextSegmentUrl(TrackState state) {
        URIBuilder builder = new URIBuilder(state.redirectUrl == null ? state.initialUrl : state.redirectUrl).setParameter("rn", String.valueOf(state.relativeSequence)).setParameter("rbuf", "0");
        if (state.absoluteSequence != null) {
            builder.setParameter("sq", String.valueOf(state.absoluteSequence + 1L));
        }
        try {
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private SequenceInfo extractAbsoluteSequenceFromEvent(byte[] data) {
        if (data == null) {
            return null;
        }
        String message = new String(data, StandardCharsets.UTF_8);
        String sequence = DataFormatTools.extractBetween(message, "Sequence-Number: ", "\r\n");
        String duration = DataFormatTools.extractBetween(message, "Target-Duration-Us: ", "\r\n");
        if (sequence != null && duration != null) {
            return new SequenceInfo(Long.parseLong(sequence), TimeUnit.MICROSECONDS.toMillis(Long.parseLong(duration)));
        }
        return null;
    }

    private static class SequenceInfo {
        private final long sequence;
        private final long duration;

        public SequenceInfo(long sequence, long duration) {
            this.sequence = sequence;
            this.duration = duration;
        }
    }

    private static class TrackState {
        private long globalSequenceDuration;
        private long globalSequence;
        private long relativeSequence;
        private Long absoluteSequence;
        private MpegTrackConsumer trackConsumer;
        private boolean finished;
        private boolean seeking;
        private URI redirectUrl;
        private final URI initialUrl;

        public TrackState(URI initialUrl) {
            this.initialUrl = initialUrl;
        }
    }
}

