/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.track.playback;

import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.track.playback.AbstractAudioFrameBuffer;
import com.sedmelluq.discord.lavaplayer.track.playback.AbstractMutableAudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameBuffer;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameRebuilder;
import com.sedmelluq.discord.lavaplayer.track.playback.ImmutableAudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.TerminatorAudioFrame;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocatingAudioFrameBuffer
extends AbstractAudioFrameBuffer {
    private static final Logger log = LoggerFactory.getLogger(AudioFrameBuffer.class);
    private final int fullCapacity;
    private final ArrayBlockingQueue<AudioFrame> audioFrames;
    private final AtomicBoolean stopping;

    public AllocatingAudioFrameBuffer(int bufferDuration, AudioDataFormat format, AtomicBoolean stopping) {
        super(format);
        this.fullCapacity = bufferDuration / 20 + 1;
        this.audioFrames = new ArrayBlockingQueue(this.fullCapacity);
        this.stopping = stopping;
    }

    @Override
    public int getRemainingCapacity() {
        return this.audioFrames.remainingCapacity();
    }

    @Override
    public int getFullCapacity() {
        return this.fullCapacity;
    }

    @Override
    public AudioFrame provide() {
        AudioFrame frame = this.audioFrames.poll();
        if (frame == null) {
            return this.fetchPendingTerminator();
        }
        if (frame.isTerminator()) {
            this.fetchPendingTerminator();
            return frame;
        }
        return this.filterFrame(frame);
    }

    @Override
    public AudioFrame provide(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        AudioFrame frame = this.audioFrames.poll();
        if (frame == null) {
            AudioFrame terminator = this.fetchPendingTerminator();
            if (terminator != null) {
                return terminator;
            }
            if (timeout > 0L && ((frame = this.audioFrames.poll(timeout, unit)) == null || frame.isTerminator())) {
                terminator = this.fetchPendingTerminator();
                return terminator != null ? terminator : frame;
            }
        } else if (frame.isTerminator()) {
            this.fetchPendingTerminator();
            return frame;
        }
        return this.filterFrame(frame);
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame) {
        return this.passToMutable(this.provide(), targetFrame);
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        return this.passToMutable(this.provide(timeout, unit), targetFrame);
    }

    private boolean passToMutable(AudioFrame frame, MutableAudioFrame targetFrame) {
        if (targetFrame != null && frame != null) {
            if (frame.isTerminator()) {
                targetFrame.setTerminator(true);
            } else {
                targetFrame.setTimecode(frame.getTimecode());
                targetFrame.setVolume(frame.getVolume());
                targetFrame.store(frame.getData(), 0, frame.getDataLength());
                targetFrame.setTerminator(false);
                targetFrame.setFormat(frame.getFormat());
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.audioFrames.clear();
    }

    @Override
    public void rebuild(AudioFrameRebuilder rebuilder) {
        ArrayList frames = new ArrayList();
        int frameCount = this.audioFrames.drainTo(frames);
        log.debug("Running rebuilder {} on {} buffered frames.", (Object)rebuilder.getClass().getSimpleName(), (Object)frameCount);
        for (AudioFrame frame : frames) {
            this.audioFrames.add(rebuilder.rebuild(frame));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLastInputTimecode() {
        Long lastTimecode = null;
        Object object = this.synchronizer;
        synchronized (object) {
            if (!this.clearOnInsert) {
                for (AudioFrame frame : this.audioFrames) {
                    lastTimecode = frame.getTimecode();
                }
            }
        }
        return lastTimecode;
    }

    @Override
    public void consume(AudioFrame frame) throws InterruptedException {
        if (this.stopping != null && this.stopping.get()) {
            throw new InterruptedException();
        }
        if (!this.locked) {
            this.receivedFrames = true;
            if (this.clearOnInsert) {
                this.audioFrames.clear();
                this.clearOnInsert = false;
            }
            if (frame instanceof AbstractMutableAudioFrame) {
                frame = ((AbstractMutableAudioFrame)frame).freeze();
            }
            this.audioFrames.put(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AudioFrame fetchPendingTerminator() {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.terminateOnEmpty) {
                this.terminateOnEmpty = false;
                this.terminated = true;
                this.synchronizer.notifyAll();
                return TerminatorAudioFrame.INSTANCE;
            }
        }
        return null;
    }

    private AudioFrame filterFrame(AudioFrame frame) {
        if (frame != null && frame.getVolume() == 0) {
            return new ImmutableAudioFrame(frame.getTimecode(), this.format.silenceBytes(), 0, this.format);
        }
        return frame;
    }

    @Override
    protected void signalWaiters() {
        this.audioFrames.offer(TerminatorAudioFrame.INSTANCE);
    }
}

