/*
 * Decompiled with CFR 0.152.
 */
package dev.derock.svcmusic;

import dev.derock.svcmusic.audio.MusicManager;
import dev.derock.svcmusic.commands.BassboostCommand;
import dev.derock.svcmusic.commands.KillCommand;
import dev.derock.svcmusic.commands.NowPlayingCommand;
import dev.derock.svcmusic.commands.PauseCommand;
import dev.derock.svcmusic.commands.PlayCommand;
import dev.derock.svcmusic.commands.QueueCommand;
import dev.derock.svcmusic.commands.ResumeCommand;
import dev.derock.svcmusic.commands.SearchCommand;
import dev.derock.svcmusic.commands.SkipCommand;
import dev.derock.svcmusic.commands.StopCommand;
import dev.derock.svcmusic.commands.VolumeCommand;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVoiceChatMusic
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger("simple-voice-chat-music");
    public static ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(1, r -> {
        Thread thread = new Thread(r, "SVCMusicExecutor");
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((t, e) -> LOGGER.error("Uncaught exception in thread {}", (Object)t.getName(), (Object)e));
        return thread;
    });

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register(SearchCommand::register);
        CommandRegistrationCallback.EVENT.register(NowPlayingCommand::register);
        CommandRegistrationCallback.EVENT.register(SkipCommand::register);
        CommandRegistrationCallback.EVENT.register(PlayCommand::register);
        CommandRegistrationCallback.EVENT.register(QueueCommand::register);
        CommandRegistrationCallback.EVENT.register(PauseCommand::register);
        CommandRegistrationCallback.EVENT.register(ResumeCommand::register);
        CommandRegistrationCallback.EVENT.register(StopCommand::register);
        CommandRegistrationCallback.EVENT.register(KillCommand::register);
        CommandRegistrationCallback.EVENT.register(VolumeCommand::register);
        CommandRegistrationCallback.EVENT.register(BassboostCommand::register);
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            LOGGER.info("Cleaning up due to shutdown.");
            MusicManager.getInstance().cleanup();
        });
        LOGGER.info("Loaded Simple Voice Chat Music!");
    }
}

