/*
 * Decompiled with CFR 0.152.
 */
package dev.derock.svcmusic.apachehttp.impl.client;

import dev.derock.svcmusic.apachehttp.ConnectionReuseStrategy;
import dev.derock.svcmusic.apachehttp.HttpEntity;
import dev.derock.svcmusic.apachehttp.HttpException;
import dev.derock.svcmusic.apachehttp.HttpHost;
import dev.derock.svcmusic.apachehttp.HttpResponse;
import dev.derock.svcmusic.apachehttp.HttpVersion;
import dev.derock.svcmusic.apachehttp.auth.AuthSchemeRegistry;
import dev.derock.svcmusic.apachehttp.auth.AuthScope;
import dev.derock.svcmusic.apachehttp.auth.AuthState;
import dev.derock.svcmusic.apachehttp.auth.Credentials;
import dev.derock.svcmusic.apachehttp.client.config.RequestConfig;
import dev.derock.svcmusic.apachehttp.client.params.HttpClientParamConfig;
import dev.derock.svcmusic.apachehttp.client.protocol.RequestClientConnControl;
import dev.derock.svcmusic.apachehttp.config.ConnectionConfig;
import dev.derock.svcmusic.apachehttp.conn.HttpConnectionFactory;
import dev.derock.svcmusic.apachehttp.conn.ManagedHttpClientConnection;
import dev.derock.svcmusic.apachehttp.conn.routing.HttpRoute;
import dev.derock.svcmusic.apachehttp.conn.routing.RouteInfo;
import dev.derock.svcmusic.apachehttp.entity.BufferedHttpEntity;
import dev.derock.svcmusic.apachehttp.impl.DefaultConnectionReuseStrategy;
import dev.derock.svcmusic.apachehttp.impl.auth.BasicSchemeFactory;
import dev.derock.svcmusic.apachehttp.impl.auth.DigestSchemeFactory;
import dev.derock.svcmusic.apachehttp.impl.auth.HttpAuthenticator;
import dev.derock.svcmusic.apachehttp.impl.auth.KerberosSchemeFactory;
import dev.derock.svcmusic.apachehttp.impl.auth.NTLMSchemeFactory;
import dev.derock.svcmusic.apachehttp.impl.auth.SPNegoSchemeFactory;
import dev.derock.svcmusic.apachehttp.impl.client.BasicCredentialsProvider;
import dev.derock.svcmusic.apachehttp.impl.client.ProxyAuthenticationStrategy;
import dev.derock.svcmusic.apachehttp.impl.conn.ManagedHttpClientConnectionFactory;
import dev.derock.svcmusic.apachehttp.impl.execchain.TunnelRefusedException;
import dev.derock.svcmusic.apachehttp.message.BasicHttpRequest;
import dev.derock.svcmusic.apachehttp.params.BasicHttpParams;
import dev.derock.svcmusic.apachehttp.params.HttpParamConfig;
import dev.derock.svcmusic.apachehttp.params.HttpParams;
import dev.derock.svcmusic.apachehttp.protocol.BasicHttpContext;
import dev.derock.svcmusic.apachehttp.protocol.HttpProcessor;
import dev.derock.svcmusic.apachehttp.protocol.HttpRequestExecutor;
import dev.derock.svcmusic.apachehttp.protocol.ImmutableHttpProcessor;
import dev.derock.svcmusic.apachehttp.protocol.RequestTargetHost;
import dev.derock.svcmusic.apachehttp.protocol.RequestUserAgent;
import dev.derock.svcmusic.apachehttp.util.Args;
import dev.derock.svcmusic.apachehttp.util.EntityUtils;
import java.io.IOException;
import java.net.Socket;

public class ProxyClient {
    private final HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory;
    private final ConnectionConfig connectionConfig;
    private final RequestConfig requestConfig;
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor requestExec;
    private final ProxyAuthenticationStrategy proxyAuthStrategy;
    private final HttpAuthenticator authenticator;
    private final AuthState proxyAuthState;
    private final AuthSchemeRegistry authSchemeRegistry;
    private final ConnectionReuseStrategy reuseStrategy;

    public ProxyClient(HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, ConnectionConfig connectionConfig, RequestConfig requestConfig) {
        this.connFactory = connFactory != null ? connFactory : ManagedHttpClientConnectionFactory.INSTANCE;
        this.connectionConfig = connectionConfig != null ? connectionConfig : ConnectionConfig.DEFAULT;
        this.requestConfig = requestConfig != null ? requestConfig : RequestConfig.DEFAULT;
        this.httpProcessor = new ImmutableHttpProcessor(new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent());
        this.requestExec = new HttpRequestExecutor();
        this.proxyAuthStrategy = new ProxyAuthenticationStrategy();
        this.authenticator = new HttpAuthenticator();
        this.proxyAuthState = new AuthState();
        this.authSchemeRegistry = new AuthSchemeRegistry();
        this.authSchemeRegistry.register("Basic", new BasicSchemeFactory());
        this.authSchemeRegistry.register("Digest", new DigestSchemeFactory());
        this.authSchemeRegistry.register("NTLM", new NTLMSchemeFactory());
        this.authSchemeRegistry.register("Negotiate", new SPNegoSchemeFactory());
        this.authSchemeRegistry.register("Kerberos", new KerberosSchemeFactory());
        this.reuseStrategy = new DefaultConnectionReuseStrategy();
    }

    @Deprecated
    public ProxyClient(HttpParams params) {
        this(null, HttpParamConfig.getConnectionConfig(params), HttpClientParamConfig.getRequestConfig(params));
    }

    public ProxyClient(RequestConfig requestConfig) {
        this(null, null, requestConfig);
    }

    public ProxyClient() {
        this(null, null, null);
    }

    @Deprecated
    public HttpParams getParams() {
        return new BasicHttpParams();
    }

    @Deprecated
    public AuthSchemeRegistry getAuthSchemeRegistry() {
        return this.authSchemeRegistry;
    }

    public Socket tunnel(HttpHost proxy, HttpHost target, Credentials credentials) throws IOException, HttpException {
        HttpEntity entity;
        int status;
        HttpResponse response;
        Args.notNull(proxy, "Proxy host");
        Args.notNull(target, "Target host");
        Args.notNull(credentials, "Credentials");
        HttpHost host = target;
        if (host.getPort() <= 0) {
            host = new HttpHost(host.getHostName(), 80, host.getSchemeName());
        }
        HttpRoute route = new HttpRoute(host, this.requestConfig.getLocalAddress(), proxy, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        ManagedHttpClientConnection conn = this.connFactory.create(route, this.connectionConfig);
        BasicHttpContext context = new BasicHttpContext();
        BasicHttpRequest connect = new BasicHttpRequest("CONNECT", host.toHostString(), HttpVersion.HTTP_1_1);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(proxy), credentials);
        context.setAttribute("http.target_host", target);
        context.setAttribute("http.connection", conn);
        context.setAttribute("http.request", connect);
        context.setAttribute("http.route", route);
        context.setAttribute("http.auth.proxy-scope", this.proxyAuthState);
        context.setAttribute("http.auth.credentials-provider", credsProvider);
        context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        context.setAttribute("http.request-config", this.requestConfig);
        this.requestExec.preProcess(connect, this.httpProcessor, context);
        while (true) {
            if (!conn.isOpen()) {
                Socket socket = new Socket(proxy.getHostName(), proxy.getPort());
                conn.bind(socket);
            }
            this.authenticator.generateAuthResponse(connect, this.proxyAuthState, context);
            response = this.requestExec.execute(connect, conn, context);
            status = response.getStatusLine().getStatusCode();
            if (status < 200) {
                throw new HttpException("Unexpected response to CONNECT request: " + response.getStatusLine());
            }
            if (!this.authenticator.isAuthenticationRequested(proxy, response, this.proxyAuthStrategy, this.proxyAuthState, context) || !this.authenticator.handleAuthChallenge(proxy, response, this.proxyAuthStrategy, this.proxyAuthState, context)) break;
            if (this.reuseStrategy.keepAlive(response, context)) {
                entity = response.getEntity();
                EntityUtils.consume(entity);
            } else {
                conn.close();
            }
            connect.removeHeaders("Proxy-Authorization");
        }
        status = response.getStatusLine().getStatusCode();
        if (status > 299) {
            entity = response.getEntity();
            if (entity != null) {
                response.setEntity(new BufferedHttpEntity(entity));
            }
            conn.close();
            throw new TunnelRefusedException("CONNECT refused by proxy: " + response.getStatusLine(), response);
        }
        return conn.getSocket();
    }
}

