/*
 * Decompiled with CFR 0.152.
 */
package dev.derock.svcmusic.apachehttp.impl.cookie;

import dev.derock.svcmusic.apachehttp.annotation.Contract;
import dev.derock.svcmusic.apachehttp.annotation.ThreadingBehavior;
import dev.derock.svcmusic.apachehttp.cookie.CommonCookieAttributeHandler;
import dev.derock.svcmusic.apachehttp.cookie.Cookie;
import dev.derock.svcmusic.apachehttp.cookie.CookieOrigin;
import dev.derock.svcmusic.apachehttp.cookie.MalformedCookieException;
import dev.derock.svcmusic.apachehttp.cookie.SetCookie;
import dev.derock.svcmusic.apachehttp.impl.cookie.AbstractCookieAttributeHandler;
import dev.derock.svcmusic.apachehttp.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

