/*
 * Decompiled with CFR 0.152.
 */
package dev.derock.svcmusic.apachehttp.impl.entity;

import dev.derock.svcmusic.apachehttp.HttpException;
import dev.derock.svcmusic.apachehttp.HttpMessage;
import dev.derock.svcmusic.apachehttp.ProtocolException;
import dev.derock.svcmusic.apachehttp.annotation.Contract;
import dev.derock.svcmusic.apachehttp.annotation.ThreadingBehavior;
import dev.derock.svcmusic.apachehttp.entity.ContentLengthStrategy;
import dev.derock.svcmusic.apachehttp.impl.entity.LaxContentLengthStrategy;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

