/*
 * Decompiled with CFR 0.152.
 */
package dev.derock.svcmusic.audio;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import dev.derock.svcmusic.SimpleVoiceChatMusic;
import dev.derock.svcmusic.audio.GroupManager;
import dev.derock.svcmusic.util.ModUtils;
import net.minecraft.class_2561;

public class TrackScheduler
extends AudioEventAdapter {
    private final GroupManager group;

    TrackScheduler(GroupManager groupManager) {
        this.group = groupManager;
    }

    @Override
    public void onTrackStart(AudioPlayer player, AudioTrack track) {
        this.group.broadcast(class_2561.method_43470((String)"Now playing: ").method_10852((class_2561)ModUtils.trackInfo(track.getInfo())));
    }

    @Override
    public void onTrackEnd(AudioPlayer player, AudioTrack track, AudioTrackEndReason endReason) {
        if (endReason.mayStartNext) {
            this.group.nextTrack();
        }
    }

    @Override
    public void onTrackException(AudioPlayer player, AudioTrack track, FriendlyException exception) {
        if (exception.severity == FriendlyException.Severity.COMMON) {
            SimpleVoiceChatMusic.LOGGER.warn("Failed to play {} due to error: {}", (Object)track.getInfo().title, (Object)exception.getMessage());
            this.group.broadcast(class_2561.method_43470((String)("Failed to play song: " + exception.getMessage())));
        } else {
            SimpleVoiceChatMusic.LOGGER.error("Failed to play {} due to error: {}", (Object)track.getInfo().title, (Object)exception.getMessage());
            this.group.broadcast(class_2561.method_43470((String)"Failed to play song due to an internal error."));
        }
        this.group.nextTrack();
    }

    @Override
    public void onTrackStuck(AudioPlayer player, AudioTrack track, long thresholdMs) {
        this.group.broadcast(class_2561.method_43470((String)"Track stuck -- skipping!"));
        this.group.nextTrack();
    }
}

