/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.playerentity.textures;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.file.type.FileMediaType;
import de.keksuccino.fancymenu.util.file.type.types.FileTypes;
import de.keksuccino.fancymenu.util.minecraftuser.v2.MinecraftUsers;
import de.keksuccino.fancymenu.util.resource.Resource;
import de.keksuccino.fancymenu.util.resource.ResourceHandlers;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import de.keksuccino.fancymenu.util.resource.ResourceSourceType;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.resource.resources.texture.PngTexture;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapeResourceSupplier
extends ResourceSupplier<ITexture> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final class_2960 DEFAULT_CAPE_LOCATION = class_2960.method_60655((String)"fancymenu", (String)"textures/player_entity/default_cape_texture.png");
    public static final PngTexture DEFAULT_CAPE = PngTexture.location(DEFAULT_CAPE_LOCATION);
    protected static final Map<String, String> CACHED_PLAYER_NAME_CAPE_URLS = new HashMap<String, String>();
    protected boolean sourceIsPlayerName;
    @Nullable
    protected volatile String playerNameCapeUrl;
    protected volatile boolean startedFindingPlayerNameCapeUrl = false;
    @Nullable
    protected String lastGetterPlayerName;
    protected volatile boolean hasNoCape = false;

    public CapeResourceSupplier(@NotNull String source, boolean sourceIsPlayerName) {
        super(ITexture.class, FileMediaType.IMAGE, source);
        this.sourceIsPlayerName = sourceIsPlayerName;
    }

    @Override
    @NotNull
    public ITexture get() {
        String playerNameCapeUrlCached = this.playerNameCapeUrl;
        String getterPlayerName = PlaceholderParser.replacePlaceholders(this.source, false);
        if (this.sourceIsPlayerName) {
            if (!getterPlayerName.equals(this.lastGetterPlayerName)) {
                this.startedFindingPlayerNameCapeUrl = false;
                this.current = null;
                this.playerNameCapeUrl = null;
                playerNameCapeUrlCached = null;
            }
            this.lastGetterPlayerName = getterPlayerName;
            if (playerNameCapeUrlCached == null && !this.startedFindingPlayerNameCapeUrl) {
                if (CACHED_PLAYER_NAME_CAPE_URLS.containsKey(getterPlayerName)) {
                    this.startedFindingPlayerNameCapeUrl = true;
                    playerNameCapeUrlCached = this.playerNameCapeUrl = CACHED_PLAYER_NAME_CAPE_URLS.get(getterPlayerName);
                } else {
                    this.findPlayerNameCapeUrl(getterPlayerName);
                }
            }
            if (playerNameCapeUrlCached == null) {
                return DEFAULT_CAPE;
            }
        }
        if (this.current != null && ((ITexture)this.current).isClosed()) {
            this.current = null;
        }
        Object getterSource = PlaceholderParser.replacePlaceholders(this.source, false);
        if (this.sourceIsPlayerName && playerNameCapeUrlCached == null) {
            return DEFAULT_CAPE;
        }
        if (this.sourceIsPlayerName) {
            getterSource = ResourceSourceType.WEB.getSourcePrefix() + playerNameCapeUrlCached;
        }
        if (!((String)getterSource).equals(this.lastGetterSource)) {
            this.current = null;
        }
        this.lastGetterSource = getterSource;
        if (this.current == null) {
            ResourceSource resourceSource = ResourceSource.of((String)getterSource);
            if (this.sourceIsPlayerName && !CACHED_PLAYER_NAME_CAPE_URLS.containsKey(getterPlayerName)) {
                CACHED_PLAYER_NAME_CAPE_URLS.put(getterPlayerName, playerNameCapeUrlCached);
            }
            try {
                if (this.sourceIsPlayerName) {
                    Resource resource = this.current = ResourceHandlers.getImageHandler().hasResource(resourceSource.getSourceWithPrefix()) ? ResourceHandlers.getImageHandler().get(resourceSource) : (ITexture)FileTypes.PNG_IMAGE.getCodec().readWeb(resourceSource.getSourceWithoutPrefix());
                    if (this.current != null) {
                        ResourceHandlers.getImageHandler().registerIfKeyAbsent(resourceSource.getSourceWithPrefix(), (ITexture)this.current);
                    } else {
                        LOGGER.error("[FANCYMENU] CapeResourceSupplier failed to get cape by player name! PNG codec returned NULL: " + String.valueOf(resourceSource));
                        this.current = DEFAULT_CAPE;
                    }
                } else {
                    this.current = ResourceHandlers.getImageHandler().get(resourceSource);
                }
            }
            catch (Exception ex) {
                LOGGER.error("[FANCYMENU] CapeResourceSupplier failed to get cape: " + String.valueOf(resourceSource) + " (" + this.source + ")", (Throwable)ex);
            }
        }
        return this.current != null ? (ITexture)this.current : DEFAULT_CAPE;
    }

    @NotNull
    public class_2960 getCapeLocation() {
        class_2960 loc = this.get().getResourceLocation();
        return loc != null ? loc : DEFAULT_CAPE_LOCATION;
    }

    public boolean hasNoCape() {
        return this.hasNoCape;
    }

    protected void findPlayerNameCapeUrl(@NotNull String getterPlayerName) {
        Objects.requireNonNull(getterPlayerName);
        this.startedFindingPlayerNameCapeUrl = true;
        new Thread(() -> {
            String capeUrl = null;
            MinecraftProfileTexture texture = MinecraftUsers.getProfileTexture(getterPlayerName, MinecraftProfileTexture.Type.CAPE);
            if (texture != null && texture != MinecraftUsers.MISSING_CAPE_TEXTURE) {
                capeUrl = texture.getUrl();
                if (capeUrl == null) {
                    LOGGER.error("[FANCYMENU] CapeResourceSupplier failed to get URL of player cape: " + getterPlayerName, (Throwable)new IOException());
                }
            } else {
                this.hasNoCape = true;
            }
            if (!this.startedFindingPlayerNameCapeUrl) {
                return;
            }
            this.playerNameCapeUrl = capeUrl;
        }).start();
    }

    @Override
    public void setSource(@NotNull String source) {
        throw new RuntimeException("You can't update the source of CapeResourceSuppliers.");
    }

    @Override
    @NotNull
    public ResourceSourceType getSourceType() {
        if (this.sourceIsPlayerName) {
            return ResourceSourceType.WEB;
        }
        return super.getSourceType();
    }

    @Override
    @NotNull
    public String getSourceWithoutPrefix() {
        if (this.sourceIsPlayerName) {
            return this.source;
        }
        return super.getSourceWithoutPrefix();
    }

    @Override
    @NotNull
    public String getSourceWithPrefix() {
        if (this.sourceIsPlayerName) {
            return this.source;
        }
        return super.getSourceWithPrefix();
    }
}

