/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.overlay;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.animation.AnimationHandler;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.overlay.DebugOverlay;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.slideshow.ExternalTextureSlideshowRenderer;
import de.keksuccino.fancymenu.customization.slideshow.SlideshowHandler;
import de.keksuccino.fancymenu.util.MathUtils;
import de.keksuccino.fancymenu.util.PerformanceUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.menubar.v2.MenuBar;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4494;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class DebugOverlayBuilder {
    @NotNull
    public static DebugOverlay buildDebugOverlay(@NotNull MenuBar menuBar) {
        DebugOverlay overlay = new DebugOverlay();
        overlay.setLineTextShadow(false);
        int menuBarHeight = (int)((float)menuBar.getHeight() * UIBase.calculateFixedScale(menuBar.getScale()));
        overlay.setTopYOffsetSupplier(() -> menuBarHeight + 10);
        overlay.setBottomYOffsetSupplier(() -> -10);
        class_437 current = class_310.method_1551().field_1755;
        if (current == null) {
            return overlay;
        }
        ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen(current);
        if (layer == null) {
            return overlay;
        }
        DebugOverlayBuilder.addScreenCategory(overlay, current, layer);
        DebugOverlayBuilder.addResourcesCategory(overlay);
        DebugOverlayBuilder.addSystemCategory(overlay);
        overlay.addLine("right_click_elements", DebugOverlay.LinePosition.TOP_LEFT, consumes -> class_2561.method_43471((String)"fancymenu.overlay.debug.right_click_elements"));
        return overlay;
    }

    private static void addScreenCategory(@NotNull DebugOverlay overlay, @NotNull class_437 currentScreen, @NotNull ScreenCustomizationLayer currentScreenLayer) {
        if (!FancyMenu.getOptions().debugOverlayShowBasicScreenCategory.getValue().booleanValue() && !FancyMenu.getOptions().debugOverlayShowAdvancedScreenCategory.getValue().booleanValue()) {
            return;
        }
        String currentIdentifier = ScreenIdentifierHandler.getIdentifierOfScreen(currentScreen);
        boolean customizationEnabled = ScreenCustomization.isCustomizationEnabledForScreen(currentScreen);
        List<Layout> allLayoutsCurrent = LayoutHandler.getAllLayoutsForScreenIdentifier(currentIdentifier, false);
        List<Layout> allUniversalLayoutsCurrent = LayoutHandler.getAllLayoutsForScreenIdentifier("%fancymenu:universal_layout%", true);
        ArrayList<Layout> enabledUniversalLayoutsCurrent = new ArrayList<Layout>();
        for (Layout l : currentScreenLayer.activeLayouts) {
            if (!l.isUniversalLayout()) continue;
            enabledUniversalLayoutsCurrent.add(l);
        }
        if (FancyMenu.getOptions().debugOverlayShowBasicScreenCategory.getValue().booleanValue()) {
            overlay.addLine("screen_identifier", DebugOverlay.LinePosition.TOP_LEFT, consumes -> {
                class_5250 c = class_2561.method_43469((String)"fancymenu.overlay.debug.screen_identifier", (Object[])new Object[]{currentIdentifier});
                if (consumes.isHovered()) {
                    c = c.method_10862(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
                }
                if (consumes.recentlyClicked()) {
                    c = class_2561.method_43471((String)"fancymenu.overlay.debug.screen_identifier.copied").method_10862(class_2583.field_24360.method_10977(class_124.field_1060));
                }
                return c;
            }).setClickAction(line -> class_310.method_1551().field_1774.method_1455(currentIdentifier));
            overlay.addLine("screen_size", DebugOverlay.LinePosition.TOP_LEFT, consumes -> class_2561.method_43469((String)"fancymenu.overlay.debug.screen_size", (Object[])new Object[]{"" + class_310.method_1551().method_22683().method_4480(), "" + class_310.method_1551().method_22683().method_4507()}));
        }
        if (FancyMenu.getOptions().debugOverlayShowAdvancedScreenCategory.getValue().booleanValue()) {
            overlay.addLine("active_layout_count", DebugOverlay.LinePosition.TOP_LEFT, consumes -> class_2561.method_43469((String)"fancymenu.overlay.debug.screen_active_layout_count", (Object[])new Object[]{"" + (customizationEnabled ? currentScreenLayer.activeLayouts.size() : 0), "" + (customizationEnabled ? enabledUniversalLayoutsCurrent.size() : 0)}));
            overlay.addLine("total_layout_count", DebugOverlay.LinePosition.TOP_LEFT, consumes -> class_2561.method_43469((String)"fancymenu.overlay.debug.screen_total_layout_count", (Object[])new Object[]{"" + (allLayoutsCurrent.size() + allUniversalLayoutsCurrent.size()), "" + allUniversalLayoutsCurrent.size()}));
            overlay.addLine("active_elements_count", DebugOverlay.LinePosition.TOP_LEFT, consumes -> class_2561.method_43469((String)"fancymenu.overlay.debug.screen_active_element_count", (Object[])new Object[]{"" + (customizationEnabled ? currentScreenLayer.allElements.size() : 0)}));
        }
        overlay.addSpacerLine("spacer_after_active_element_count", DebugOverlay.LinePosition.TOP_LEFT, 5);
    }

    private static void addResourcesCategory(@NotNull DebugOverlay overlay) {
        if (!FancyMenu.getOptions().debugOverlayShowResourcesCategory.getValue().booleanValue()) {
            return;
        }
        int animationCount = AnimationHandler.getAnimations().size();
        int totalAnimationFrameCount = 0;
        boolean tooHighAnimationResolution = false;
        for (IAnimationRenderer ani : AnimationHandler.getAnimations()) {
            totalAnimationFrameCount += ani.animationFrames();
            if (ani.getWidth() <= 1920 && ani.getHeight() <= 1080) continue;
            tooHighAnimationResolution = true;
        }
        boolean tooManyAnimationFrames = totalAnimationFrameCount > 500;
        int finalTotalAnimationFrameCount = totalAnimationFrameCount;
        int slideshowCount = SlideshowHandler.getSlideshows().size();
        int totalSlideshowImages = 0;
        for (ExternalTextureSlideshowRenderer slide : SlideshowHandler.getSlideshows()) {
            totalSlideshowImages += slide.getImageCount();
        }
        int finalTotalSlideshowImages = totalSlideshowImages;
        overlay.addLine("total_animations", DebugOverlay.LinePosition.TOP_LEFT, consumes -> class_2561.method_43469((String)"fancymenu.overlay.debug.loaded_animations", (Object[])new Object[]{"" + animationCount, "" + finalTotalAnimationFrameCount}));
        if (tooManyAnimationFrames) {
            overlay.addLine("too_many_animation_frames", DebugOverlay.LinePosition.TOP_LEFT, consumes -> class_2561.method_43471((String)"fancymenu.overlay.debug.loaded_animations.too_many_frames").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
        }
        if (tooHighAnimationResolution) {
            overlay.addLine("too_high_resolution", DebugOverlay.LinePosition.TOP_LEFT, consumes -> class_2561.method_43471((String)"fancymenu.overlay.debug.loaded_animations.resolution_too_high").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
        }
        overlay.addLine("total_slideshows", DebugOverlay.LinePosition.TOP_LEFT, consumes -> class_2561.method_43469((String)"fancymenu.overlay.debug.loaded_slideshows", (Object[])new Object[]{"" + slideshowCount, "" + finalTotalSlideshowImages}));
        overlay.addSpacerLine("spacer_after_total_slideshows", DebugOverlay.LinePosition.TOP_LEFT, 5);
    }

    private static void addSystemCategory(@NotNull DebugOverlay overlay) {
        if (!FancyMenu.getOptions().debugOverlayShowSystemCategory.getValue().booleanValue()) {
            return;
        }
        overlay.addLine("frames_per_second", DebugOverlay.LinePosition.TOP_LEFT, consumes -> {
            int fps = class_310.method_1551().method_47599();
            class_5250 fpsComp = class_2561.method_43470((String)("" + fps));
            if (fps < 20) {
                fpsComp = fpsComp.method_10862(class_2583.field_24360.method_10977(class_124.field_1065));
            }
            if (fps < 10) {
                fpsComp = fpsComp.method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
            }
            return class_2561.method_43469((String)"fancymenu.overlay.debug.fps", (Object[])new Object[]{fpsComp});
        });
        overlay.addLine("ram_usage", DebugOverlay.LinePosition.TOP_LEFT, consumes -> {
            long max = Runtime.getRuntime().maxMemory();
            long total = Runtime.getRuntime().totalMemory();
            long free = Runtime.getRuntime().freeMemory();
            long used = total - free;
            long percent = (total - free) * 100L / max;
            String ramString = DebugOverlayBuilder.bytesToMb(used) + "/" + DebugOverlayBuilder.bytesToMb(max) + "MB";
            String percentString = percent + "%";
            if (percent >= 60L) {
                percentString = String.valueOf(class_124.field_1065) + percent + "%" + String.valueOf(class_124.field_1070);
            }
            if (percent >= 80L) {
                percentString = String.valueOf(class_124.field_1061) + percent + "%" + String.valueOf(class_124.field_1070);
            }
            return class_2561.method_43469((String)"fancymenu.overlay.debug.memory", (Object[])new Object[]{ramString, percentString});
        });
        overlay.addLine("cpu_jvm_usage", DebugOverlay.LinePosition.TOP_LEFT, consumes -> {
            double usage = PerformanceUtils.getJvmCpuUsage();
            if (usage < 0.0) {
                usage = 0.0;
            }
            usage *= 100.0;
            usage = MathUtils.round(usage, 1);
            String usageString = usage + "%";
            if (usage > 50.0) {
                usageString = String.valueOf(class_124.field_1065) + usage + "%" + String.valueOf(class_124.field_1070);
            }
            if (usage >= 80.0) {
                usageString = String.valueOf(class_124.field_1061) + usage + "%" + String.valueOf(class_124.field_1070);
            }
            return class_2561.method_43469((String)"fancymenu.overlay.debug.cpu_usage.jvm", (Object[])new Object[]{usageString});
        });
        overlay.addLine("cpu_os_usage", DebugOverlay.LinePosition.TOP_LEFT, consumes -> {
            double usage = PerformanceUtils.getOsCpuUsage();
            if (usage < 0.0) {
                usage = 0.0;
            }
            usage *= 100.0;
            usage = MathUtils.round(usage, 1);
            String usageString = usage + "%";
            if (usage > 50.0) {
                usageString = String.valueOf(class_124.field_1065) + usage + "%" + String.valueOf(class_124.field_1070);
            }
            if (usage >= 80.0) {
                usageString = String.valueOf(class_124.field_1061) + usage + "%" + String.valueOf(class_124.field_1070);
            }
            return class_2561.method_43469((String)"fancymenu.overlay.debug.cpu_usage.os", (Object[])new Object[]{usageString});
        });
        overlay.addLine("cpu_info", DebugOverlay.LinePosition.TOP_LEFT, consumes -> class_2561.method_43469((String)"fancymenu.overlay.debug.cpu", (Object[])new Object[]{class_4494.method_22089()}));
        overlay.addLine("gpu_info", DebugOverlay.LinePosition.TOP_LEFT, consumes -> class_2561.method_43469((String)"fancymenu.overlay.debug.gpu", (Object[])new Object[]{class_4494.method_22090(), class_4494.method_22091()}));
        overlay.addSpacerLine("spacer_after_gpu_info", DebugOverlay.LinePosition.TOP_LEFT, 5);
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }
}

