/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.cycle;

import de.keksuccino.fancymenu.util.cycle.LocalizedEnumValueCycle;
import de.keksuccino.fancymenu.util.cycle.LocalizedGenericValueCycle;
import de.keksuccino.fancymenu.util.enums.LocalizedEnum;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2583;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonCycles {
    @NotNull
    public static LocalizedEnumValueCycle<CycleOnOff> cycleOnOff(@NotNull String cycleLocalizationKey) {
        return LocalizedEnumValueCycle.ofArray((String)cycleLocalizationKey, (LocalizedEnum[])new CycleOnOff[]{CycleOnOff.ON, CycleOnOff.OFF});
    }

    @NotNull
    public static LocalizedEnumValueCycle<CycleOnOff> cycleOnOff(@NotNull String cycleLocalizationKey, @NotNull CycleOnOff selectedValue) {
        return (LocalizedEnumValueCycle)LocalizedEnumValueCycle.ofArray((String)cycleLocalizationKey, (LocalizedEnum[])new CycleOnOff[]{CycleOnOff.ON, CycleOnOff.OFF}).setCurrentValue(selectedValue);
    }

    @NotNull
    public static LocalizedEnumValueCycle<CycleOnOff> cycleOnOff(@NotNull String cycleLocalizationKey, boolean selectedValue) {
        return (LocalizedEnumValueCycle)LocalizedEnumValueCycle.ofArray((String)cycleLocalizationKey, (LocalizedEnum[])new CycleOnOff[]{CycleOnOff.ON, CycleOnOff.OFF}).setCurrentValue(CycleOnOff.getByBoolean(selectedValue));
    }

    @NotNull
    public static LocalizedEnumValueCycle<CycleEnabledDisabled> cycleEnabledDisabled(@NotNull String cycleLocalizationKey) {
        return LocalizedEnumValueCycle.ofArray((String)cycleLocalizationKey, (LocalizedEnum[])new CycleEnabledDisabled[]{CycleEnabledDisabled.ENABLED, CycleEnabledDisabled.DISABLED});
    }

    @NotNull
    public static LocalizedEnumValueCycle<CycleEnabledDisabled> cycleEnabledDisabled(@NotNull String cycleLocalizationKey, @NotNull CycleEnabledDisabled selectedValue) {
        return (LocalizedEnumValueCycle)LocalizedEnumValueCycle.ofArray((String)cycleLocalizationKey, (LocalizedEnum[])new CycleEnabledDisabled[]{CycleEnabledDisabled.ENABLED, CycleEnabledDisabled.DISABLED}).setCurrentValue(selectedValue);
    }

    @NotNull
    public static LocalizedEnumValueCycle<CycleEnabledDisabled> cycleEnabledDisabled(@NotNull String cycleLocalizationKey, boolean selectedValue) {
        return (LocalizedEnumValueCycle)LocalizedEnumValueCycle.ofArray((String)cycleLocalizationKey, (LocalizedEnum[])new CycleEnabledDisabled[]{CycleEnabledDisabled.ENABLED, CycleEnabledDisabled.DISABLED}).setCurrentValue(CycleEnabledDisabled.getByBoolean(selectedValue));
    }

    @NotNull
    public static <T> LocalizedGenericValueCycle<T> cycleOrangeValue(@NotNull String cycleLocalizationKey, @NotNull List<T> values) {
        return LocalizedGenericValueCycle.of(cycleLocalizationKey, values.toArray()).setValueComponentStyleSupplier(consumes -> LocalizedEnum.WARNING_TEXT_STYLE.get());
    }

    @NotNull
    public static <T> LocalizedGenericValueCycle<T> cycleOrangeValue(@NotNull String cycleLocalizationKey, @NotNull List<T> values, @NotNull T selectedValue) {
        return (LocalizedGenericValueCycle)CommonCycles.cycleOrangeValue(cycleLocalizationKey, values).setCurrentValue((Object)selectedValue);
    }

    @NotNull
    public static <T> LocalizedGenericValueCycle<T> cycle(@NotNull String cycleLocalizationKey, @NotNull List<T> values) {
        return LocalizedGenericValueCycle.of(cycleLocalizationKey, values.toArray());
    }

    @NotNull
    public static <T> LocalizedGenericValueCycle<T> cycle(@NotNull String cycleLocalizationKey, @NotNull List<T> values, @NotNull T selectedValue) {
        return (LocalizedGenericValueCycle)CommonCycles.cycle(cycleLocalizationKey, values).setCurrentValue((Object)selectedValue);
    }

    public static enum CycleOnOff implements LocalizedEnum<CycleOnOff>
    {
        ON("on", true, LocalizedEnum.SUCCESS_TEXT_STYLE),
        OFF("off", false, LocalizedEnum.ERROR_TEXT_STYLE);

        final String name;
        final Supplier<class_2583> style;
        final boolean valueBoolean;

        private CycleOnOff(String name, boolean valueBoolean, Supplier<class_2583> style) {
            this.name = name;
            this.style = style;
            this.valueBoolean = valueBoolean;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.general.cycle.on_off";
        }

        public boolean getAsBoolean() {
            return this.valueBoolean;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public CycleOnOff[] getValues() {
            return CycleOnOff.values();
        }

        @Override
        @Nullable
        public CycleOnOff getByNameInternal(@NotNull String name) {
            return CycleOnOff.getByName(name);
        }

        @Override
        @NotNull
        public class_2583 getValueComponentStyle() {
            return this.style.get();
        }

        public static CycleOnOff getByBoolean(boolean b) {
            if (b) {
                return ON;
            }
            return OFF;
        }

        @Nullable
        public static CycleOnOff getByName(@NotNull String name) {
            for (CycleOnOff e : CycleOnOff.values()) {
                if (!e.getName().equals(name)) continue;
                return e;
            }
            return null;
        }
    }

    public static enum CycleEnabledDisabled implements LocalizedEnum<CycleEnabledDisabled>
    {
        ENABLED("enabled", true, LocalizedEnum.SUCCESS_TEXT_STYLE),
        DISABLED("disabled", false, LocalizedEnum.ERROR_TEXT_STYLE);

        final String name;
        final Supplier<class_2583> style;
        final boolean valueBoolean;

        private CycleEnabledDisabled(String name, boolean valueBoolean, Supplier<class_2583> style) {
            this.name = name;
            this.style = style;
            this.valueBoolean = valueBoolean;
        }

        @Override
        @NotNull
        public String getLocalizationKeyBase() {
            return "fancymenu.general.cycle.enabled_disabled";
        }

        public boolean getAsBoolean() {
            return this.valueBoolean;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public CycleEnabledDisabled[] getValues() {
            return CycleEnabledDisabled.values();
        }

        @Override
        @Nullable
        public CycleEnabledDisabled getByNameInternal(@NotNull String name) {
            return CycleEnabledDisabled.getByName(name);
        }

        @Override
        @NotNull
        public class_2583 getValueComponentStyle() {
            return this.style.get();
        }

        public static CycleEnabledDisabled getByBoolean(boolean b) {
            if (b) {
                return ENABLED;
            }
            return DISABLED;
        }

        @Nullable
        public static CycleEnabledDisabled getByName(@NotNull String name) {
            for (CycleEnabledDisabled e : CycleEnabledDisabled.values()) {
                if (!e.getName().equals(name)) continue;
                return e;
            }
            return null;
        }
    }
}

