/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.api;

import com.jamieswhiteshirt.rtree3i.Entry;
import com.jamieswhiteshirt.rtree3i.Selection;
import com.mojang.authlib.GameProfile;
import draylar.goml.GetOffMyLawn;
import draylar.goml.api.Augment;
import draylar.goml.api.Claim;
import draylar.goml.api.ClaimBox;
import draylar.goml.api.ClaimUtils;
import draylar.goml.block.SelectiveClaimAugmentBlock;
import draylar.goml.other.StatusEnum;
import draylar.goml.registry.GOMLBlocks;
import eu.pb4.common.protection.api.ProtectionProvider;
import net.minecraft.class_1297;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_4538;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public final class GomlProtectionProvider
implements ProtectionProvider {
    public static ProtectionProvider INSTANCE = new GomlProtectionProvider();

    private GomlProtectionProvider() {
    }

    public boolean isProtected(class_1937 world, class_2338 pos) {
        if (world.method_8503() == null) {
            return false;
        }
        return ClaimUtils.getClaimsAt((class_4538)world, pos).isNotEmpty();
    }

    public boolean isAreaProtected(class_1937 world, class_238 box) {
        if (world.method_8503() == null) {
            return false;
        }
        return ClaimUtils.getClaimsInBox((class_4538)world, class_2338.method_49637((double)box.field_1323, (double)box.field_1322, (double)box.field_1321), class_2338.method_49637((double)box.field_1320, (double)box.field_1325, (double)box.field_1324)).isNotEmpty();
    }

    public boolean canBreakBlock(class_1937 world, class_2338 pos, GameProfile profile, @Nullable class_1657 player) {
        if (world.method_8503() == null) {
            return true;
        }
        if (player != null) {
            return ClaimUtils.canModify(world, pos, player);
        }
        Selection<Entry<ClaimBox, Claim>> claims = ClaimUtils.getClaimsAt((class_4538)world, pos);
        return claims.isEmpty() || claims.anyMatch(c -> ((Claim)c.getValue()).hasPermission(profile.getId()));
    }

    public boolean canExplodeBlock(class_1937 world, class_2338 pos, class_1927 explosion, GameProfile profile, @Nullable class_1657 player) {
        if (world.method_8503() == null) {
            return true;
        }
        return ClaimUtils.canExplosionDestroy(world, pos, (class_1297)player);
    }

    public boolean canPlaceBlock(class_1937 world, class_2338 pos, GameProfile profile, @Nullable class_1657 player) {
        return this.canBreakBlock(world, pos, profile, player);
    }

    public boolean canInteractBlock(class_1937 world, class_2338 pos, GameProfile profile, @Nullable class_1657 player) {
        if (world.method_8503() == null) {
            return true;
        }
        return GetOffMyLawn.CONFIG.canInteract(world.method_8320(pos).method_26204()) || this.canBreakBlock(world, pos, profile, player);
    }

    public boolean canInteractEntity(class_1937 world, class_1297 entity, GameProfile profile, @Nullable class_1657 player) {
        if (world.method_8503() == null) {
            return true;
        }
        return GetOffMyLawn.CONFIG.canInteract(entity) || this.canBreakBlock(world, entity.method_24515(), profile, player);
    }

    public boolean canDamageEntity(class_1937 world, class_1297 entity, GameProfile profile, @Nullable class_1657 player) {
        if (world.method_8503() == null) {
            return true;
        }
        if (entity instanceof class_1657) {
            class_1657 attackedPlayer = (class_1657)entity;
            Selection claims = ClaimUtils.getClaimsAt((class_4538)world, entity.method_24515());
            if (claims.isEmpty()) {
                return true;
            }
            if ((claims = claims.filter(e -> ((Claim)e.getValue()).hasAugment((Augment)GOMLBlocks.PVP_ARENA.getFirst()))).isEmpty()) {
                return GetOffMyLawn.CONFIG.enablePvPinClaims;
            }
            MutableBoolean obj = new MutableBoolean();
            claims.forEach(e -> {
                Claim claim = (Claim)e.getValue();
                if (!obj.getValue().booleanValue()) {
                    return;
                }
                obj.setValue(switch (claim.getData(((SelectiveClaimAugmentBlock)GOMLBlocks.PVP_ARENA.getFirst()).key)) {
                    default -> throw new MatchException(null, null);
                    case StatusEnum.TargetPlayer.EVERYONE -> true;
                    case StatusEnum.TargetPlayer.DISABLED -> {
                        if (player != null && ClaimUtils.isInAdminMode(player)) {
                            yield true;
                        }
                        yield false;
                    }
                    case StatusEnum.TargetPlayer.TRUSTED -> {
                        if (claim.hasPermission(profile.getId()) && claim.hasPermission(attackedPlayer)) {
                            yield true;
                        }
                        yield false;
                    }
                    case StatusEnum.TargetPlayer.UNTRUSTED -> !claim.hasPermission(profile.getId()) && !claim.hasPermission(attackedPlayer);
                });
            });
            return obj.getValue();
        }
        return this.canBreakBlock(world, entity.method_24515(), profile, player) || GetOffMyLawn.CONFIG.allowDamagingUnnamedHostileMobs && entity instanceof class_1588 && entity.method_5797() == null;
    }
}

