/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.api.group;

import draylar.goml.api.group.PlayerGroup;
import draylar.goml.other.GomlObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public interface PlayerGroupProvider {
    public static void register(String namespace, PlayerGroupProvider instance) {
        GomlObjects.PROVIDER_MAP.put(namespace, instance);
    }

    public static Collection<PlayerGroupProvider> getAll() {
        return GomlObjects.PROVIDER_MAP.values();
    }

    @Nullable
    public static PlayerGroupProvider get(String namespace) {
        return GomlObjects.PROVIDER_MAP.get(namespace);
    }

    public static PlayerGroup getGroup(MinecraftServer server, PlayerGroup.Key key) {
        PlayerGroupProvider p = PlayerGroupProvider.get(key.providerId());
        if (p != null) {
            return p.fromKey(server, key);
        }
        return null;
    }

    public static Collection<PlayerGroup> getShared(class_3222 player, UUID id) {
        ArrayList<PlayerGroup> list = new ArrayList<PlayerGroup>();
        for (PlayerGroupProvider provider : PlayerGroupProvider.getAll()) {
            PlayerGroup g = provider.getGroupOf((class_1657)player);
            if (g == null || !g.isPartOf(id)) continue;
            list.add(g);
        }
        return list;
    }

    public static Collection<PlayerGroup> getAllGroups(class_3222 player) {
        ArrayList<PlayerGroup> list = new ArrayList<PlayerGroup>();
        for (PlayerGroupProvider provider : PlayerGroupProvider.getAll()) {
            PlayerGroup g = provider.getGroupOf((class_1657)player);
            if (g == null) continue;
            list.add(g);
        }
        return list;
    }

    @Nullable
    public PlayerGroup getGroupOf(class_1657 var1);

    @Nullable
    public PlayerGroup getGroupOf(MinecraftServer var1, UUID var2);

    @Nullable
    public PlayerGroup fromKey(MinecraftServer var1, PlayerGroup.Key var2);

    public class_2561 getName();
}

