/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.compat;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import draylar.goml.GetOffMyLawn;
import draylar.goml.api.Claim;
import draylar.goml.api.ClaimUtils;
import draylar.goml.api.event.ClaimEvents;
import draylar.goml.api.event.ServerPlayerUpdateEvents;
import draylar.goml.cca.ClaimComponent;
import eu.pb4.polymer.core.api.block.PolymerHeadBlock;
import java.util.Base64;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import net.minecraft.server.MinecraftServer;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.MarkerAPI;
import org.jetbrains.annotations.Nullable;

public class DynmapCompat {
    private static final String gomlMarkerSetId = "gomlMarkerSet";
    private static final int[] COLORS = new int[]{13620694, 14704897, 11088031, 2394567, 15838997, 6203672, 13985167, 3619390, 0x7D7D73, 1406856, 6561948, 2961295, 6306848, 4807460, 9314593, 526863};

    public static void init(final MinecraftServer server) {
        DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

            public void apiEnabled(DynmapCommonAPI api) {
                MarkerAPI markerApi = api.getMarkerAPI();
                if (markerApi.getMarkerSet(DynmapCompat.gomlMarkerSetId) == null) {
                    markerApi.createMarkerSet(DynmapCompat.gomlMarkerSetId, "GOML Claims", null, true);
                }
                server.method_3738().forEach(world -> ((ClaimComponent)GetOffMyLawn.CLAIM.get(world)).getClaims().values().filter(claim -> DynmapCompat.getClaimMarker(claim, markerApi) == null).forEach(claim -> DynmapCompat.renderClaimArea(claim, server, markerApi)));
                ClaimEvents.CLAIM_CREATED.register(claim -> DynmapCompat.renderClaimArea(claim, server, markerApi));
                ClaimEvents.CLAIM_RESIZED.register((claim, x, y) -> DynmapCompat.resizeClaimArea(claim, server, markerApi));
                ClaimEvents.CLAIM_UPDATED.register(claim -> DynmapCompat.updateClaimArea(claim, server, markerApi));
                ClaimEvents.CLAIM_DESTROYED.register(claim -> DynmapCompat.deleteClaimArea(claim, markerApi));
                ServerPlayerUpdateEvents.NAME_CHANGED.register(player -> DynmapCompat.updateClaimAreasOfPlayer(player, server, markerApi));
            }
        });
    }

    private static void renderClaimArea(Claim claim, MinecraftServer server, MarkerAPI markerApi) {
        class_3218 serverWorld = claim.getWorldInstance(server);
        String worldName = "world";
        if (serverWorld != null) {
            worldName = serverWorld.field_24456.method_150();
        }
        ClaimCorners corners = DynmapCompat.getClaimCorners(claim);
        AreaMarker marker = markerApi.getMarkerSet(gomlMarkerSetId).createAreaMarker(DynmapCompat.getClaimId(claim), DynmapCompat.getClaimLabel(claim, server), true, worldName, corners.x, corners.z, true);
        int color = COLORS[(claim.getOrigin().hashCode() & 0xFFFF) % COLORS.length];
        marker.setFillStyle(0.25, color);
        marker.setLineStyle(2, 1.0, color);
    }

    private static void resizeClaimArea(Claim claim, MinecraftServer server, MarkerAPI markerApi) {
        ClaimCorners corners = DynmapCompat.getClaimCorners(claim);
        DynmapCompat.handleClaimAreaUpdate(claim, server, markerApi, claimArea -> claimArea.setCornerLocations(corners.x, corners.z));
    }

    private static void updateClaimArea(Claim claim, MinecraftServer server, MarkerAPI markerApi) {
        DynmapCompat.handleClaimAreaUpdate(claim, server, markerApi, claimArea -> claimArea.setLabel(DynmapCompat.getClaimLabel(claim, server), true));
    }

    private static void deleteClaimArea(Claim claim, MarkerAPI markerApi) {
        AreaMarker claimArea = DynmapCompat.getClaimMarker(claim, markerApi);
        if (claimArea != null) {
            claimArea.deleteMarker();
        }
    }

    private static void updateClaimAreasOfPlayer(class_3222 player, MinecraftServer server, MarkerAPI markerApi) {
        UUID uuid = player.method_5667();
        String name = player.method_5476().getString();
        ClaimUtils.getClaimsOwnedBy((class_4538)player.method_37908(), uuid).forEach(entry -> DynmapCompat.handleClaimAreaUpdate((Claim)entry.getValue(), server, markerApi, claimArea -> DynmapCompat.updateClaimAreaPlayerInfo(claimArea, uuid, name)));
        ClaimUtils.getClaimsTrusted((class_4538)player.method_37908(), uuid).forEach(entry -> DynmapCompat.handleClaimAreaUpdate((Claim)entry.getValue(), server, markerApi, claimArea -> DynmapCompat.updateClaimAreaPlayerInfo(claimArea, uuid, name)));
    }

    private static void updateClaimAreaPlayerInfo(AreaMarker claimArea, UUID uuid, String name) {
        String uuidDiv = DynmapCompat.getValueDiv(uuid.toString());
        if (claimArea.getLabel().contains(uuidDiv)) {
            claimArea.setLabel(claimArea.getLabel().replace(uuidDiv, DynmapCompat.getPlayerDiv(name)), true);
        }
    }

    private static void handleClaimAreaUpdate(Claim claim, MinecraftServer server, MarkerAPI markerApi, Consumer<AreaMarker> handler) {
        AreaMarker claimArea = DynmapCompat.getClaimMarker(claim, markerApi);
        if (claimArea == null) {
            DynmapCompat.renderClaimArea(claim, server, markerApi);
        } else {
            handler.accept(claimArea);
        }
    }

    private static String getClaimId(Claim claim) {
        return claim.getWorld().toString() + " - " + claim.getOrigin().method_23854();
    }

    @Nullable
    private static AreaMarker getClaimMarker(Claim claim, MarkerAPI markerApi) {
        return markerApi.getMarkerSet(gomlMarkerSetId).findAreaMarker(DynmapCompat.getClaimId(claim));
    }

    private static String getClaimLabel(Claim claim, MinecraftServer server) {
        return DynmapCompat.getLabelLine(DynmapCompat.getLabelKey("claim_type"), DynmapCompat.getValueDiv(DynmapCompat.getHeadImage(claim.getType()) + claim.getType().method_9518().getString()), false) + DynmapCompat.getPlayers(DynmapCompat.getLabelKey("owners"), claim.getOwners(), server) + DynmapCompat.getPlayers(DynmapCompat.getLabelKey("trusted"), claim.getTrusted(), server) + DynmapCompat.getAugments(claim);
    }

    private static String getPlayers(class_2561 key, Set<UUID> players, MinecraftServer server) {
        return players.isEmpty() ? "" : "<br>" + DynmapCompat.getLabelLine(key, players.stream().map(uuid -> {
            class_3222 player = server.method_3760().method_14602(uuid);
            return player == null ? server.method_3793().method_14512(uuid).map(gameProfile -> DynmapCompat.getPlayerDiv(gameProfile.getName())).orElseGet(() -> DynmapCompat.getValueDiv(uuid.toString())) : DynmapCompat.getPlayerDiv(player.method_5476().getString());
        }).reduce("", (prev, curr) -> prev + curr), true);
    }

    private static String getAugments(Claim claim) {
        return claim.hasAugment() ? "<br>" + DynmapCompat.getLabelLine(DynmapCompat.getLabelKey("augments"), claim.getAugments().values().stream().map(augment -> DynmapCompat.getValueDiv(DynmapCompat.getHeadImage((PolymerHeadBlock)augment) + augment.getAugmentName().getString())).reduce("", (prev, curr) -> prev + curr), true) : "";
    }

    private static String getLabelLine(class_2561 key, String value, boolean wrap) {
        return "<div style=\"display:flex;align-items:center;flex-wrap:" + (wrap ? "" : "no") + "wrap;gap:2%;text-wrap:nowrap\"><b>" + key.getString() + ":</b>" + value + "</div>";
    }

    private static String getPlayerDiv(String name) {
        return DynmapCompat.getValueDiv("<img src=\"tiles/faces/16x16/" + name + ".png\">" + name);
    }

    private static String getValueDiv(String content) {
        return "<div style=\"display:flex;align-items:center;gap:2%;flex-grow:1;text-wrap:nowrap\">" + content + "</div>";
    }

    private static String getHeadImage(PolymerHeadBlock polymerHeadBlock) {
        String src = DynmapCompat.getHeadUrl(polymerHeadBlock);
        return "<div style=\"min-width:16px;width:16px;height:16px;overflow:hidden;background-image:url(" + src + ");background-repeat:no-repeat;background-position:-16px -16px\"><img src=\"" + src + "\" style=\"width:128px;height:128px;margin-top:-16px;margin-left:-48px\"></div>";
    }

    private static String getHeadUrl(PolymerHeadBlock polymerHeadBlock) {
        return ((JsonObject)new Gson().fromJson(new String(Base64.getDecoder().decode(polymerHeadBlock.getPolymerSkinValue(null, null, null))), JsonObject.class)).getAsJsonObject("textures").getAsJsonObject("SKIN").getAsJsonPrimitive("url").getAsString();
    }

    private static class_2561 getLabelKey(String key) {
        return class_2561.method_43471((String)("text.goml.dynmap.label." + key));
    }

    private static ClaimCorners getClaimCorners(Claim claim) {
        class_238 claimBox = claim.getClaimBox().minecraftBox();
        return new ClaimCorners(new double[]{claimBox.field_1323, claimBox.field_1320}, new double[]{claimBox.field_1322, claimBox.field_1325}, new double[]{claimBox.field_1321, claimBox.field_1324});
    }

    private record ClaimCorners(double[] x, double[] y, double[] z) {
    }
}

