/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.config;

import com.jamieswhiteshirt.rtree3i.Box;
import draylar.goml.GetOffMyLawn;
import draylar.goml.block.ClaimAugmentBlock;
import draylar.goml.config.BaseGson;
import draylar.goml.other.WrappedText;
import draylar.goml.registry.GOMLBlocks;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.apache.commons.io.IOUtils;

public class GOMLConfig {
    public int makeshiftRadius = 10;
    public int reinforcedRadius = 25;
    public int glisteningRadius = 50;
    public int crystalRadius = 75;
    public int emeradicRadius = 125;
    public int witheredRadius = 200;
    public int maxClaimsPerPlayer = -1;
    public boolean enablePvPinClaims = false;
    public boolean allowDamagingUnnamedHostileMobs = true;
    public boolean allowDamagingNamedHostileMobs = false;
    public boolean claimProtectsFullWorldHeight = false;
    public double claimAreaHeightMultiplier = 1.0;
    public boolean makeClaimAreaChunkBound = false;
    public boolean allowClaimOverlappingIfSameOwner = false;
    public boolean allowFakePlayersToModify = false;
    public boolean protectAgainstHostileExplosionsActivatedByTrustedPlayers = false;
    public Set<class_2960> dimensionBlacklist = new HashSet<class_2960>();
    public Map<class_2960, List<Box>> regionBlacklist = new HashMap<class_2960, List<Box>>();
    public Map<class_2248, Boolean> enabledAugments = new HashMap<class_2248, Boolean>();
    public Set<class_2248> allowedBlockInteraction = new HashSet<class_2248>();
    public Set<class_1299<?>> allowedEntityInteraction = Set.of(class_1299.field_6121, class_1299.field_38096, class_1299.field_6096);
    public WrappedText messagePrefix = WrappedText.of("<dark_gray>[<#a1ff59>GOML</color>]");
    public WrappedText placeholderNoClaimInfo = WrappedText.of("<gray><italic>Wilderness");
    public WrappedText placeholderNoClaimOwners = WrappedText.of("<gray><italic>Nobody");
    public WrappedText placeholderNoClaimTrusted = WrappedText.of("<gray><italic>Nobody");
    public WrappedText placeholderClaimCanBuildInfo = WrappedText.of("${owners} <gray>(<green>${anchor}</green>)");
    public WrappedText placeholderClaimCantBuildInfo = WrappedText.of("${owners} <gray>(<red>${anchor}</red>)");

    public boolean canInteract(class_2248 block) {
        return this.allowedBlockInteraction.contains(block);
    }

    public boolean canInteract(class_1297 entity) {
        return this.allowedEntityInteraction.contains(entity.method_5864());
    }

    public boolean isBlacklisted(class_1937 world, Box claimBox) {
        if (this.dimensionBlacklist.contains(world.method_27983().method_29177())) {
            return true;
        }
        List<Box> list = this.regionBlacklist.get(world.method_27983().method_29177());
        if (list != null) {
            for (Box box : list) {
                if (!box.intersectsClosed(claimBox)) continue;
                return true;
            }
        }
        return false;
    }

    public class_5250 prefix(class_2561 text) {
        return class_2561.method_43473().method_10852(this.messagePrefix.text()).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852(text);
    }

    public static GOMLConfig loadOrCreateConfig() {
        try {
            GOMLConfig config;
            File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "getoffmylawn.json");
            if (configFile.exists()) {
                String json = IOUtils.toString((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8));
                config = (GOMLConfig)BaseGson.GSON.fromJson(json, GOMLConfig.class);
            } else {
                config = new GOMLConfig();
            }
            for (ClaimAugmentBlock augment : GOMLBlocks.AUGMENTS) {
                if (config.enabledAugments.containsKey(augment)) continue;
                config.enabledAugments.put(augment, true);
            }
            GOMLConfig.saveConfig(config);
            return config;
        }
        catch (IOException exception) {
            GetOffMyLawn.LOGGER.error("Something went wrong while reading config!");
            exception.printStackTrace();
            return new GOMLConfig();
        }
    }

    public static void saveConfig(GOMLConfig config) {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "getoffmylawn.json");
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8));
            writer.write(BaseGson.GSON.toJson((Object)config));
            writer.close();
        }
        catch (Exception e) {
            GetOffMyLawn.LOGGER.error("Something went wrong while saving config!");
            e.printStackTrace();
        }
    }
}

