/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.other;

import com.jamieswhiteshirt.rtree3i.Entry;
import com.jamieswhiteshirt.rtree3i.RTreeMap;
import com.jamieswhiteshirt.rtree3i.Selection;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import draylar.goml.GetOffMyLawn;
import draylar.goml.api.Augment;
import draylar.goml.api.Claim;
import draylar.goml.api.ClaimBox;
import draylar.goml.api.ClaimUtils;
import draylar.goml.api.DataKey;
import draylar.goml.block.entity.ClaimAnchorBlockEntity;
import draylar.goml.cca.ClaimComponent;
import draylar.goml.config.GOMLConfig;
import draylar.goml.other.GomlPlayer;
import draylar.goml.registry.GOMLEntities;
import draylar.goml.ui.ClaimListGui;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2191;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2709;
import net.minecraft.class_2743;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ClaimCommand {
    private ClaimCommand() {
    }

    public static void init() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"goml").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"help").requires(Permissions.require((String)"goml.command.command.help", (boolean)true))).executes(ClaimCommand::help))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"trust").requires(Permissions.require((String)"goml.command.command.trust", (boolean)true))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(context -> ClaimCommand.trust((CommandContext<class_2168>)context, false))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"untrust").requires(Permissions.require((String)"goml.command.command.untrust", (boolean)true))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(ctx -> ClaimCommand.untrust((CommandContext<class_2168>)ctx, false))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"addowner").requires(Permissions.require((String)"goml.command.command.addowner", (boolean)true))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(context -> ClaimCommand.trust((CommandContext<class_2168>)context, true))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(Permissions.require((String)"goml.command.command.list", (boolean)true))).executes(context -> ClaimCommand.openList((CommandContext<class_2168>)context, ((class_2168)context.getSource()).method_44023().method_7334())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"escape").requires(Permissions.require((String)"goml.command.command.escape", (boolean)true))).executes(context -> ClaimCommand.escape((CommandContext<class_2168>)context, ((class_2168)context.getSource()).method_9207())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"admin").requires(Permissions.require((String)"goml.command.command.admin", (int)3))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"fixaugments").requires(Permissions.require((String)"goml.command.command.fixaugments", (boolean)true))).executes(ClaimCommand::fixAugments))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"escape").requires(Permissions.require((String)"goml.command.command.admin.escape", (boolean)true))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> ClaimCommand.escape((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"adminmode").requires(Permissions.require((String)"goml.command.command.admin.admin_mode", (int)3))).executes(ClaimCommand::adminMode))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"removeowner").requires(Permissions.require((String)"goml.command.command.admin.removeowner", (boolean)true))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(ctx -> ClaimCommand.untrust((CommandContext<class_2168>)ctx, true))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(Permissions.require((String)"goml.command.command.admin.info", (int)3))).executes(ClaimCommand::infoAdmin))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"world").requires(Permissions.require((String)"goml.command.command.admin.world", (int)3))).executes(ClaimCommand::world))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"general").requires(Permissions.require((String)"goml.command.command.admin.general", (int)3))).executes(ClaimCommand::general))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(Permissions.require((String)"goml.command.command.admin.remove", (int)3))).executes(ClaimCommand::remove))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permissions.require((String)"goml.command.command.admin.reload", (int)4))).executes(ClaimCommand::reload))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(Permissions.require((String)"goml.command.command.list", (boolean)true))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(context -> {
            GameProfile[] player = class_2191.method_9330((CommandContext)context, (String)"player").toArray(new GameProfile[0]);
            if (player.length == 0) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"argument.player.unknown").method_27692(class_124.field_1061), false);
            }
            return ClaimCommand.openList((CommandContext<class_2168>)context, player[0]);
        }))))));
    }

    private static int fixAugments(CommandContext<class_2168> context) {
        ClaimUtils.getClaimsAt((class_4538)((class_2168)context.getSource()).method_9225(), class_2338.method_49638((class_2374)((class_2168)context.getSource()).method_9222())).forEach(x -> {
            ArrayList<Map.Entry<class_2338, Augment>> copy = new ArrayList<Map.Entry<class_2338, Augment>>(((Claim)x.getValue()).getAugments().entrySet());
            for (Map.Entry<class_2338, Augment> y : copy) {
                if (((class_2168)context.getSource()).method_9225().method_8320(y.getKey()).method_26204() == y.getValue()) continue;
                ((Claim)x.getValue()).removeAugment(y.getKey());
            }
        });
        return 0;
    }

    private static int escape(CommandContext<class_2168> context, class_3222 player) {
        Selection claims = ClaimUtils.getClaimsAt((class_4538)player.method_37908(), player.method_24515()).filter(x -> !((Claim)x.getValue()).hasPermission((class_1657)player));
        if (claims.isNotEmpty()) {
            claims.forEach(claim -> {
                if (!((ClaimBox)claim.getKey()).minecraftBox().method_1006(player.method_19538())) {
                    return;
                }
                class_3545<class_243, class_2350> pair = ClaimUtils.getClosestXZBorder((Claim)claim.getValue(), player.method_19538(), 1.0);
                class_243 pos = (class_243)pair.method_15442();
                class_2350 dir = (class_2350)pair.method_15441();
                double y = player.method_37908().method_8587((class_1297)player, player.method_18377(player.method_18376()).method_30231(pos.field_1352, player.method_23318(), pos.field_1350)) ? player.method_23318() : (double)player.method_37908().method_8624(class_2902.class_2903.field_13197, (int)pos.field_1352, (int)pos.field_1350);
                player.method_6082(pos.field_1352, y, pos.field_1350, true);
                player.method_18799(class_243.method_24954((class_2382)dir.method_10163()).method_1021(0.2));
                if (player.method_5765()) {
                    player.method_5854().method_48105((class_3218)player.method_5854().method_37908(), pos.field_1352, y, pos.field_1350, class_2709.field_40710, player.method_5854().method_36454(), player.method_5854().method_36455());
                    player.method_5854().method_18799(class_243.method_24954((class_2382)dir.method_10163()).method_1021(0.2));
                }
                player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
                if (player.method_5765()) {
                    player.field_13987.method_14364((class_2596)new class_2743(player.method_5854()));
                }
            });
            ((class_2168)context.getSource()).method_9226(() -> ClaimCommand.prefix(class_2561.method_43471((String)"text.goml.command.escaped").method_27692(class_124.field_1060)), false);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> ClaimCommand.prefix(class_2561.method_43471((String)"text.goml.command.cant_escape").method_27692(class_124.field_1061)), false);
        }
        return 0;
    }

    private static int adminMode(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        boolean newMode = !((GomlPlayer)player).goml_getAdminMode();
        ((GomlPlayer)player).goml_setAdminMode(newMode);
        ((class_2168)context.getSource()).method_9226(() -> ClaimCommand.prefix(class_2561.method_43471((String)(newMode ? "text.goml.admin_mode.enabled" : "text.goml.admin_mode.disabled"))), false);
        return 1;
    }

    private static int general(CommandContext<class_2168> context) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        AtomicInteger numberOfClaimsTotal = new AtomicInteger();
        ClaimCommand.bumpChat(player);
        server.method_3738().forEach(world -> {
            RTreeMap<ClaimBox, Claim> worldClaims = ((ClaimComponent)GetOffMyLawn.CLAIM.get(world)).getClaims();
            int numberOfClaimsWorld = worldClaims.size();
            numberOfClaimsTotal.addAndGet(1);
            player.method_7353((class_2561)ClaimCommand.prefix(class_2561.method_43469((String)"text.goml.command.number_in", (Object[])new Object[]{world.method_27983().method_29177(), numberOfClaimsWorld})), false);
        });
        player.method_7353((class_2561)ClaimCommand.prefix(class_2561.method_43469((String)"text.goml.command.number_all", (Object[])new Object[]{numberOfClaimsTotal.get()}).method_27692(class_124.field_1068)), false);
        return 1;
    }

    private static int infoAdmin(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (!world.method_8608()) {
            ClaimUtils.getClaimsAt((class_4538)world, player.method_24515()).forEach(claimedArea -> {
                player.method_7353((class_2561)ClaimCommand.prefix(class_2561.method_43470((String)("Origin: " + ((Claim)claimedArea.getValue()).getOrigin().method_23854()))), false);
                player.method_7353((class_2561)ClaimCommand.prefix(class_2561.method_43470((String)("Radius: " + ((Claim)claimedArea.getValue()).getRadius() + " Height: " + ((ClaimBox)claimedArea.getKey()).getY()))), false);
                class_5250 owners = class_2561.method_43470((String)"Owners: ");
                Iterator<UUID> iter = ((Claim)claimedArea.getValue()).getOwners().iterator();
                while (iter.hasNext()) {
                    UUID uuid = iter.next();
                    Optional gameProfile = ((class_2168)context.getSource()).method_9211().method_3793().method_14512(uuid);
                    owners.method_10852((class_2561)class_2561.method_43470((String)((gameProfile.isPresent() ? ((GameProfile)gameProfile.get()).getName() : "<unknown>") + " -> " + uuid.toString())).method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to copy"))).method_10958(new class_2558(class_2558.class_2559.field_21462, uuid.toString()))));
                    if (!iter.hasNext()) continue;
                    owners.method_27693(", ");
                }
                class_5250 trusted = class_2561.method_43470((String)"Trusted: ");
                Iterator<UUID> iter2 = ((Claim)claimedArea.getValue()).getTrusted().iterator();
                while (iter2.hasNext()) {
                    UUID uuid = iter2.next();
                    Optional gameProfile = ((class_2168)context.getSource()).method_9211().method_3793().method_14512(uuid);
                    trusted.method_10852((class_2561)class_2561.method_43470((String)((gameProfile.isPresent() ? ((GameProfile)gameProfile.get()).getName() : "<unknown>") + " -> " + uuid.toString())).method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to copy"))).method_10958(new class_2558(class_2558.class_2559.field_21462, uuid.toString()))));
                    if (!iter2.hasNext()) continue;
                    owners.method_27693(", ");
                }
                player.method_7353((class_2561)ClaimCommand.prefix(owners), false);
                player.method_7353((class_2561)ClaimCommand.prefix(trusted), false);
                player.method_7353((class_2561)ClaimCommand.prefix(class_2561.method_43470((String)"ClaimData: ")), false);
                for (DataKey<?> key : ((Claim)claimedArea.getValue()).getDataKeys()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)("- " + String.valueOf(key.key()) + " -> ")).method_10852(class_2512.method_32270((class_2520)key.serializer().apply(((Claim)claimedArea.getValue()).getData(key)))), false);
                }
            });
        }
        return 1;
    }

    private static int world(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        RTreeMap<ClaimBox, Claim> worldClaims = ((ClaimComponent)GetOffMyLawn.CLAIM.get((Object)world)).getClaims();
        int numberOfClaims = worldClaims.size();
        player.method_7353((class_2561)ClaimCommand.prefix(class_2561.method_43469((String)"text.goml.command.number_in", (Object[])new Object[]{world.method_27983().method_29177(), numberOfClaims})), false);
        return 1;
    }

    private static int remove(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (!world.method_8608()) {
            ClaimUtils.getClaimsAt((class_4538)world, player.method_24515()).forEach(claimedArea -> {
                ((Claim)claimedArea.getValue()).destroy();
                player.method_7353((class_2561)ClaimCommand.prefix(class_2561.method_43469((String)"text.goml.command.removed_claim", (Object[])new Object[]{world.method_27983().method_29177(), ((Claim)claimedArea.getValue()).getOrigin().method_23854()})), false);
                Optional blockEntity = world.method_35230(((Claim)claimedArea.getValue()).getOrigin(), GOMLEntities.CLAIM_ANCHOR);
                if (blockEntity.isPresent()) {
                    world.method_22352(((Claim)claimedArea.getValue()).getOrigin(), true);
                    for (class_2338 lPos : new ArrayList<class_2338>(((ClaimAnchorBlockEntity)((Object)((Object)blockEntity.get()))).getAugments().keySet())) {
                        world.method_22352(lPos, true);
                    }
                }
            });
        }
        return 1;
    }

    private static int help(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        Function<String, class_2561> write = command -> class_2561.method_43470((String)("/goml " + command)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43471((String)("text.goml.command.help." + command)).method_10862(class_2583.field_24360.method_36139(0xEDEDED)));
        player.method_7353((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)"Get Off My Lawn").method_10862(class_2583.field_24360.method_36139(10616665))).method_27693("]"), false);
        player.method_7353((class_2561)class_2561.method_43470((String)"-------------------------------------").method_27692(class_124.field_1063), false);
        for (CommandNode cmd : ((class_2168)context.getSource()).method_9211().method_3734().method_9235().findNode(Collections.singleton("goml")).getChildren()) {
            if (!cmd.canUse((Object)((class_2168)context.getSource()))) continue;
            player.method_7353(write.apply(cmd.getName()), false);
        }
        player.method_7353((class_2561)class_2561.method_43470((String)"-------------------------------------").method_27692(class_124.field_1063), false);
        player.method_7353((class_2561)class_2561.method_43470((String)"GitHub: ").method_10852((class_2561)class_2561.method_43470((String)"https://github.com/Patbox/get-off-my-lawn-reserved").method_10862(class_2583.field_24360.method_10977(class_124.field_1078).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, "https://github.com/Patbox/get-off-my-lawn-server-sided")))), false);
        return 1;
    }

    private static int openList(CommandContext<class_2168> context, GameProfile target) throws CommandSyntaxException {
        ClaimListGui.open(((class_2168)context.getSource()).method_44023(), target);
        return 1;
    }

    private static int openGui(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        Selection<Entry<ClaimBox, Claim>> claim = ClaimUtils.getClaimsAt((class_4538)player.method_37908(), player.method_24515());
        if (claim.isEmpty()) {
            player.method_7353((class_2561)ClaimCommand.prefix(class_2561.method_43471((String)"text.goml.command.no_claims").method_27692(class_124.field_1061)), false);
            return 0;
        }
        ((Claim)((Entry)((List)claim.collect(Collectors.toList())).get(0)).getValue()).openUi(player);
        return 1;
    }

    private static int trust(CommandContext<class_2168> context, boolean owner) throws CommandSyntaxException {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        Collection toAddCol = class_2191.method_9330(context, (String)"player");
        if (!world.method_8608()) {
            boolean skipChecks = ClaimUtils.isInAdminMode((class_1657)player);
            ClaimUtils.getClaimsAt((class_4538)world, player.method_24515()).forEach(claimedArea -> {
                for (GameProfile toAdd : toAddCol) {
                    if (!skipChecks && !((Claim)claimedArea.getValue()).isOwner((class_1657)player)) continue;
                    if (owner && !((Claim)claimedArea.getValue()).isOwner(toAdd.getId())) {
                        ((Claim)claimedArea.getValue()).addOwner(toAdd.getId());
                        player.method_7353((class_2561)ClaimCommand.prefix(class_2561.method_43469((String)"text.goml.command.owner_added", (Object[])new Object[]{toAdd.getName()})), false);
                        continue;
                    }
                    if (!owner && !((Claim)claimedArea.getValue()).getTrusted().contains(toAdd.getId())) {
                        ((Claim)claimedArea.getValue()).trust(toAdd.getId());
                        player.method_7353((class_2561)ClaimCommand.prefix(class_2561.method_43469((String)"text.goml.command.trusted", (Object[])new Object[]{toAdd.getName()})), false);
                        continue;
                    }
                    player.method_7353((class_2561)ClaimCommand.prefix(class_2561.method_43469((String)"text.goml.command.already_added", (Object[])new Object[]{toAdd.getName()})), false);
                }
            });
        }
        return 1;
    }

    private static int untrust(CommandContext<class_2168> context, boolean owner) throws CommandSyntaxException {
        class_3218 world = ((class_2168)context.getSource()).method_9225();
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        Collection toRemoveCol = class_2191.method_9330(context, (String)"player");
        ClaimUtils.getClaimsAt((class_4538)world, player.method_24515()).forEach(claimedArea -> {
            for (GameProfile toRemove : toRemoveCol) {
                if (toRemove.getId().equals(player.method_5667()) && !ClaimUtils.isInAdminMode((class_1657)player)) {
                    player.method_7353((class_2561)ClaimCommand.prefix(class_2561.method_43471((String)"text.goml.command.remove_self")), false);
                    return;
                }
                if (!((Claim)claimedArea.getValue()).isOwner((class_1657)player)) continue;
                if (owner) {
                    ((Claim)claimedArea.getValue()).getOwners().remove(toRemove.getId());
                } else {
                    ((Claim)claimedArea.getValue()).untrust(toRemove.getId());
                }
                player.method_7353((class_2561)ClaimCommand.prefix(class_2561.method_43469((String)("text.goml.command." + (owner ? "owner_removed" : "untrusted")), (Object[])new Object[]{toRemove.getName()})), false);
            }
        });
        return 1;
    }

    private static int reload(CommandContext<class_2168> context) {
        GetOffMyLawn.CONFIG = GOMLConfig.loadOrCreateConfig();
        ((class_2168)context.getSource()).method_9226(() -> ClaimCommand.prefix(class_2561.method_43470((String)"Reloaded config")), false);
        return 1;
    }

    private static void bumpChat(class_3222 player) {
        player.method_7353((class_2561)class_2561.method_43470((String)" "), false);
    }

    private static class_5250 prefix(class_5250 text) {
        return GetOffMyLawn.CONFIG.prefix((class_2561)text);
    }
}

