/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.other;

import com.mojang.authlib.GameProfile;
import draylar.goml.api.Claim;
import draylar.goml.api.group.PlayerGroup;
import draylar.goml.api.group.PlayerGroupProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_3312;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class VanillaTeamGroups {
    public static void init() {
        PlayerGroupProvider.register("minecraft_team", TeamProvider.INSTANCE);
    }

    public static void onRemove(class_268 team) {
        TeamGroup value = TeamGroup.CACHE.get(team);
        if (value != null) {
            for (Claim claim : List.copyOf(value.claims)) {
                claim.untrust(value);
            }
        }
    }

    private record TeamProvider() implements PlayerGroupProvider
    {
        public static final PlayerGroupProvider INSTANCE = new TeamProvider();

        @Override
        @Nullable
        public PlayerGroup getGroupOf(class_1657 player) {
            class_268 team = player.method_5781();
            if (team != null) {
                return TeamGroup.of(player.method_5682().method_3793(), team);
            }
            return null;
        }

        @Override
        @Nullable
        public PlayerGroup getGroupOf(MinecraftServer server, UUID uuid) {
            class_268 team;
            Optional profile = server.method_3793().method_14512(uuid);
            if (profile.isPresent() && (team = server.method_3845().method_1153(((GameProfile)profile.get()).getName())) != null) {
                return TeamGroup.of(server.method_3793(), team);
            }
            return null;
        }

        @Override
        @Nullable
        public PlayerGroup fromKey(MinecraftServer server, PlayerGroup.Key key) {
            class_268 team = server.method_3845().method_1153(key.groupId());
            if (team != null) {
                return TeamGroup.of(server.method_3793(), team);
            }
            return null;
        }

        @Override
        public class_2561 getName() {
            return class_2561.method_43471((String)"text.goml.vanilla_team.name");
        }
    }

    private record TeamGroup(class_3312 cache, class_268 team, HashSet<Claim> claims) implements PlayerGroup
    {
        public static final WeakHashMap<class_268, TeamGroup> CACHE = new WeakHashMap();

        private TeamGroup(class_3312 cache, class_268 guild) {
            this(cache, guild, new HashSet<Claim>());
        }

        public static PlayerGroup of(class_3312 cache, class_268 team) {
            TeamGroup g = CACHE.get(team);
            if (g == null) {
                g = new TeamGroup(cache, team);
                CACHE.put(team, g);
            }
            return g;
        }

        @Override
        public class_2561 selfDisplayName() {
            return this.team.method_1140();
        }

        @Override
        public class_2561 fullDisplayName() {
            return class_2561.method_43469((String)"text.goml.vanilla_team.display", (Object[])new Object[]{class_2561.method_43473().method_10852(this.selfDisplayName()).method_27692(class_124.field_1068)});
        }

        @Override
        public PlayerGroup.Key getKey() {
            return new PlayerGroup.Key("minecraft_team", this.team.method_1197());
        }

        @Override
        public class_1799 icon() {
            class_1799 stack = new class_1799((class_1935)class_1802.field_8267);
            Integer i = this.team.method_1202().method_532();
            stack.method_57379(class_9334.field_49644, (Object)new class_9282(i != null ? i : 0xFFFFFF, true));
            return stack;
        }

        @Override
        public PlayerGroupProvider provider() {
            return TeamProvider.INSTANCE;
        }

        @Override
        public boolean isPartOf(UUID uuid) {
            Optional profile = this.cache.method_14512(uuid);
            return profile.isPresent() && this.team.method_1204().contains(((GameProfile)profile.get()).getName());
        }

        @Override
        public boolean canSave() {
            return true;
        }

        @Override
        public List<PlayerGroup.Member> getMembers() {
            ArrayList<PlayerGroup.Member> list = new ArrayList<PlayerGroup.Member>();
            for (String x : this.team.method_1204()) {
                Optional profile = this.cache.method_14515(x);
                if (!profile.isPresent()) continue;
                PlayerGroup.Member member = new PlayerGroup.Member((GameProfile)profile.get(), "");
                list.add(member);
            }
            return list;
        }

        @Override
        public boolean addClaim(Claim claim) {
            return this.claims.add(claim);
        }

        @Override
        public boolean removeClaim(Claim claim) {
            return this.claims.remove(claim);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public int hashCode() {
            return this.team.method_1197().hashCode() + 31 * "minecraft_team".hashCode();
        }
    }
}

