/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.ui;

import draylar.goml.api.Augment;
import draylar.goml.api.Claim;
import draylar.goml.api.ClaimUtils;
import draylar.goml.block.entity.ClaimAnchorBlockEntity;
import draylar.goml.item.TooltippedBlockItem;
import draylar.goml.ui.PagedGui;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ClaimAugmentGui
extends PagedGui {
    private final Claim claim;
    private final boolean canModify;
    private final ClaimAnchorBlockEntity blockEntity;
    private final List<Map.Entry<class_2338, Augment>> cachedEntries = new ArrayList<Map.Entry<class_2338, Augment>>();

    public ClaimAugmentGui(class_3222 player, Claim claim, boolean canModify, @Nullable Runnable onClose) {
        super(player, onClose);
        this.claim = claim;
        this.blockEntity = ClaimUtils.getAnchor((class_1937)player.field_13995.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)claim.getWorld())), claim);
        this.canModify = canModify;
        this.setTitle((class_2561)class_2561.method_43471((String)"text.goml.gui.augment_list.title"));
        this.updateDisplay();
        this.open();
    }

    @Override
    protected void updateDisplay() {
        this.cachedEntries.clear();
        ArrayList rest = new ArrayList();
        for (Map.Entry<class_2338, Augment> entry : this.blockEntity.getAugments().entrySet()) {
            (entry.getValue().hasSettings() ? this.cachedEntries : rest).add(entry);
        }
        this.cachedEntries.addAll(rest);
        super.updateDisplay();
    }

    @Override
    protected int getPageAmount() {
        return this.blockEntity.getAugments().size() / 36;
    }

    @Override
    protected PagedGui.DisplayElement getElement(int id) {
        if (this.cachedEntries.size() > id) {
            class_1792 class_17922;
            Map.Entry<class_2338, Augment> entry = this.cachedEntries.get(id);
            GuiElementBuilder builder = new GuiElementBuilder();
            Augment augment = entry.getValue();
            if (augment instanceof class_2248) {
                class_2248 block = (class_2248)augment;
                class_17922 = block.method_8389();
            } else {
                class_17922 = null;
            }
            class_1792 item = class_17922;
            builder.hideDefaultTooltip().noDefaults();
            builder.addLoreLine((class_2561)class_2561.method_43469((String)"text.goml.position", (Object[])new Object[]{class_2561.method_43470((String)entry.getKey().method_23854()).method_27692(class_124.field_1068)}).method_27692(class_124.field_1078));
            builder.setName(entry.getValue().getAugmentName());
            if (item != null) {
                builder.setItem(item);
                if (item instanceof TooltippedBlockItem) {
                    TooltippedBlockItem tooltipped = (TooltippedBlockItem)item;
                    builder.addLoreLine((class_2561)class_2561.method_43473());
                    tooltipped.addLines(arg_0 -> ((GuiElementBuilder)builder).addLoreLine(arg_0));
                }
            }
            if (this.canModify && entry.getValue().hasSettings()) {
                builder.addLoreLine((class_2561)class_2561.method_43473());
                builder.addLoreLine((class_2561)class_2561.method_43471((String)"text.goml.gui.click_to_modify").method_27692(class_124.field_1061));
                builder.setCallback((x, y, z) -> {
                    ClaimAugmentGui.playClickSound(this.player);
                    ((Augment)entry.getValue()).openSettings(this.claim, this.player, () -> new ClaimAugmentGui(this.player, this.claim, this.canModify, this.closeCallback));
                });
            }
            return PagedGui.DisplayElement.of(builder);
        }
        return PagedGui.DisplayElement.empty();
    }
}

