/*
 * Decompiled with CFR 0.152.
 */
package draylar.goml.ui;

import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class PagedGui
extends SimpleGui {
    public static final int PAGE_SIZE = 36;
    protected final Runnable closeCallback;
    protected int page = 0;
    public boolean ignoreCloseCallback;

    public PagedGui(class_3222 player, @Nullable Runnable closeCallback) {
        super(class_3917.field_18667, player, false);
        this.closeCallback = closeCallback;
    }

    public void refreshOpen() {
        this.updateDisplay();
        this.open();
    }

    public void onClose() {
        if (this.closeCallback != null && !this.ignoreCloseCallback) {
            this.closeCallback.run();
        }
    }

    protected void nextPage() {
        this.page = Math.min(this.getPageAmount() - 1, this.page + 1);
        this.updateDisplay();
    }

    protected boolean canNextPage() {
        return this.getPageAmount() > this.page + 1;
    }

    protected void previousPage() {
        this.page = Math.max(0, this.page - 1);
        this.updateDisplay();
    }

    protected boolean canPreviousPage() {
        return this.page - 1 >= 0;
    }

    protected void updateDisplay() {
        int i;
        int offset = this.page * 36;
        for (i = 0; i < 36; ++i) {
            DisplayElement element = this.getElement(offset + i);
            if (element == null) {
                element = DisplayElement.empty();
            }
            if (element.element() != null) {
                this.setSlot(i, element.element());
                continue;
            }
            if (element.slot() == null) continue;
            this.setSlotRedirect(i, element.slot());
        }
        for (i = 0; i < 9; ++i) {
            DisplayElement navElement = this.getNavElement(i);
            if (navElement == null) {
                navElement = DisplayElement.EMPTY;
            }
            if (navElement.element != null) {
                this.setSlot(i + 36, navElement.element);
                continue;
            }
            if (navElement.slot == null) continue;
            this.setSlotRedirect(i + 36, navElement.slot);
        }
    }

    protected int getPage() {
        return this.page;
    }

    protected abstract int getPageAmount();

    protected abstract DisplayElement getElement(int var1);

    protected DisplayElement getNavElement(int id) {
        return switch (id) {
            case 1 -> DisplayElement.previousPage(this);
            case 3 -> DisplayElement.nextPage(this);
            case 7 -> DisplayElement.of(new GuiElementBuilder(class_1802.field_8615).setName((class_2561)class_2561.method_43471((String)(this.closeCallback != null ? "text.goml.gui.back" : "text.goml.gui.close")).method_27692(class_124.field_1061)).hideDefaultTooltip().noDefaults().setCallback((x, y, z) -> {
                PagedGui.playClickSound(this.player);
                this.close(this.closeCallback != null);
            }));
            default -> DisplayElement.filler();
        };
    }

    public static final void playClickSound(class_3222 player) {
        player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15250, 1.0f, 1.0f);
    }

    public record DisplayElement(@Nullable GuiElementInterface element, @Nullable class_1735 slot) {
        private static final DisplayElement EMPTY = DisplayElement.of((GuiElementInterface)new GuiElement(class_1799.field_8037, GuiElementInterface.EMPTY_CALLBACK));
        private static final DisplayElement FILLER = DisplayElement.of(new GuiElementBuilder(class_1802.field_8736).setName((class_2561)class_2561.method_43473()).hideTooltip());

        public static DisplayElement of(GuiElementInterface element) {
            return new DisplayElement(element, null);
        }

        public static DisplayElement of(GuiElementBuilderInterface<?> element) {
            return new DisplayElement(element.build(), null);
        }

        public static DisplayElement of(class_1735 slot) {
            return new DisplayElement(null, slot);
        }

        public static DisplayElement nextPage(PagedGui gui) {
            if (gui.canNextPage()) {
                return DisplayElement.of(new GuiElementBuilder(class_1802.field_8575).setName((class_2561)class_2561.method_43471((String)"text.goml.gui.next_page").method_27692(class_124.field_1068)).hideDefaultTooltip().noDefaults().setSkullOwner("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzg2MTg1YjFkNTE5YWRlNTg1ZjE4NGMzNGYzZjNlMjBiYjY0MWRlYjg3OWU4MTM3OGU0ZWFmMjA5Mjg3In19fQ").setCallback((x, y, z) -> {
                    PagedGui.playClickSound(gui.player);
                    gui.nextPage();
                }));
            }
            return DisplayElement.of(new GuiElementBuilder(class_1802.field_8575).setName((class_2561)class_2561.method_43471((String)"text.goml.gui.next_page").method_27692(class_124.field_1063)).hideDefaultTooltip().noDefaults().setSkullOwner("ewogICJ0aW1lc3RhbXAiIDogMTY0MDYxNjExMDQ4OCwKICAicHJvZmlsZUlkIiA6ICIxZjEyNTNhYTVkYTQ0ZjU5YWU1YWI1NmFhZjRlNTYxNyIsCiAgInByb2ZpbGVOYW1lIiA6ICJOb3RNaUt5IiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzdlNTc3MjBhNDg3OGM4YmNhYjBlOWM5YzQ3ZDllNTUxMjhjY2Q3N2JhMzQ0NWE1NGE5MWUzZTFlMWEyNzM1NmUiLAogICAgICAibWV0YWRhdGEiIDogewogICAgICAgICJtb2RlbCIgOiAic2xpbSIKICAgICAgfQogICAgfQogIH0KfQ=="));
        }

        public static DisplayElement previousPage(PagedGui gui) {
            if (gui.canPreviousPage()) {
                return DisplayElement.of(new GuiElementBuilder(class_1802.field_8575).setName((class_2561)class_2561.method_43471((String)"text.goml.gui.previous_page").method_27692(class_124.field_1068)).hideDefaultTooltip().noDefaults().setSkullOwner("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzEwODI5OGZmMmIyNjk1MWQ2ODNlNWFkZTQ2YTQyZTkwYzJmN2M3ZGQ0MWJhYTkwOGJjNTg1MmY4YzMyZTU4MyJ9fX0").setCallback((x, y, z) -> {
                    PagedGui.playClickSound(gui.player);
                    gui.previousPage();
                }));
            }
            return DisplayElement.of(new GuiElementBuilder(class_1802.field_8575).setName((class_2561)class_2561.method_43471((String)"text.goml.gui.previous_page").method_27692(class_124.field_1063)).hideDefaultTooltip().noDefaults().setSkullOwner("ewogICJ0aW1lc3RhbXAiIDogMTY0MDYxNjE5MjE0MiwKICAicHJvZmlsZUlkIiA6ICJmMjc0YzRkNjI1MDQ0ZTQxOGVmYmYwNmM3NWIyMDIxMyIsCiAgInByb2ZpbGVOYW1lIiA6ICJIeXBpZ3NlbCIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS81MDgyMGY3NmUzZTA0MWM3NWY3NmQwZjMwMTIzMmJkZjQ4MzIxYjUzNGZlNmE4NTljY2I4NzNkMjk4MWE5NjIzIiwKICAgICAgIm1ldGFkYXRhIiA6IHsKICAgICAgICAibW9kZWwiIDogInNsaW0iCiAgICAgIH0KICAgIH0KICB9Cn0="));
        }

        public static DisplayElement filler() {
            return FILLER;
        }

        public static DisplayElement empty() {
            return EMPTY;
        }
    }
}

