/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.jddev0.ep.block.CableBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.EnergySyncS2CPacket;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import team.reborn.energy.api.EnergyStorage;

public class CableBlockEntity
extends class_2586 {
    private static final CableBlock.EnergyExtractionMode ENERGY_EXTRACTION_MODE = ModConfigs.COMMON_CABLES_ENERGY_EXTRACTION_MODE.getValue();
    private final CableBlock.Tier tier;
    final EnergizedPowerLimitingEnergyStorage limitingEnergyStorage;
    private final EnergizedPowerEnergyStorage energyStorage;
    private boolean loaded;
    private final Map<Pair<class_2338, class_2350>, EnergyStorage> producers = new HashMap<Pair<class_2338, class_2350>, EnergyStorage>();
    private final Map<Pair<class_2338, class_2350>, EnergyStorage> consumers = new HashMap<Pair<class_2338, class_2350>, EnergyStorage>();
    private final List<class_2338> cableBlocks = new LinkedList<class_2338>();

    public static class_2591<CableBlockEntity> getEntityTypeFromTier(CableBlock.Tier tier) {
        return switch (tier) {
            default -> throw new MatchException(null, null);
            case CableBlock.Tier.TIER_TIN -> ModBlockEntities.TIN_CABLE_ENTITY;
            case CableBlock.Tier.TIER_COPPER -> ModBlockEntities.COPPER_CABLE_ENTITY;
            case CableBlock.Tier.TIER_GOLD -> ModBlockEntities.GOLD_CABLE_ENTITY;
            case CableBlock.Tier.TIER_ENERGIZED_COPPER -> ModBlockEntities.ENERGIZED_COPPER_CABLE_ENTITY;
            case CableBlock.Tier.TIER_ENERGIZED_GOLD -> ModBlockEntities.ENERGIZED_GOLD_CABLE_ENTITY;
            case CableBlock.Tier.TIER_ENERGIZED_CRYSTAL_MATRIX -> ModBlockEntities.ENERGIZED_CRYSTAL_MATRIX_CABLE_ENTITY;
        };
    }

    public CableBlockEntity(class_2338 blockPos, class_2680 blockState, CableBlock.Tier tier) {
        super(CableBlockEntity.getEntityTypeFromTier(tier), blockPos, blockState);
        this.tier = tier;
        long capacity = ENERGY_EXTRACTION_MODE.isPush() ? tier.getMaxTransfer() : 0L;
        this.energyStorage = new EnergizedPowerEnergyStorage(capacity, capacity, capacity){

            protected void onFinalCommit() {
                CableBlockEntity.this.method_5431();
                if (CableBlockEntity.this.field_11863 != null && !CableBlockEntity.this.field_11863.method_8608()) {
                    ModMessages.sendServerPacketToPlayersWithinXBlocks(CableBlockEntity.this.method_11016(), (class_3218)CableBlockEntity.this.field_11863, 32.0, new EnergySyncS2CPacket(this.getAmount(), this.getCapacity(), CableBlockEntity.this.method_11016()));
                }
            }
        };
        this.limitingEnergyStorage = new EnergizedPowerLimitingEnergyStorage(this.energyStorage, capacity, 0L);
    }

    public CableBlock.Tier getTier() {
        return this.tier;
    }

    public Map<Pair<class_2338, class_2350>, EnergyStorage> getProducers() {
        return this.producers;
    }

    public Map<Pair<class_2338, class_2350>, EnergyStorage> getConsumers() {
        return this.consumers;
    }

    public List<class_2338> getCableBlocks() {
        return this.cableBlocks;
    }

    public static void updateConnections(class_1937 level, class_2338 blockPos, class_2680 state, CableBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        blockEntity.producers.clear();
        blockEntity.consumers.clear();
        blockEntity.cableBlocks.clear();
        for (class_2350 direction : class_2350.values()) {
            class_2338 testPos = blockPos.method_10093(direction);
            class_2586 testBlockEntity = level.method_8321(testPos);
            if (testBlockEntity == null) continue;
            if (testBlockEntity instanceof CableBlockEntity) {
                CableBlockEntity cableBlockEntity = (CableBlockEntity)testBlockEntity;
                if (cableBlockEntity.getTier() != blockEntity.getTier()) continue;
                blockEntity.cableBlocks.add(testPos);
                continue;
            }
            EnergyStorage limitingEnergyStorage = (EnergyStorage)EnergyStorage.SIDED.find(level, testPos, (Object)direction.method_10153());
            if (limitingEnergyStorage == null) continue;
            if (ENERGY_EXTRACTION_MODE.isPull() && limitingEnergyStorage.supportsExtraction()) {
                blockEntity.producers.put((Pair<class_2338, class_2350>)Pair.of((Object)testPos, (Object)direction.method_10153()), limitingEnergyStorage);
            }
            if (!limitingEnergyStorage.supportsInsertion()) continue;
            blockEntity.consumers.put((Pair<class_2338, class_2350>)Pair.of((Object)testPos, (Object)direction.method_10153()), limitingEnergyStorage);
        }
    }

    public static List<EnergyStorage> getConnectedConsumers(class_1937 level, class_2338 blockPos, List<class_2338> checkedCables) {
        LinkedList<EnergyStorage> consumers = new LinkedList<EnergyStorage>();
        LinkedList<class_2338> cableBlocksLeft = new LinkedList<class_2338>();
        cableBlocksLeft.add(blockPos);
        checkedCables.add(blockPos);
        while (cableBlocksLeft.size() > 0) {
            class_2338 checkPos = (class_2338)cableBlocksLeft.pop();
            class_2586 blockEntity = level.method_8321(checkPos);
            if (!(blockEntity instanceof CableBlockEntity)) continue;
            CableBlockEntity cableBlockEntity = (CableBlockEntity)blockEntity;
            cableBlockEntity.getCableBlocks().forEach(pos -> {
                if (!checkedCables.contains(pos)) {
                    checkedCables.add((class_2338)pos);
                    cableBlocksLeft.add((class_2338)pos);
                }
            });
            consumers.addAll(cableBlockEntity.getConsumers().values());
        }
        return consumers;
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, CableBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (!blockEntity.loaded) {
            CableBlockEntity.updateConnections(level, blockPos, state, blockEntity);
            blockEntity.loaded = true;
        }
        long MAX_TRANSFER = blockEntity.tier.getMaxTransfer();
        LinkedList<EnergyStorage> energyProduction = new LinkedList<EnergyStorage>();
        LinkedList<Long> energyProductionValues = new LinkedList<Long>();
        long productionSum = blockEntity.energyStorage.getAmount();
        for (EnergyStorage limitingEnergyStorage : blockEntity.producers.values()) {
            Transaction transaction = Transaction.openOuter();
            try {
                long extracted = limitingEnergyStorage.extract(MAX_TRANSFER, (TransactionContext)transaction);
                if (extracted <= 0L) continue;
                energyProduction.add(limitingEnergyStorage);
                energyProductionValues.add(extracted);
                productionSum += extracted;
            }
            finally {
                if (transaction == null) continue;
                transaction.close();
            }
        }
        if (productionSum <= 0L) {
            return;
        }
        LinkedList<EnergyStorage> energyConsumption = new LinkedList<EnergyStorage>();
        LinkedList<Long> energyConsumptionValues = new LinkedList<Long>();
        List<EnergyStorage> consumers = CableBlockEntity.getConnectedConsumers(level, blockPos, new LinkedList<class_2338>());
        long consumptionSum = 0L;
        for (EnergyStorage limitingEnergyStorage : consumers) {
            Transaction transaction = Transaction.openOuter();
            try {
                long received = limitingEnergyStorage.insert(MAX_TRANSFER, (TransactionContext)transaction);
                if (received <= 0L) continue;
                energyConsumption.add(limitingEnergyStorage);
                energyConsumptionValues.add(received);
                consumptionSum += received;
            }
            finally {
                if (transaction == null) continue;
                transaction.close();
            }
        }
        if (consumptionSum <= 0L) {
            return;
        }
        long transferLeft = Math.min(Math.min(MAX_TRANSFER, productionSum), consumptionSum);
        long extractInternally = 0L;
        if (ENERGY_EXTRACTION_MODE.isPush()) {
            extractInternally = Math.min(blockEntity.energyStorage.getAmount(), transferLeft);
            try (Transaction transaction = Transaction.openOuter();){
                blockEntity.energyStorage.extract(extractInternally, (TransactionContext)transaction);
                transaction.commit();
            }
        }
        LinkedList<Long> energyProductionDistributed = new LinkedList<Long>();
        for (int i = 0; i < energyProduction.size(); ++i) {
            energyProductionDistributed.add(0L);
        }
        long productionLeft = ENERGY_EXTRACTION_MODE.isPull() ? transferLeft - extractInternally : 0L;
        int divisor = energyProduction.size();
        block30: while (productionLeft > 0L) {
            long productionPerProducer = productionLeft / (long)divisor;
            if (productionPerProducer == 0L) {
                divisor = Math.max(1, divisor - 1);
                productionPerProducer = productionLeft / (long)divisor;
            }
            for (int i = 0; i < energyProductionValues.size(); ++i) {
                long productionDistributed = (Long)energyProductionDistributed.get(i);
                long productionOfProducerLeft = (Long)energyProductionValues.get(i) - productionDistributed;
                long productionDistributedNew = Math.min(productionPerProducer, Math.min(productionOfProducerLeft, productionLeft));
                energyProductionDistributed.set(i, productionDistributed + productionDistributedNew);
                if ((productionLeft -= productionDistributedNew) == 0L) break block30;
            }
        }
        for (int i = 0; i < energyProduction.size(); ++i) {
            long energy = (Long)energyProductionDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)energyProduction.get(i)).extract(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
        LinkedList<Long> energyConsumptionDistributed = new LinkedList<Long>();
        for (int i = 0; i < energyConsumption.size(); ++i) {
            energyConsumptionDistributed.add(0L);
        }
        long consumptionLeft = transferLeft;
        divisor = energyConsumption.size();
        block34: while (consumptionLeft > 0L) {
            long consumptionPerConsumer = consumptionLeft / (long)divisor;
            if (consumptionPerConsumer == 0L) {
                divisor = Math.max(1, divisor - 1);
                consumptionPerConsumer = consumptionLeft / (long)divisor;
            }
            for (int i = 0; i < energyConsumptionValues.size(); ++i) {
                long consumptionDistributed = (Long)energyConsumptionDistributed.get(i);
                long consumptionOfConsumerLeft = (Long)energyConsumptionValues.get(i) - consumptionDistributed;
                long consumptionDistributedNew = Math.min(consumptionOfConsumerLeft, Math.min(consumptionPerConsumer, consumptionLeft));
                energyConsumptionDistributed.set(i, consumptionDistributed + consumptionDistributedNew);
                if ((consumptionLeft -= consumptionDistributedNew) == 0L) break block34;
            }
        }
        for (int i = 0; i < energyConsumption.size(); ++i) {
            long energy = (Long)energyConsumptionDistributed.get(i);
            if (energy <= 0L) continue;
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergyStorage)energyConsumption.get(i)).insert(energy, (TransactionContext)transaction);
                transaction.commit();
                continue;
            }
        }
    }

    protected void method_11007(@NotNull class_2487 nbt, @NotNull class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        if (ENERGY_EXTRACTION_MODE.isPush()) {
            nbt.method_10544("energy", this.energyStorage.getAmount());
        }
    }

    public void method_11014(@NotNull class_2487 nbt, @NotNull class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        if (ENERGY_EXTRACTION_MODE.isPush()) {
            this.energyStorage.setAmountWithoutUpdate(nbt.method_10537("energy"));
        }
    }
}

