/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.List;
import me.jddev0.ep.block.ChargingStationBlock;
import me.jddev0.ep.block.entity.ModBlockEntities;
import me.jddev0.ep.block.entity.base.UpgradableEnergyStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.energy.EnergizedPowerEnergyStorage;
import me.jddev0.ep.energy.EnergizedPowerLimitingEnergyStorage;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.screen.ChargingStationMenu;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3341;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.EnergyStorageUtil;

public class ChargingStationBlockEntity
extends UpgradableEnergyStorageBlockEntity<EnergizedPowerEnergyStorage> {
    public static final int MAX_CHARGING_DISTANCE = ModConfigs.COMMON_CHARGING_STATION_MAX_CHARGING_DISTANCE.getValue();

    public ChargingStationBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ModBlockEntities.CHARGING_STATION_ENTITY, blockPos, blockState, "charging_station", ModConfigs.COMMON_CHARGING_STATION_CAPACITY.getValue(), ModConfigs.COMMON_CHARGING_STATION_TRANSFER_RATE.getValue(), UpgradeModuleModifier.ENERGY_CAPACITY, UpgradeModuleModifier.RANGE);
    }

    @Override
    protected EnergizedPowerEnergyStorage initEnergyStorage() {
        return new EnergizedPowerEnergyStorage(this.baseEnergyCapacity, this.baseEnergyCapacity, this.baseEnergyCapacity){

            @Override
            public long getCapacity() {
                return Math.max(1L, (long)Math.ceil((double)this.capacity * ChargingStationBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_CAPACITY)));
            }

            protected void onFinalCommit() {
                ChargingStationBlockEntity.this.method_5431();
                ChargingStationBlockEntity.this.syncEnergyToPlayers(32);
            }
        };
    }

    @Override
    protected EnergizedPowerLimitingEnergyStorage initLimitingEnergyStorage() {
        return new EnergizedPowerLimitingEnergyStorage(this.energyStorage, this.baseEnergyTransferRate, 0L){

            @Override
            public long getMaxInsert() {
                return Math.max(1L, (long)Math.ceil((double)this.maxInsert * ChargingStationBlockEntity.this.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.ENERGY_TRANSFER_RATE)));
            }
        };
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        return new ChargingStationMenu(id, this, inventory, this.upgradeModuleInventory);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, ChargingStationBlockEntity blockEntity) {
        long energyPerTick;
        if (level.method_8608()) {
            return;
        }
        int maxChargingDistance = (int)Math.ceil((double)MAX_CHARGING_DISTANCE * blockEntity.upgradeModuleInventory.getModifierEffectProduct(UpgradeModuleModifier.RANGE));
        List players = level.method_18023(class_5575.method_31795(class_1657.class), class_238.method_19316((class_3341)class_3341.method_34390((class_2382)new class_2382(blockPos.method_10263() - maxChargingDistance, blockPos.method_10264() - maxChargingDistance, blockPos.method_10260() - maxChargingDistance), (class_2382)new class_2382(blockPos.method_10263() + maxChargingDistance, blockPos.method_10264() + maxChargingDistance, blockPos.method_10260() + maxChargingDistance))), class_1301.field_6155.and(entity -> entity.method_5707(blockPos.method_46558()) <= (double)(maxChargingDistance * maxChargingDistance)));
        long energyPerTickLeft = energyPerTick = Math.min(blockEntity.limitingEnergyStorage.getMaxInsert(), ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).getAmount());
        block10: for (class_1657 player : players) {
            if (player.method_29504()) continue;
            class_1661 inventory = player.method_31548();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                EnergyStorage limitingEnergyStorage;
                class_1799 itemStack = inventory.method_5438(i);
                if (!EnergyStorageUtil.isEnergyStorage((class_1799)itemStack) || (limitingEnergyStorage = (EnergyStorage)EnergyStorage.ITEM.find(itemStack, (Object)ContainerItemContext.ofPlayerSlot((class_1657)inventory.field_7546, (SingleSlotStorage)((SingleSlotStorage)InventoryStorage.of((class_1263)inventory, null).getSlots().get(i))))) == null || !limitingEnergyStorage.supportsInsertion()) continue;
                try (Transaction transaction = Transaction.openOuter();){
                    energyPerTickLeft -= limitingEnergyStorage.insert(energyPerTickLeft, (TransactionContext)transaction);
                    transaction.commit();
                    if (energyPerTickLeft != 0L) continue;
                    break block10;
                }
            }
        }
        if (energyPerTickLeft == energyPerTick) {
            if (!level.method_8320(blockPos).method_28498((class_2769)ChargingStationBlock.CHARGING) || ((Boolean)level.method_8320(blockPos).method_11654((class_2769)ChargingStationBlock.CHARGING)).booleanValue()) {
                level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)ChargingStationBlock.CHARGING, (Comparable)Boolean.valueOf(false)), 3);
            }
        } else {
            if (!level.method_8320(blockPos).method_28498((class_2769)ChargingStationBlock.CHARGING) || !((Boolean)level.method_8320(blockPos).method_11654((class_2769)ChargingStationBlock.CHARGING)).booleanValue()) {
                level.method_8652(blockPos, (class_2680)state.method_11657((class_2769)ChargingStationBlock.CHARGING, (Comparable)Boolean.TRUE), 3);
            }
            try (Transaction transaction = Transaction.openOuter();){
                ((EnergizedPowerEnergyStorage)blockEntity.energyStorage).extract(energyPerTick - energyPerTickLeft, (TransactionContext)transaction);
                transaction.commit();
            }
        }
    }
}

