/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import me.jddev0.ep.block.entity.base.FluidStorageMethods;
import me.jddev0.ep.fluid.FluidStack;
import me.jddev0.ep.fluid.SimpleFluidStorage;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.FluidSyncS2CPacket;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public final class FluidStorageMultiTankMethods
implements FluidStorageMethods<CombinedStorage<FluidVariant, SimpleFluidStorage>> {
    public static final FluidStorageMultiTankMethods INSTANCE = new FluidStorageMultiTankMethods();

    private FluidStorageMultiTankMethods() {
    }

    @Override
    public void saveFluidStorage(@NotNull CombinedStorage<FluidVariant, SimpleFluidStorage> fluidStorage, @NotNull class_2487 nbt, @NotNull class_7225.class_7874 registries) {
        for (int i = 0; i < fluidStorage.parts.size(); ++i) {
            nbt.method_10566("fluid." + i, (class_2520)((SimpleFluidStorage)((Object)fluidStorage.parts.get(i))).getFluid().toNBT(new class_2487(), registries));
        }
    }

    @Override
    public void loadFluidStorage(@NotNull CombinedStorage<FluidVariant, SimpleFluidStorage> fluidStorage, @NotNull class_2487 nbt, @NotNull class_7225.class_7874 registries) {
        for (int i = 0; i < fluidStorage.parts.size(); ++i) {
            ((SimpleFluidStorage)((Object)fluidStorage.parts.get(i))).setFluid(FluidStack.fromNbt(nbt.method_10562("fluid." + i), registries));
        }
    }

    @Override
    public void syncFluidToPlayer(CombinedStorage<FluidVariant, SimpleFluidStorage> fluidStorage, class_1657 player, class_2338 pos) {
        for (int i = 0; i < fluidStorage.parts.size(); ++i) {
            ModMessages.sendServerPacketToPlayer((class_3222)player, new FluidSyncS2CPacket(i, ((SimpleFluidStorage)((Object)fluidStorage.parts.get(i))).getFluid(), ((SimpleFluidStorage)((Object)fluidStorage.parts.get(i))).getCapacity(), pos));
        }
    }

    @Override
    public void syncFluidToPlayers(CombinedStorage<FluidVariant, SimpleFluidStorage> fluidStorage, class_1937 level, class_2338 pos, int distance) {
        for (int i = 0; i < fluidStorage.parts.size(); ++i) {
            ModMessages.sendServerPacketToPlayersWithinXBlocks(pos, (class_3218)level, distance, new FluidSyncS2CPacket(i, ((SimpleFluidStorage)((Object)fluidStorage.parts.get(i))).getFluid(), ((SimpleFluidStorage)((Object)fluidStorage.parts.get(i))).getCapacity(), pos));
        }
    }

    @Override
    public FluidStack getFluid(CombinedStorage<FluidVariant, SimpleFluidStorage> fluidStorage, int tank) {
        return ((SimpleFluidStorage)((Object)fluidStorage.parts.get(tank))).getFluid();
    }

    @Override
    public long getTankCapacity(CombinedStorage<FluidVariant, SimpleFluidStorage> fluidStorage, int tank) {
        return ((SimpleFluidStorage)((Object)fluidStorage.parts.get(tank))).getCapacity();
    }

    @Override
    public void setFluid(CombinedStorage<FluidVariant, SimpleFluidStorage> fluidStorage, int tank, FluidStack fluidStack) {
        ((SimpleFluidStorage)((Object)fluidStorage.parts.get(tank))).setFluid(fluidStack);
    }

    @Override
    public void setTankCapacity(CombinedStorage<FluidVariant, SimpleFluidStorage> fluidStorage, int tank, long capacity) {
    }
}

