/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity.base;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import me.jddev0.ep.block.entity.base.FluidStorageMethods;
import me.jddev0.ep.block.entity.base.UpgradableMenuProvider;
import me.jddev0.ep.block.entity.base.WorkerFluidMachineBlockEntity;
import me.jddev0.ep.machine.configuration.ComparatorMode;
import me.jddev0.ep.machine.configuration.RedstoneMode;
import me.jddev0.ep.machine.upgrade.UpgradeModuleModifier;
import me.jddev0.ep.networking.ModMessages;
import me.jddev0.ep.networking.packet.SyncCurrentRecipeS2CPacket;
import me.jddev0.ep.recipe.ChangeCurrentRecipeIndexPacketUpdate;
import me.jddev0.ep.recipe.CurrentRecipePacketUpdate;
import me.jddev0.ep.recipe.SetCurrentRecipeIdPacketUpdate;
import me.jddev0.ep.util.ByteUtils;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectableRecipeFluidMachineBlockEntity<F extends Storage<FluidVariant>, C extends class_9695, R extends class_1860<C>>
extends WorkerFluidMachineBlockEntity<F, class_8786<R>>
implements ChangeCurrentRecipeIndexPacketUpdate,
CurrentRecipePacketUpdate<R>,
SetCurrentRecipeIdPacketUpdate {
    protected final UpgradableMenuProvider menuProvider;
    protected final class_3956<R> recipeType;
    protected final class_1865<R> recipeSerializer;
    protected class_2960 currentRecipeIdForLoad;
    protected class_8786<R> currentRecipe;

    public SelectableRecipeFluidMachineBlockEntity(class_2591<?> type, class_2338 blockPos, class_2680 blockState, String machineName, UpgradableMenuProvider menuProvider, int slotCount, class_3956<R> recipeType, class_1865<R> recipeSerializer, int baseRecipeDuration, long baseEnergyCapacity, long baseEnergyTransferRate, long baseEnergyConsumptionPerTick, FluidStorageMethods<F> fluidStorageMethods, long baseTankCapacity, UpgradeModuleModifier ... upgradeModifierSlots) {
        super(type, blockPos, blockState, machineName, slotCount, baseRecipeDuration, baseEnergyCapacity, baseEnergyTransferRate, baseEnergyConsumptionPerTick, fluidStorageMethods, baseTankCapacity, upgradeModifierSlots);
        this.menuProvider = menuProvider;
        this.recipeType = recipeType;
        this.recipeSerializer = recipeSerializer;
    }

    @Override
    protected class_3913 initContainerData() {
        return new class_3913(){

            public int method_17390(int index) {
                return switch (index) {
                    case 0, 1 -> ByteUtils.get2Bytes(SelectableRecipeFluidMachineBlockEntity.this.progress, index);
                    case 2, 3 -> ByteUtils.get2Bytes(SelectableRecipeFluidMachineBlockEntity.this.maxProgress, index - 2);
                    case 4, 5, 6, 7 -> ByteUtils.get2Bytes(SelectableRecipeFluidMachineBlockEntity.this.energyConsumptionLeft, index - 4);
                    case 8 -> {
                        if (SelectableRecipeFluidMachineBlockEntity.this.hasEnoughEnergy) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 9 -> SelectableRecipeFluidMachineBlockEntity.this.redstoneMode.ordinal();
                    case 10 -> SelectableRecipeFluidMachineBlockEntity.this.comparatorMode.ordinal();
                    default -> 0;
                };
            }

            public void method_17391(int index, int value) {
                switch (index) {
                    case 0: 
                    case 1: {
                        SelectableRecipeFluidMachineBlockEntity.this.progress = ByteUtils.with2Bytes(SelectableRecipeFluidMachineBlockEntity.this.progress, (short)value, index);
                        break;
                    }
                    case 2: 
                    case 3: {
                        SelectableRecipeFluidMachineBlockEntity.this.maxProgress = ByteUtils.with2Bytes(SelectableRecipeFluidMachineBlockEntity.this.maxProgress, (short)value, index - 2);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    case 9: {
                        SelectableRecipeFluidMachineBlockEntity.this.redstoneMode = RedstoneMode.fromIndex(value);
                        break;
                    }
                    case 10: {
                        SelectableRecipeFluidMachineBlockEntity.this.comparatorMode = ComparatorMode.fromIndex(value);
                    }
                }
            }

            public int method_17389() {
                return 11;
            }
        };
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt, @NotNull class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        if (this.currentRecipe != null) {
            nbt.method_10566("recipe.id", (class_2520)class_2519.method_23256((String)this.currentRecipe.comp_1932().toString()));
        }
    }

    @Override
    protected void method_11014(@NotNull class_2487 nbt, @NotNull class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        if (nbt.method_10545("recipe.id")) {
            this.currentRecipeIdForLoad = class_2960.method_12829((String)nbt.method_10558("recipe.id"));
        }
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncEnergyToPlayer(player);
        this.syncFluidToPlayer(player);
        this.syncCurrentRecipeToPlayer(player);
        return this.menuProvider.createMenu(id, this, inventory, (class_1263)this.itemHandler, this.upgradeModuleInventory, this.data);
    }

    @Override
    protected final void onTickStart() {
        if (this.currentRecipeIdForLoad != null) {
            List recipes = this.field_11863.method_8433().method_30027(this.recipeType);
            this.currentRecipe = recipes.stream().filter(recipe -> recipe.comp_1932().equals((Object)this.currentRecipeIdForLoad)).findFirst().orElse(null);
            this.currentRecipeIdForLoad = null;
        }
    }

    @Override
    protected Optional<class_8786<R>> getCurrentWorkData() {
        return Optional.ofNullable(this.currentRecipe);
    }

    @Override
    protected final double getWorkDataDependentWorkDuration(class_8786<R> workData) {
        return this.getRecipeDependentRecipeDuration(workData);
    }

    protected double getRecipeDependentRecipeDuration(class_8786<R> recipe) {
        return 1.0;
    }

    @Override
    protected final double getWorkDataDependentEnergyConsumption(class_8786<R> workData) {
        return this.getRecipeDependentEnergyConsumption(workData);
    }

    protected double getRecipeDependentEnergyConsumption(class_8786<R> recipe) {
        return 1.0;
    }

    @Override
    protected final boolean hasWork() {
        return this.hasRecipe();
    }

    protected boolean hasRecipe() {
        if (this.field_11863 == null || this.currentRecipe == null) {
            return false;
        }
        return this.canCraftRecipe(this.itemHandler, this.currentRecipe);
    }

    @Override
    protected final void onWorkStarted(class_8786<R> workData) {
        this.onStartCrafting(workData);
    }

    protected void onStartCrafting(class_8786<R> recipe) {
    }

    @Override
    protected final void onWorkCompleted(class_8786<R> workData) {
        this.craftItem(workData);
    }

    protected abstract void craftItem(class_8786<R> var1);

    protected abstract boolean canCraftRecipe(class_1277 var1, class_8786<R> var2);

    @Override
    public void changeRecipeIndex(boolean downUp) {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        List<class_8786> recipes = this.field_11863.method_8433().method_30027(this.recipeType);
        recipes = recipes.stream().sorted(Comparator.comparing(recipe -> recipe.comp_1933().method_8110((class_7225.class_7874)this.field_11863.method_30349()).method_7922())).toList();
        int currentIndex = -1;
        if (this.currentRecipe != null) {
            for (int i = 0; i < recipes.size(); ++i) {
                if (!this.currentRecipe.comp_1932().equals((Object)recipes.get(i).comp_1932())) continue;
                currentIndex = i;
                break;
            }
        }
        if ((currentIndex += downUp ? 1 : -1) < -1) {
            currentIndex = recipes.size() - 1;
        } else if (currentIndex >= recipes.size()) {
            currentIndex = -1;
        }
        this.currentRecipe = currentIndex == -1 ? null : recipes.get(currentIndex);
        this.resetProgress();
        this.method_5431();
        this.syncCurrentRecipeToPlayers(32);
    }

    @Override
    public void setRecipeId(class_2960 recipeId) {
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        if (recipeId == null) {
            this.currentRecipe = null;
        } else {
            List recipes = this.field_11863.method_8433().method_30027(this.recipeType);
            Optional<class_8786> recipe = recipes.stream().filter(r -> r.comp_1932().equals((Object)recipeId)).findFirst();
            this.currentRecipe = recipe.orElse(null);
        }
        this.resetProgress();
        this.method_5431();
        this.syncCurrentRecipeToPlayers(32);
    }

    protected final void syncCurrentRecipeToPlayer(class_1657 player) {
        ModMessages.sendServerPacketToPlayer((class_3222)player, new SyncCurrentRecipeS2CPacket<R>(this.method_11016(), this.recipeSerializer, this.currentRecipe));
    }

    protected final void syncCurrentRecipeToPlayers(int distance) {
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            ModMessages.sendServerPacketToPlayersWithinXBlocks(this.method_11016(), (class_3218)this.field_11863, distance, new SyncCurrentRecipeS2CPacket<R>(this.method_11016(), this.recipeSerializer, this.currentRecipe));
        }
    }

    @Nullable
    public class_8786<R> getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Override
    public void setCurrentRecipe(@Nullable class_8786<R> currentRecipe) {
        this.currentRecipe = currentRecipe;
    }
}

