/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.energy;

import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import team.reborn.energy.api.EnergyStorage;

public class EnergizedPowerLimitingEnergyStorage
implements EnergyStorage {
    protected EnergyStorage backingStorage;
    protected long maxInsert;
    protected long maxExtract;

    public EnergizedPowerLimitingEnergyStorage(EnergyStorage backingStorage, long maxInsert, long maxExtract) {
        Objects.requireNonNull(backingStorage);
        StoragePreconditions.notNegative((long)maxInsert);
        StoragePreconditions.notNegative((long)maxExtract);
        this.backingStorage = backingStorage;
        this.maxInsert = maxInsert;
        this.maxExtract = maxExtract;
    }

    public long getMaxInsert() {
        return this.maxInsert;
    }

    public long getMaxExtract() {
        return this.maxExtract;
    }

    public boolean supportsInsertion() {
        return this.getMaxInsert() > 0L && this.backingStorage.supportsInsertion();
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        return this.backingStorage.insert(Math.min(maxAmount, this.getMaxInsert()), transaction);
    }

    public boolean supportsExtraction() {
        return this.getMaxExtract() > 0L && this.backingStorage.supportsExtraction();
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        return this.backingStorage.extract(Math.min(maxAmount, this.getMaxExtract()), transaction);
    }

    public long getAmount() {
        return this.backingStorage.getAmount();
    }

    public long getCapacity() {
        return this.backingStorage.getCapacity();
    }
}

