/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.item.energy;

import me.jddev0.ep.item.energy.EnergizedPowerEnergyItem;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import team.reborn.energy.api.EnergyStorage;

public class EnergizedPowerEnergyItemStorage
implements EnergyStorage {
    private final ContainerItemContext ctx;
    private final long capacity;
    private final long maxInsert;
    private final long maxExtract;

    public EnergizedPowerEnergyItemStorage(ContainerItemContext ctx, long capacity, long maxInsert, long maxExtract) {
        this.ctx = ctx;
        this.capacity = capacity;
        this.maxInsert = maxInsert;
        this.maxExtract = maxExtract;
    }

    private boolean trySetEnergy(class_1799 itemStack, long amount, TransactionContext transaction) {
        EnergizedPowerEnergyItem.setStoredEnergyUnchecked(itemStack, amount);
        ItemVariant newVariant = ItemVariant.of((class_1799)itemStack);
        try (Transaction nested = transaction.openNested();){
            if (this.ctx.extract(this.ctx.getItemVariant(), 1L, (TransactionContext)nested) == 1L && this.ctx.insert(newVariant, 1L, (TransactionContext)nested) == 1L) {
                nested.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean supportsInsertion() {
        return this.maxInsert > 0L;
    }

    public long insert(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        class_1799 itemStack = this.ctx.getItemVariant().toStack();
        long amount = EnergizedPowerEnergyItem.getStoredEnergyUnchecked(itemStack);
        long inserted = Math.min(this.maxInsert, Math.min(maxAmount, this.capacity - amount));
        if (inserted > 0L && this.trySetEnergy(itemStack, amount + inserted, transaction)) {
            return inserted;
        }
        return 0L;
    }

    public boolean supportsExtraction() {
        return this.maxExtract > 0L;
    }

    public long extract(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        class_1799 itemStack = this.ctx.getItemVariant().toStack();
        long amount = EnergizedPowerEnergyItem.getStoredEnergyUnchecked(itemStack);
        long extracted = Math.min(this.maxExtract, Math.min(maxAmount, amount));
        if (extracted > 0L && this.trySetEnergy(itemStack, amount - extracted, transaction)) {
            return extracted;
        }
        return 0L;
    }

    public long getAmount() {
        return EnergizedPowerEnergyItem.getStoredEnergyUnchecked(this.ctx.getItemVariant().toStack());
    }

    public long getCapacity() {
        return this.capacity;
    }
}

