/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.loading;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import me.jddev0.ep.screen.EnergizedPowerBookScreen;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class EnergizedPowerBookReloadListener
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"energizedpower", (String)"energizedpowerbook");
    }

    public EnergizedPowerBookReloadListener() {
        super(new GsonBuilder().create(), "book_pages");
    }

    protected void apply(Map<class_2960, JsonElement> elements, class_3300 resourceManager, class_3695 profilerFiller) {
        class_7225.class_7874 registries = new class_7225.class_7874(this){

            public Stream<class_5321<? extends class_2378<?>>> method_55282() {
                return Stream.empty();
            }

            public <T> Optional<class_7225.class_7226<T>> method_46759(class_5321<? extends class_2378<? extends T>> registryRef) {
                return Optional.empty();
            }
        };
        LinkedList<EnergizedPowerBookScreen.PageContent> pages = new LinkedList<EnergizedPowerBookScreen.PageContent>();
        List<Map.Entry> elementEntries = elements.entrySet().stream().sorted(Comparator.comparing(o -> ((class_2960)o.getKey()).method_12832())).toList();
        block2: for (Map.Entry elementEntry : elementEntries) {
            class_2960 pageId = (class_2960)elementEntry.getKey();
            JsonElement element = (JsonElement)elementEntry.getValue();
            try {
                if (!element.isJsonObject()) {
                    LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': Element must be a JSON Object", pageId.method_12832(), pageId.method_12836()));
                    continue;
                }
                JsonObject object = element.getAsJsonObject();
                if (object.has("remove")) {
                    JsonElement pageToRemoveElement = object.get("remove");
                    if (!pageToRemoveElement.isJsonPrimitive() || !pageToRemoveElement.getAsJsonPrimitive().isString()) {
                        LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': remove must be a string primitive", pageId.method_12832(), pageId.method_12836()));
                        continue;
                    }
                    class_2960 pageToRemove = class_2960.method_12829((String)pageToRemoveElement.getAsJsonPrimitive().getAsString());
                    if (pageToRemove == null) continue;
                    boolean containsKeyFlag = false;
                    for (int i = pages.size() - 1; i >= 0; --i) {
                        if (!((EnergizedPowerBookScreen.PageContent)pages.get(i)).getPageId().equals((Object)pageToRemove)) continue;
                        containsKeyFlag = true;
                        pages.remove(i);
                        break;
                    }
                    if (containsKeyFlag) continue;
                    LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': page to be removed was not found", pageId.method_12832(), pageId.method_12836()));
                    continue;
                }
                class_5250 chapterTitleComponent = null;
                if (object.has("title")) {
                    chapterTitleComponent = class_2561.class_2562.method_10872((JsonElement)object.get("title"), (class_7225.class_7874)registries);
                }
                class_5250 contentComponent = null;
                if (object.has("content")) {
                    contentComponent = class_2561.class_2562.method_10872((JsonElement)object.get("content"), (class_7225.class_7874)registries);
                }
                class_2960[] imageResourceLocations = null;
                if (object.has("image")) {
                    JsonElement imageElement = object.get("image");
                    if (imageElement.isJsonPrimitive()) {
                        if (!imageElement.getAsJsonPrimitive().isString()) {
                            LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': image must be a string primitive or an array of string primitives", pageId.method_12832(), pageId.method_12836()));
                            continue;
                        }
                        imageResourceLocations = new class_2960[]{class_2960.method_12829((String)imageElement.getAsJsonPrimitive().getAsString())};
                    } else if (imageElement.isJsonArray()) {
                        JsonArray imageJsonArray = imageElement.getAsJsonArray();
                        if (imageJsonArray.isEmpty()) {
                            LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': Image array must contain at least one element", pageId.method_12832(), pageId.method_12836()));
                            continue;
                        }
                        ArrayList<class_2960> imageResourceLocationList = new ArrayList<class_2960>(imageJsonArray.size());
                        for (JsonElement imageJsonEle : imageJsonArray) {
                            if (!imageJsonEle.isJsonPrimitive() || !imageJsonEle.getAsJsonPrimitive().isString()) {
                                LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': image must be a string primitive or an array of string primitives", pageId.method_12832(), pageId.method_12836()));
                                continue block2;
                            }
                            imageResourceLocationList.add(class_2960.method_12829((String)imageJsonEle.getAsJsonPrimitive().getAsString()));
                        }
                        imageResourceLocations = imageResourceLocationList.toArray(new class_2960[0]);
                    } else {
                        LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': image must be a string primitive or an array of string primitives", pageId.method_12832(), pageId.method_12836()));
                        continue;
                    }
                }
                class_2960[] blockResourceLocations = null;
                if (object.has("block")) {
                    JsonElement blockElement = object.get("block");
                    if (blockElement.isJsonPrimitive()) {
                        if (!blockElement.getAsJsonPrimitive().isString()) {
                            LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': block must be a string primitive or an array of string primitives", pageId.method_12832(), pageId.method_12836()));
                            continue;
                        }
                        blockResourceLocations = new class_2960[]{class_2960.method_12829((String)blockElement.getAsJsonPrimitive().getAsString())};
                    } else if (blockElement.isJsonArray()) {
                        JsonArray blockJsonArray = blockElement.getAsJsonArray();
                        if (blockJsonArray.isEmpty()) {
                            LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': Block array must contain at least one element", pageId.method_12832(), pageId.method_12836()));
                            continue;
                        }
                        ArrayList<class_2960> blockResourceLocationsList = new ArrayList<class_2960>(blockJsonArray.size());
                        for (JsonElement blockJsonEle : blockJsonArray) {
                            if (!blockJsonEle.isJsonPrimitive() || !blockJsonEle.getAsJsonPrimitive().isString()) {
                                LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': block must be a string primitive or an array of string primitives", pageId.method_12832(), pageId.method_12836()));
                                continue block2;
                            }
                            blockResourceLocationsList.add(class_2960.method_12829((String)blockJsonEle.getAsJsonPrimitive().getAsString()));
                        }
                        blockResourceLocations = blockResourceLocationsList.toArray(new class_2960[0]);
                    } else {
                        LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s': block must be a string primitive or an array of string primitives", pageId.method_12832(), pageId.method_12836()));
                        continue;
                    }
                }
                pages.add(new EnergizedPowerBookScreen.PageContent(pageId, (class_2561)chapterTitleComponent, (class_2561)contentComponent, imageResourceLocations, blockResourceLocations));
            }
            catch (Exception e) {
                LOGGER.error(String.format("Failed to load energized power book page '%s' from data pack '%s'", pageId.method_12832(), pageId.method_12836()), (Throwable)e);
            }
        }
        EnergizedPowerBookScreen.setPages(pages);
    }
}

